/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import com.xkball.auto_translate.XATConfig;
import com.xkball.auto_translate.client.gui.frame.core.IPanel;
import com.xkball.auto_translate.client.gui.screen.XATConfigScreen;
import com.xkball.auto_translate.data.XATDataBase;
import com.xkball.auto_translate.utils.VanillaUtils;
import com.xkball.auto_translate.utils.translate.LangKeyTranslateUnit;
import com.xkball.auto_translate.utils.translate.TranslatorType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.commands.Commands;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.slf4j.Logger;

@Mod(value="xkball_s_auto_translate", dist={Dist.CLIENT})
@EventBusSubscriber
public class AutoTranslate {
    public static final String MODID = "xkball_s_auto_translate";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final boolean IS_DEBUG = SharedConstants.IS_RUNNING_WITH_JDWP;

    public AutoTranslate(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)XATConfig.SPEC);
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)XATConfigScreen::new));
    }

    public static void updateLanguageMap(ResourceManager resourceManager) {
        if (XATDataBase.INSTANCE.isEnableInjectLang()) {
            AutoTranslate.injectLanguage();
        }
    }

    @SubscribeEvent
    public static void onPlayerEnterWorld(ClientPlayerNetworkEvent.LoggingIn event) {
        LocalPlayer player = event.getPlayer();
        boolean flag = false;
        if (XATConfig.TRANSLATOR_TYPE == TranslatorType.DEFAULT) {
            flag = true;
            player.displayClientMessage((Component)Component.translatable((String)"xat.warn").withStyle(ChatFormatting.WHITE).append((Component)Component.translatable((String)"xat.warn.no_translator").withStyle(ChatFormatting.RED)), false);
        }
        if (!XATDataBase.INSTANCE.isEnableInjectLang()) {
            flag = true;
            player.displayClientMessage((Component)Component.translatable((String)"xat.warn").withStyle(ChatFormatting.WHITE).append((Component)Component.translatable((String)"xat.warn.no_inject").withStyle(ChatFormatting.RED)), false);
        }
        if (flag) {
            player.displayClientMessage((Component)Component.translatable((String)"xat.warn").withStyle(ChatFormatting.WHITE).append((Component)Component.translatable((String)"xat.warn.open_config_screen").withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/xat open_config_screen")))), false);
        }
    }

    @SubscribeEvent
    public static void onRegClientCommand(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"xat").then(Commands.literal((String)"open_config_screen").executes(s -> {
            Minecraft.getInstance().setScreen((Screen)new XATConfigScreen(null, null));
            return 0;
        })));
    }

    public static void injectLanguage() {
        LOGGER.info("Injecting language.");
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(Language.getInstance().getLanguageData());
        map.putAll(LangKeyTranslateUnit.I18N_KEYS.toMap());
        boolean defaultRightToLeft = Language.getInstance().isDefaultRightToLeft();
        ClientLanguage clientLang = new ClientLanguage(map, defaultRightToLeft, Map.of());
        I18n.setLanguage((Language)clientLang);
        Language.inject((Language)clientLang);
        Minecraft.getInstance().getLanguageManager().reloadCallback.accept(clientLang);
        IPanel.GLOBAL_UPDATE_MARKER.setNeedUpdate();
    }

    public static void cancelInjectLanguage() {
        LanguageInfo languageinfo;
        LOGGER.info("Cancel Inject language.");
        LanguageManager langManger = Minecraft.getInstance().getLanguageManager();
        String currentCode = langManger.getSelected();
        ArrayList<String> list = new ArrayList<String>(2);
        boolean flag = Objects.requireNonNull(langManger.getLanguage("en_us")).bidirectional();
        list.add("en_us");
        if (!currentCode.equals("en_us") && (languageinfo = langManger.getLanguage(currentCode)) != null) {
            list.add(currentCode);
            flag = languageinfo.bidirectional();
        }
        ClientLanguage clientlanguage = ClientLanguage.loadFrom((ResourceManager)Minecraft.getInstance().getResourceManager(), list, (boolean)flag);
        I18n.setLanguage((Language)clientlanguage);
        Language.inject((Language)clientlanguage);
        Minecraft.getInstance().getLanguageManager().reloadCallback.accept(clientlanguage);
    }

    @EventBusSubscriber(modid="xkball_s_auto_translate", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }

        @SubscribeEvent
        public static void onResourceReload(AddClientReloadListenersEvent event) {
            event.addListener(VanillaUtils.modRL("update_language_map"), (PreparableReloadListener)((ResourceManagerReloadListener)AutoTranslate::updateLanguageMap));
        }
    }
}

