/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.client.gui.frame.core.render;

import com.xkball.auto_translate.client.gui.frame.core.render.IGUIDecoRenderer;
import com.xkball.auto_translate.utils.VanillaUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class GuiDecorations {
    public static final IGUIDecoRenderer BOTTOM_DARK_BORDER_LINE = (guiGraphics, boundary, mouseX, mouseY, partialTick) -> {
        guiGraphics.hLine(boundary.outer().x(), boundary.outer().maxX(), boundary.outer().maxY() - 1, VanillaUtils.getColor(240, 240, 240, 255));
        guiGraphics.hLine(boundary.outer().x(), boundary.outer().maxX(), boundary.outer().maxY(), VanillaUtils.getColor(20, 20, 20, 255));
    };
    public static final IGUIDecoRenderer RIGHT_DARK_BORDER_LINE = (guiGraphics, boundary, mouseX, mouseY, partialTick) -> {
        guiGraphics.vLine(boundary.outer().maxX() - 1, boundary.outer().y(), boundary.outer().maxY(), VanillaUtils.getColor(240, 240, 240, 255));
        guiGraphics.vLine(boundary.outer().maxX(), boundary.outer().y(), boundary.outer().maxY(), VanillaUtils.getColor(20, 20, 20, 255));
    };
    public static final IGUIDecoRenderer WHITE_BORDER = (guiGraphics, boundary, mouseX, mouseY, partialTick) -> guiGraphics.renderOutline(boundary.inner().x(), boundary.inner().y(), boundary.inner().width(), boundary.inner().height(), -1);
    public static final IGUIDecoRenderer GRAY_BORDER = (guiGraphics, boundary, mouseX, mouseY, partialTick) -> guiGraphics.renderOutline(boundary.inner().x(), boundary.inner().y(), boundary.inner().width(), boundary.inner().height(), VanillaUtils.getColor(160, 160, 160, 200));

    private static void drawString(GuiGraphics guiGraphics, Font font, Component text, int x, int y, int color, boolean dropShadow, float scale) {
        if (scale != 1.0f) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(scale, scale, 1.0f);
            guiGraphics.drawString(font, text.getVisualOrderText(), (int)((float)x / scale), (int)((float)y / scale), color, dropShadow);
            guiGraphics.pose().popPose();
        } else {
            guiGraphics.drawString(font, text, x, y, color, dropShadow);
        }
    }

    public static IGUIDecoRenderer leftCenterString(Component text) {
        return GuiDecorations.leftCenterString(text, -1, true, 1.0f);
    }

    public static IGUIDecoRenderer leftCenterString(Component text, int color, boolean dropShadow, float scale) {
        return (guiGraphics, boundary, mouseX, mouseY, partialTick) -> {
            Font font = Minecraft.getInstance().font;
            int length = font.width((FormattedText)text);
            int x = boundary.inner().x() - length - 8;
            int y = boundary.inner().y() + boundary.inner().height() / 2 - 4;
            GuiDecorations.drawString(guiGraphics, font, text, x, y, color, dropShadow, scale);
        };
    }

    public static IGUIDecoRenderer bottomLeftString(Component text) {
        return GuiDecorations.bottomLeftString(text, -1, true, 1.0f);
    }

    public static IGUIDecoRenderer bottomLeftString(Component text, int color, boolean dropShadow, float scale) {
        return (guiGraphics, boundary, mouseX, mouseY, partialTick) -> {
            Font font = Minecraft.getInstance().font;
            GuiDecorations.drawString(guiGraphics, font, text, boundary.inner().x(), boundary.inner().maxY() + 1, color, dropShadow, scale);
        };
    }

    public static IGUIDecoRenderer bottomCenterString(Component text) {
        return GuiDecorations.bottomCenterString(text, -1, true, 1.0f);
    }

    public static IGUIDecoRenderer bottomCenterString(Component text, int color, boolean dropShadow, float scale) {
        return (guiGraphics, boundary, mouseX, mouseY, partialTick) -> {
            Font font = Minecraft.getInstance().font;
            int length = font.width((FormattedText)text);
            int x = boundary.inner().x() + boundary.inner().width() / 2 - length / 2;
            GuiDecorations.drawString(guiGraphics, font, text, x, boundary.inner().maxY() + 1, color, dropShadow, scale);
        };
    }
}

