/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.client.gui.frame.screen;

import com.xkball.auto_translate.AutoTranslate;
import com.xkball.auto_translate.client.gui.frame.core.HorizontalAlign;
import com.xkball.auto_translate.client.gui.frame.core.IPanel;
import com.xkball.auto_translate.client.gui.frame.core.IUpdateMarker;
import com.xkball.auto_translate.client.gui.frame.core.PanelConfig;
import com.xkball.auto_translate.client.gui.frame.core.VerticalAlign;
import com.xkball.auto_translate.client.gui.frame.core.render.GuiDecorations;
import com.xkball.auto_translate.client.gui.frame.core.render.SimpleBackgroundRenderer;
import com.xkball.auto_translate.client.gui.frame.widget.BlankWidget;
import com.xkball.auto_translate.client.gui.frame.widget.Label;
import com.xkball.auto_translate.client.gui.frame.widget.basic.AutoResizeWidgetWrapper;
import com.xkball.auto_translate.client.gui.frame.widget.basic.HorizontalPanel;
import com.xkball.auto_translate.client.gui.frame.widget.basic.VerticalPanel;
import com.xkball.auto_translate.client.gui.widget.ObjectInputBox;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLPaths;

public class FrameScreen
extends Screen
implements IUpdateMarker {
    public static final float THE_SCALE = 0.3731f;
    protected volatile boolean needUpdate = false;
    protected final Queue<Runnable> renderTasks = new ConcurrentLinkedQueue<Runnable>();

    public FrameScreen(Component title) {
        super(title);
    }

    public void updateScreen() {
        for (GuiEventListener child : this.children()) {
            if (!(child instanceof IPanel)) continue;
            IPanel panel = (IPanel)child;
            panel.update(this);
        }
    }

    @Override
    public void setNeedUpdate() {
        this.needUpdate = true;
    }

    @Override
    public boolean needUpdate() {
        return this.needUpdate;
    }

    public void tick() {
        super.tick();
        if (this.needUpdate) {
            this.needUpdate = false;
            this.updateScreen();
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        IPanel.DebugLine.drawAllDebugLines(guiGraphics);
        while (!this.renderTasks.isEmpty()) {
            this.renderTasks.poll().run();
        }
        if (AutoTranslate.IS_DEBUG && Minecraft.getInstance().getDebugOverlay().showDebugScreen()) {
            guiGraphics.drawString(this.font, mouseX + ":" + mouseY, 10, 10, -1);
        }
    }

    public void submitRenderTask(Runnable runnable) {
        this.renderTasks.add(runnable);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public <T extends AbstractWidget> VerticalPanel screenFrame(String titleTransKey, T content) {
        VerticalPanel screen = PanelConfig.of().align(HorizontalAlign.LEFT, VerticalAlign.TOP).apply(VerticalPanel.of(this));
        screen.addWidget(PanelConfig.of(1.0f, 0.04f).align(HorizontalAlign.CENTER, VerticalAlign.CENTER).sizeLimitYMin(25).decoRenderer(SimpleBackgroundRenderer.GRAY).decoRenderer(GuiDecorations.BOTTOM_DARK_BORDER_LINE).apply(new HorizontalPanel().addWidget(PanelConfig.of().trim().apply(Label.of((Component)Component.translatable((String)titleTransKey), 1.5f))).addWidget(PanelConfig.of().fixHeight(20).fixWidth(20).tooltip("xat.gui.open_config_file").apply(FrameScreen.iconButton(btn -> Util.getPlatform().openFile(FMLPaths.CONFIGDIR.get().resolve("xkball_s_auto_translate-common.toml").toFile()), ResourceLocation.withDefaultNamespace((String)"toast/recipe_book")))))).addWidget(PanelConfig.of(1.0f, 0.92f).sizeLimitYMax(this.height - 40).decoRenderer(GuiDecorations.BOTTOM_DARK_BORDER_LINE).apply(AutoResizeWidgetWrapper.of(content))).addWidget(PanelConfig.of(1.0f, 0.04f).sizeLimitYMin(15).decoRenderer(SimpleBackgroundRenderer.GRAY).apply(new BlankWidget()));
        return screen;
    }

    public AutoResizeWidgetWrapper createEditBox(Supplier<String> valueGetter, Consumer<String> valueSetter) {
        return this.createEditBox(() -> new EditBox(this.font, 0, 0, 0, 0, (Component)Component.empty()), valueGetter, valueSetter);
    }

    public AutoResizeWidgetWrapper createEditBox(Supplier<? extends EditBox> editBoxSupplier, Supplier<String> valueGetter, Consumer<String> valueSetter) {
        EditBox editBox = editBoxSupplier.get();
        FrameScreen.setupSimpleEditBox(editBox);
        editBox.setValue(valueGetter.get());
        editBox.displayPos = 0;
        editBox.setResponder(str -> {
            valueSetter.accept((String)str);
            this.setNeedUpdate();
        });
        return new AutoResizeWidgetWrapper((AbstractWidget)editBox);
    }

    public <T> AutoResizeWidgetWrapper createObjInputBox(Predicate<String> validator, Function<String, T> responder, Consumer<T> valueSetter) {
        ObjectInputBox editBox = new ObjectInputBox(this.font, 0, 0, 0, 0, (Component)Component.empty(), validator, responder);
        FrameScreen.setupSimpleEditBox(editBox);
        editBox.setResponder(str -> {
            valueSetter.accept(editBox.get());
            this.setNeedUpdate();
        });
        return new AutoResizeWidgetWrapper((AbstractWidget)editBox);
    }

    public static void setupSimpleEditBox(EditBox editBox) {
        editBox.setMaxLength(114514);
        editBox.setCanLoseFocus(true);
        editBox.scrollTo(0);
    }

    public static AutoResizeWidgetWrapper iconButton(Button.OnPress onPress, ResourceLocation sprite) {
        SpriteIconButton btn = SpriteIconButton.builder((Component)Component.empty(), (Button.OnPress)onPress, (boolean)true).sprite(sprite, 16, 16).build();
        return AutoResizeWidgetWrapper.of((AbstractWidget)btn);
    }

    public static AutoResizeWidgetWrapper createCheckBox(Component message, BooleanSupplier valueGetter, BooleanConsumer valueSetter) {
        Checkbox checkBox = Checkbox.builder((Component)message, (Font)Minecraft.getInstance().font).onValueChange((c, b) -> valueSetter.accept(b)).build();
        if (valueGetter.getAsBoolean() != checkBox.selected()) {
            checkBox.onPress();
        }
        return AutoResizeWidgetWrapper.of((AbstractWidget)checkBox);
    }

    public static AutoResizeWidgetWrapper createButton(String message, Runnable onPress) {
        Button button = Button.builder((Component)Component.translatable((String)message), btn -> onPress.run()).build();
        return AutoResizeWidgetWrapper.of((AbstractWidget)button);
    }
}

