/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.client.gui.frame.widget;

import com.xkball.auto_translate.client.gui.frame.core.IUpdateMarker;
import com.xkball.auto_translate.client.gui.frame.core.WidgetPos;
import com.xkball.auto_translate.client.gui.frame.widget.basic.AutoResizeWidget;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class Label
extends AutoResizeWidget {
    private float scale;
    public int color = -1;
    public boolean dropShadow = true;
    private int length;

    public static Label of(String str) {
        return Label.of((Component)Component.literal((String)str));
    }

    public static Label ofKey(String str) {
        return Label.of((Component)Component.translatable((String)str));
    }

    public static Label ofKey(String str, float scale) {
        return Label.of((Component)Component.translatable((String)str), scale);
    }

    public static Label of(Component message) {
        return Label.of(message, 1.0f);
    }

    public static Label of(Supplier<Component> message) {
        return Label.of(message, 1.0f);
    }

    public static Label of(Component message, float scale) {
        return new Label(message, scale, -1, true);
    }

    public static Label of(Supplier<Component> message, float scale) {
        return new DynamicLabel(message, scale, -1, true);
    }

    public Label(Component message, float scale, int color, boolean dropShadow) {
        super(message);
        this.setScale(scale);
        this.color = color;
        this.dropShadow = dropShadow;
    }

    protected boolean isValidClickButton(int button) {
        return false;
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(this.scale, this.scale, 1.0f);
        WidgetPos boundary = this.getBoundary().inner();
        Font font = Minecraft.getInstance().font;
        if (boundary.width() < this.length) {
            Label.renderScrollingString(guiGraphics, font, this.getMessage(), (int)((float)boundary.x() / this.scale), (int)((float)boundary.y() / this.scale), (int)((float)boundary.maxX() / this.scale), (int)((float)boundary.maxY() / this.scale), this.color, this.dropShadow);
        } else {
            guiGraphics.drawString(font, this.getMessage().getVisualOrderText(), (int)((float)boundary.x() / this.scale), (int)((float)boundary.y() / this.scale), this.color, this.dropShadow);
        }
        guiGraphics.pose().popPose();
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component text, int minX, int minY, int maxX, int maxY, int color, boolean dropShadow) {
        Label.renderScrollingString(guiGraphics, font, text, (minX + maxX) / 2, minX, minY, maxX, maxY, color, dropShadow);
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component text, int centerX, int minX, int minY, int maxX, int maxY, int color, boolean dropShadow) {
        int i = font.width((FormattedText)text);
        int j = (minY + maxY - 9) / 2 + 1;
        int k = maxX - minX;
        if (i > k) {
            int l = i - k;
            double d0 = (double)Util.getMillis() / 1000.0;
            double d1 = Math.max((double)l * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double d3 = Mth.lerp((double)d2, (double)0.0, (double)l);
            guiGraphics.enableScissor(minX, 0, maxX, Integer.MAX_VALUE);
            guiGraphics.drawString(font, text, minX - (int)d3, j, color);
            guiGraphics.disableScissor();
        } else {
            int i1 = Mth.clamp((int)centerX, (int)(minX + i / 2), (int)(maxX - i / 2));
            guiGraphics.drawCenteredString(font, text, i1, j, color);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, this.getMessage());
    }

    public void setMessage(Component message) {
        super.setMessage(message);
        this.setScale(this.scale);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
        Font font = Minecraft.getInstance().font;
        this.length = font.width((FormattedText)this.getMessage());
        this.setFixWidth((int)((float)this.length * scale));
        Objects.requireNonNull(font);
        this.setYMin((int)(9.0f * scale));
    }

    @Override
    public void trim() {
        Font font = Minecraft.getInstance().font;
        this.length = font.width((FormattedText)this.getMessage());
        this.setFixWidth((int)((float)this.length * this.scale));
        Objects.requireNonNull(font);
        this.setFixHeight((int)(9.0f * this.scale));
    }

    public Label setColor(int color) {
        this.color = color;
        return this;
    }

    public static class DynamicLabel
    extends Label {
        private final Supplier<Component> textSupplier;

        public DynamicLabel(Supplier<Component> textSupplier, float scale, int color, boolean dropShadow) {
            super(textSupplier.get(), scale, color, dropShadow);
            this.textSupplier = textSupplier;
        }

        @Override
        public boolean update(IUpdateMarker marker) {
            Component newText = this.textSupplier.get();
            if (this.getMessage().equals((Object)newText)) {
                return false;
            }
            this.setMessage(newText);
            return true;
        }
    }
}

