/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.client.gui.frame.widget.basic;

import com.xkball.auto_translate.client.gui.frame.core.HorizontalAlign;
import com.xkball.auto_translate.client.gui.frame.core.IPanel;
import com.xkball.auto_translate.client.gui.frame.core.WidgetPos;
import com.xkball.auto_translate.client.gui.frame.widget.basic.HorizontalPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractWidget;
import org.jetbrains.annotations.Nullable;

public class ClampHorizontalPanel
extends HorizontalPanel {
    @Nullable
    public IPanel left_;
    @Nullable
    public IPanel right_;
    public WidgetPos innerPos = new WidgetPos(0, 0, 0, 0);
    private final List<IPanel> actuallyPanels = new ArrayList<IPanel>();

    @Override
    public void resize() {
        int xl = 0;
        int xr = 0;
        WidgetPos parentPos = this.getBoundary().inner();
        int x = parentPos.x();
        int y = parentPos.y();
        if (this.left_ != null) {
            IPanel.calculateBoundary(this.left_, parentPos, x, y);
            int shiftY = IPanel.calculateShift(this.verticalAlign, parentPos.height(), this.left_.getBoundary().outer().height());
            this.left_.shiftWidgetBoundary(0, shiftY);
            xl = this.left_.getBoundary().outer().width();
        }
        if (this.right_ != null) {
            IPanel.calculateBoundary(this.right_, parentPos, x, y);
            int shiftX = IPanel.calculateShift(HorizontalAlign.RIGHT, parentPos.width(), this.right_.getBoundary().outer().width());
            int shiftY = IPanel.calculateShift(this.verticalAlign, parentPos.height(), this.right_.getBoundary().outer().height());
            this.right_.shiftWidgetBoundary(shiftX, shiftY);
            xr = this.right_.getBoundary().outer().width();
        }
        this.innerPos = new WidgetPos(x + xl, y, parentPos.width() - xr - xl, parentPos.height());
        super.resize();
    }

    @Override
    public WidgetPos getInnerPos() {
        return this.innerPos;
    }

    @Override
    public void clearWidget() {
        super.clearWidget();
        this.actuallyPanels.clear();
        this.left_ = null;
        this.right_ = null;
    }

    @Override
    public List<IPanel> getChildren() {
        return this.actuallyPanels;
    }

    @Override
    public <T extends AbstractWidget> HorizontalPanel addWidget(T wrapper, boolean resize) {
        this.actuallyPanels.add((IPanel)wrapper);
        return super.addWidget(wrapper, resize);
    }

    @Override
    public <T extends AbstractWidget> HorizontalPanel addWidgets(Supplier<List<T>> widgets, boolean resize) {
        this.actuallyPanels.addAll((Collection<IPanel>)widgets.get());
        return super.addWidgets(widgets, resize);
    }

    public <T extends AbstractWidget> ClampHorizontalPanel setLeft(T left) {
        this.children.add(left);
        this.actuallyPanels.add((IPanel)left);
        this.left_ = (IPanel)left;
        return this;
    }

    public <T extends AbstractWidget> ClampHorizontalPanel setRight(T right) {
        this.children.add(right);
        this.actuallyPanels.add((IPanel)right);
        this.right_ = (IPanel)right;
        return this;
    }
}

