/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.client.gui.frame.widget.basic;

import com.xkball.auto_translate.client.gui.frame.core.HorizontalAlign;
import com.xkball.auto_translate.client.gui.frame.core.IPanel;
import com.xkball.auto_translate.client.gui.frame.core.ITypeset;
import com.xkball.auto_translate.client.gui.frame.core.VerticalAlign;
import com.xkball.auto_translate.client.gui.frame.core.WidgetBoundary;
import com.xkball.auto_translate.client.gui.frame.core.WidgetPos;
import com.xkball.auto_translate.client.gui.frame.widget.basic.BaseContainerWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class VerticalPanel
extends BaseContainerWidget
implements ITypeset {
    public final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
    public final List<IPanel> childrenPanels = new ArrayList<IPanel>();
    public HorizontalAlign horizontalAlign = HorizontalAlign.CENTER;
    public VerticalAlign verticalAlign = VerticalAlign.CENTER;

    public static VerticalPanel of(Screen screen) {
        return new VerticalPanel(screen.width, screen.height, screen.getTitle());
    }

    public VerticalPanel() {
        this(0, 0, (Component)Component.empty());
    }

    public VerticalPanel(int width, int height, Component message) {
        super(message);
        this.xPercentage = 1.0f;
        this.yPercentage = 1.0f;
        this.widgetBoundary = new WidgetBoundary(new WidgetPos(0, 0, width, height), new WidgetPos(0, 0, width, height));
    }

    public <T extends AbstractWidget> VerticalPanel addWidget(T widget) {
        return this.addWidget(widget, false);
    }

    public <T extends AbstractWidget> VerticalPanel addWidget(T widget, boolean resize) {
        this.children.add(widget);
        this.childrenPanels.add((IPanel)widget);
        if (resize) {
            this.resize();
        }
        return this;
    }

    public <T extends AbstractWidget> VerticalPanel addWidgets(List<T> widgets, boolean resize) {
        this.children.addAll(widgets);
        this.childrenPanels.addAll(widgets);
        if (resize) {
            this.resize();
        }
        return this;
    }

    public <T extends AbstractWidget> VerticalPanel addWidgets(Supplier<List<T>> widgets, boolean resize) {
        List<T> list = widgets.get();
        this.children.addAll(list);
        this.childrenPanels.addAll(list);
        if (resize) {
            this.resize();
        }
        return this;
    }

    public void clearWidget() {
        this.children.clear();
        this.childrenPanels.clear();
        this.setFocused(null);
    }

    @Override
    public void resize() {
        WidgetPos parentPos = this.widgetBoundary.inner();
        int y = parentPos.y();
        for (IPanel widget : this.childrenPanels) {
            IPanel.calculateBoundary(widget, parentPos, parentPos.x(), y);
            y += widget.getBoundary().outer().height();
        }
        int heightSum = y - parentPos.y();
        int shiftY = IPanel.calculateShift(this.verticalAlign, parentPos.height(), heightSum);
        for (IPanel widget : this.childrenPanels) {
            int shiftX = IPanel.calculateShift(this.horizontalAlign, parentPos.width(), widget.getBoundary().outer().width());
            widget.shiftWidgetBoundary(shiftX, shiftY);
            widget.resize();
        }
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderDecoration(guiGraphics, mouseX, mouseY, partialTick);
        for (AbstractWidget child : this.children) {
            child.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        for (AbstractWidget child : this.children) {
            child.updateNarration(narrationElementOutput);
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.active && this.visible && this.getBoundary().inner().inside(mouseX, mouseY);
    }

    @Override
    public List<IPanel> getChildren() {
        return this.childrenPanels;
    }

    public List<? extends GuiEventListener> children() {
        return this.children;
    }

    @Override
    public VerticalAlign getVerticalAlign() {
        return this.verticalAlign;
    }

    @Override
    public HorizontalAlign getHorizontalAlign() {
        return this.horizontalAlign;
    }

    @Override
    public void setVerticalAlign(VerticalAlign verticalAlign) {
        this.verticalAlign = verticalAlign;
    }

    @Override
    public void setHorizontalAlign(HorizontalAlign horizontalAlign) {
        this.horizontalAlign = horizontalAlign;
    }
}

