/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.client.gui.screen;

import com.xkball.auto_translate.AutoTranslate;
import com.xkball.auto_translate.XATConfig;
import com.xkball.auto_translate.client.gui.frame.core.HorizontalAlign;
import com.xkball.auto_translate.client.gui.frame.core.IUpdateMarker;
import com.xkball.auto_translate.client.gui.frame.core.PanelConfig;
import com.xkball.auto_translate.client.gui.frame.core.VerticalAlign;
import com.xkball.auto_translate.client.gui.frame.screen.FrameScreen;
import com.xkball.auto_translate.client.gui.frame.widget.Label;
import com.xkball.auto_translate.client.gui.frame.widget.basic.AutoResizeWidgetWrapper;
import com.xkball.auto_translate.client.gui.frame.widget.basic.BaseContainerWidget;
import com.xkball.auto_translate.client.gui.frame.widget.basic.HorizontalPanel;
import com.xkball.auto_translate.client.gui.frame.widget.basic.ScrollableVerticalPanel;
import com.xkball.auto_translate.client.gui.frame.widget.basic.VerticalPanel;
import com.xkball.auto_translate.client.gui.widget.ObjectInputBox;
import com.xkball.auto_translate.data.XATDataBase;
import com.xkball.auto_translate.utils.ClientUtils;
import com.xkball.auto_translate.utils.VanillaUtils;
import com.xkball.auto_translate.utils.translate.LangKeyTranslateUnit;
import com.xkball.auto_translate.utils.translate.TranslatorType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public class XATConfigScreen
extends FrameScreen {
    private static final PanelConfig LINE_BASE = PanelConfig.of(0.5f, 1.0f).align(HorizontalAlign.LEFT, VerticalAlign.CENTER).paddingTop(8.0f).paddingLeft(0.25f);
    @Nullable
    private final Screen parentScreen;
    private final LangKeyTranslateUnit translateUnit = new LangKeyTranslateUnit();

    public XATConfigScreen(@Nullable ModContainer container, @Nullable Screen parent) {
        super((Component)Component.empty());
        this.parentScreen = parent;
    }

    protected void init() {
        super.init();
        VerticalPanel content = PanelConfig.of(1.0f, 1.0f).align(HorizontalAlign.LEFT, VerticalAlign.TOP).apply(new ScrollableVerticalPanel().addWidget(this.createConfigTitle("xat.gui.config.title.network")).addWidget(this.createEntry("xat.gui.config.http_host", XATConfig.HTTP_PROXY_HOST_CONFIG, ObjectInputBox::createStringInput)).addWidget(this.createEntry("xat.gui.config.http_port", (ModConfigSpec.ConfigValue)XATConfig.HTTP_PROXY_PORT_CONFIG, () -> new ObjectInputBox<Integer>(ObjectInputBox.INT_VALIDATOR, ObjectInputBox.INT_RESPONDER))).addWidget(this.createEntry("xat.gui.config.max_retries", (ModConfigSpec.ConfigValue)XATConfig.MAX_RETRIES_CONFIG, () -> new ObjectInputBox<Integer>(ObjectInputBox.INT_VALIDATOR, ObjectInputBox.INT_RESPONDER))).addWidget(this.createConfigTitle("xat.gui.config.title.translator")).addWidget(this.createEntryEnum("xat.gui.config.translator", XATConfig.TRANSLATOR_TYPE_CONFIG, TranslatorType.class)).addWidget(this.createTargetEntry()).addWidget(this.createConfigTitle("xat.gui.config.title.llm_config")).addWidget(this.createEntry("xat.gui.config.llm_api_url", XATConfig.LLM_API_URL_CONFIG, ObjectInputBox::createStringInput)).addWidget(this.createEntry("xat.gui.config.llm_model", XATConfig.LLM_MODEL_CONFIG, ObjectInputBox::createStringInput)).addWidget(this.createAPIKeyInput()).addWidget(this.createConfigTitle("xat.gui.run_trans_keys")).addWidget(this.addNotice("xat.gui.config.run_trans_notice")).addWidget(this.createRunTransKeys()).addWidget(this.createProcessingBar()).addWidget(this.createConfigTitle("xat.gui.config.title.others")).addWidget(this.createTokenCostLabel()).addWidget(this.createClearAllButton()));
        VerticalPanel screen = this.screenFrame("xat.gui.config", content);
        screen.resize();
        this.addRenderableWidget((GuiEventListener)screen);
        this.updateScreen();
    }

    public Label createConfigTitle(String key) {
        return PanelConfig.of(1.0f, 1.0f).paddingTop(12.0f).paddingLeft(0.2f).trim().apply(Label.ofKey(key, 1.6f));
    }

    public BaseContainerWidget addNotice(String key) {
        return LINE_BASE.fork().fixHeight(10).apply(new HorizontalPanel().addWidget(PanelConfig.of(1.0f, 1.0f).trim().apply(Label.ofKey(key))));
    }

    public BaseContainerWidget createTokenCostLabel() {
        return LINE_BASE.fork().fixHeight(10).apply(new HorizontalPanel(this){

            @Override
            public boolean update(IUpdateMarker updateMarker) {
                this.clearWidget();
                this.addWidget(PanelConfig.of(1.0f, 1.0f).trim().apply(Label.of((Component)Component.translatable((String)"xat.gui.token_cost", (Object[])new Object[]{XATDataBase.INSTANCE.getTokenCost()}))));
                return true;
            }
        });
    }

    public BaseContainerWidget createClearAllButton() {
        return LINE_BASE.fork().fixHeight(40).apply(new HorizontalPanel().addWidget(PanelConfig.of(1.0f, 1.0f).fixHeight(20).paddingLeft(8.0f).paddingRight(8.0f).apply(FrameScreen.createButton("xat.gui.btn.clear_all_cache", XATDataBase.INSTANCE::clearAllTranslateCache))));
    }

    public BaseContainerWidget createProcessingBar() {
        return LINE_BASE.fork().align(HorizontalAlign.CENTER, VerticalAlign.CENTER).fixHeight(10).apply(new HorizontalPanel(){

            @Override
            public boolean update(IUpdateMarker updateMarker) {
                this.clearWidget();
                this.addWidget(PanelConfig.of(0.4f, 1.0f).paddingRight(4.0f).trim().apply(Label.of(I18n.get((String)"xat.gui.processing", (Object[])new Object[0]) + XATConfigScreen.this.translateUnit.normalFinishedSize() + "/" + XATConfigScreen.this.translateUnit.size()).setColor(VanillaUtils.getColor(0, 255, 0, 255))));
                this.addWidget(PanelConfig.of(0.4f, 1.0f).paddingLeft(4.0f).trim().apply(Label.of(I18n.get((String)"xat.gui.error", (Object[])new Object[0]) + XATConfigScreen.this.translateUnit.errorSize() + "/" + XATConfigScreen.this.translateUnit.size()).setColor(VanillaUtils.getColor(255, 0, 0, 255))));
                return true;
            }
        });
    }

    public BaseContainerWidget createRunTransKeys() {
        final AutoResizeWidgetWrapper btn1 = FrameScreen.createButton("xat.gui.btn.run_trans_keys", this::runTransKeys);
        final AutoResizeWidgetWrapper btn2 = FrameScreen.createButton("xat.gui.btn.cancel_inject_lang", () -> {
            this.translateUnit.cancel();
            XATDataBase.INSTANCE.enableInjectLang(false);
            AutoTranslate.cancelInjectLanguage();
            this.setNeedUpdate();
        });
        final AutoResizeWidgetWrapper btn3 = FrameScreen.createButton("xat.gui.btn.clear_cache", LangKeyTranslateUnit.I18N_KEYS::clear);
        final PanelConfig btnConfig = PanelConfig.of(0.25f, 1.0f).paddingLeft(4.0f).paddingRight(4.0f).fixHeight(20);
        return LINE_BASE.fork().align(HorizontalAlign.CENTER, VerticalAlign.CENTER).fixHeight(40).apply(new HorizontalPanel(){

            @Override
            public boolean update(IUpdateMarker updateMarker) {
                btn1.inner.active = XATConfigScreen.this.translateUnit.finished;
                btn2.inner.active = XATDataBase.INSTANCE.isEnableInjectLang();
                this.clearWidget();
                this.addWidget(btnConfig.apply(btn1));
                this.addWidget(btnConfig.apply(btn2));
                this.addWidget(btnConfig.apply(btn3));
                return true;
            }
        });
    }

    public void runTransKeys() {
        this.translateUnit.reset();
        this.setNeedUpdate();
        XATDataBase.INSTANCE.enableInjectLang(true);
        ClientLanguage en = ClientUtils.getClientLanguage("en_us");
        Set target = ClientUtils.getClientLanguage((String)XATConfig.TARGET_LANGUAGE_CONFIG.get()).getLanguageData().keySet();
        List<Map.Entry> diff = en.getLanguageData().entrySet().stream().filter(entry -> !((String)entry.getValue()).isEmpty() && LangKeyTranslateUnit.I18N_KEYS.get((String)entry.getKey()) == null && !target.contains(entry.getKey())).toList();
        if (diff.isEmpty()) {
            AutoTranslate.injectLanguage();
            return;
        }
        IntStream.range(0, diff.size()).boxed().collect(Collectors.groupingBy(i -> i / 20)).values().stream().map(indexes -> indexes.stream().map(diff::get).toList()).forEach(this.translateUnit::submitRequest);
        this.translateUnit.start();
    }

    public <T> AutoResizeWidgetWrapper saveButton(Supplier<T> supplier, ModConfigSpec.ConfigValue<T> config) {
        return XATConfigScreen.iconButton(btn -> {
            Object t = supplier.get();
            if (t == null) {
                return;
            }
            config.set(t);
            config.save();
        }, VanillaUtils.modRL("icon/save"));
    }

    public <T> BaseContainerWidget createEntry(String key, ModConfigSpec.ConfigValue<T> config, Supplier<ObjectInputBox<T>> inputBSupplier) {
        ObjectInputBox<T> input = inputBSupplier.get();
        FrameScreen.setupSimpleEditBox(input);
        input.setValue(config.get().toString());
        input.scrollTo(0);
        return this.createEntry_(key, AutoResizeWidgetWrapper.of(input), this.saveButton(input::get, config));
    }

    public BaseContainerWidget createTargetEntry() {
        ObjectInputBox<String> input = ObjectInputBox.createStringInput();
        ModConfigSpec.ConfigValue<String> config = XATConfig.TARGET_LANGUAGE_CONFIG;
        FrameScreen.setupSimpleEditBox(input);
        input.setValue((String)config.get());
        input.scrollTo(0);
        AutoResizeWidgetWrapper syncButton = FrameScreen.iconButton(btn -> input.setValue(Minecraft.getInstance().getLanguageManager().getSelected()), VanillaUtils.modRL("icon/sync"));
        HorizontalPanel panel = new HorizontalPanel().addWidget(PanelConfig.of(-28.0f, 1.0f).paddingRight(8.0f).apply(AutoResizeWidgetWrapper.of(input))).addWidget(PanelConfig.ofFixSize(20, 20).tooltip("xat.gui.config.tooltip.sync").apply(syncButton));
        PanelConfig.of(1.0f, 1.0f).align(HorizontalAlign.CENTER, VerticalAlign.CENTER).apply(panel);
        return this.createEntry_("xat.gui.config.target", panel, this.saveButton(input::get, config));
    }

    public <T extends Enum<T>> BaseContainerWidget createEntryEnum(String key, ModConfigSpec.ConfigValue<T> config, Class<T> enumValue) {
        CycleButton btn = new CycleButton.Builder(t -> Component.literal((String)t.toString())).withValues((Object[])((Enum[])enumValue.getEnumConstants())).withInitialValue((Object)((Enum)config.get())).displayOnlyValue().create((Component)Component.empty(), (cbt, t) -> {});
        return this.createEntry_(key, AutoResizeWidgetWrapper.of((AbstractWidget)btn), this.saveButton(() -> ((CycleButton)btn).getValue(), config));
    }

    public BaseContainerWidget createAPIKeyInput() {
        return this.createEntry_("xat.gui.config.llm_api_key", XATConfigScreen.createButton("xat.gui.config.copy_form_clipboard", () -> XATConfig.LLM_API_KEY_CONFIG.set((Object)Minecraft.getInstance().keyboardHandler.getClipboard())), XATConfigScreen.iconButton(bt -> XATConfig.LLM_API_KEY_CONFIG.save(), VanillaUtils.modRL("icon/save")));
    }

    private BaseContainerWidget createEntry_(String key, BaseContainerWidget input, AutoResizeWidgetWrapper save) {
        return LINE_BASE.fork().fixHeight(40).apply(new HorizontalPanel().addWidget(PanelConfig.of(1.0f, 1.0f).fixWidth(90).paddingRight(16.0f).trim().apply(Label.ofKey(key, 1.2f))).addWidget(PanelConfig.of(0.6f, 1.0f).fixHeight(20).paddingRight(8.0f).apply(input))).addWidget(PanelConfig.ofFixSize(20, 20).tooltip("xat.gui.config.save").apply(save));
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parentScreen);
        }
    }

    @Override
    public boolean isPauseScreen() {
        return true;
    }
}

