/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.client.gui.widget;

import com.xkball.auto_translate.client.gui.frame.core.HorizontalAlign;
import com.xkball.auto_translate.client.gui.frame.core.IPanel;
import com.xkball.auto_translate.client.gui.frame.core.PanelConfig;
import com.xkball.auto_translate.client.gui.frame.core.VerticalAlign;
import com.xkball.auto_translate.client.gui.frame.widget.Label;
import com.xkball.auto_translate.client.gui.frame.widget.basic.AutoResizeWidgetWrapper;
import com.xkball.auto_translate.client.gui.frame.widget.basic.ClampHorizontalPanel;
import com.xkball.auto_translate.client.gui.widget.ObjectInputBox;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public abstract class NumInputFrame<T extends Number>
extends ClampHorizontalPanel {
    @Nullable
    private Consumer<T> valueSetter;

    public NumInputFrame(boolean renderNumLabel) {
        this.setHorizontalAlign(HorizontalAlign.CENTER);
        this.setVerticalAlign(VerticalAlign.CENTER);
        this.setXMin(50);
        this.setYMin(20);
        this.setLeft(PanelConfig.ofFixSize(20, 20).paddingRight(8.0f).apply(AutoResizeWidgetWrapper.of((AbstractWidget)Button.builder((Component)Component.literal((String)"-"), btn -> {
            this.onDecreaseButtonClick();
            this.update(IPanel.GLOBAL_UPDATE_MARKER);
        }).build())));
        this.setRight(PanelConfig.ofFixSize(20, 20).paddingLeft(8.0f).apply(AutoResizeWidgetWrapper.of((AbstractWidget)Button.builder((Component)Component.literal((String)"+"), btn -> {
            this.onIncreaseButtonClick();
            this.update(IPanel.GLOBAL_UPDATE_MARKER);
        }).build())));
        if (renderNumLabel) {
            this.addWidget(PanelConfig.of().trim().apply(Label.of(() -> Component.literal((String)String.valueOf(this.getValue())), 1.2f)));
        }
    }

    public NumInputFrame<T> setValueSetter(Consumer<T> valueSetter) {
        this.valueSetter = valueSetter;
        return this;
    }

    public void onValueChange() {
        if (this.valueSetter != null) {
            this.valueSetter.accept(this.getValue());
        }
    }

    public abstract void onDecreaseButtonClick();

    public abstract void onIncreaseButtonClick();

    @Nullable
    public abstract T getValue();

    public static class FloatInput
    extends NumInputFrame<Float> {
        private final float min;
        private final float max;
        private final float delta;
        @Nullable
        private Float value;
        @Nullable
        private ObjectInputBox<Float> input;

        public FloatInput(float min, float max, float delta, float default_, boolean renderNumLabel) {
            super(renderNumLabel);
            this.min = min;
            this.max = max;
            this.delta = delta;
            if (!renderNumLabel) {
                this.input = new ObjectInputBox<Float>(ObjectInputBox.FLOAT_VALIDATOR, ObjectInputBox.FLOAT_RESPONDER);
                this.input.setOnLoseFocused(str -> this.setValue(Objects.requireNonNull(this.input).get()));
                this.addWidget(PanelConfig.of(1.0f, 1.0f).apply(AutoResizeWidgetWrapper.of(this.input)));
            }
            this.setValue(Float.valueOf(default_));
        }

        @Override
        public void resize() {
            super.resize();
            if (this.input != null) {
                // empty if block
            }
        }

        public void setValue(@Nullable Float value) {
            if (Objects.equals(this.value, value)) {
                return;
            }
            Float f = value = value == null ? null : Float.valueOf(Mth.clamp((float)value.floatValue(), (float)this.min, (float)this.max));
            if (this.input != null && value != null) {
                this.input.setValue(String.valueOf(value));
                this.input.displayPos = 0;
            }
            this.value = value;
            this.onValueChange();
        }

        @Override
        public void onDecreaseButtonClick() {
            if (this.value == null) {
                this.setValue(Float.valueOf(this.min));
            } else {
                this.setValue(Float.valueOf(Math.max(this.min, this.value.floatValue() - this.delta)));
            }
        }

        @Override
        public void onIncreaseButtonClick() {
            if (this.value == null) {
                this.setValue(Float.valueOf(this.max));
            } else {
                this.setValue(Float.valueOf(Math.min(this.value.floatValue() + this.delta, this.max)));
            }
        }

        @Override
        @Nullable
        public Float getValue() {
            return this.value;
        }
    }

    public static class Pow2IntInput
    extends NumInputFrame<Integer> {
        private final int minN;
        private final int maxN;
        private int n;

        public Pow2IntInput(int minN, int maxN, int defaultN) {
            super(true);
            this.minN = minN;
            this.maxN = maxN;
            this.setN(defaultN);
        }

        @Override
        public void onDecreaseButtonClick() {
            int nn = Math.max(this.minN, this.n - 1);
            this.setN_(nn);
        }

        @Override
        public void onIncreaseButtonClick() {
            int nn = Math.min(this.n + 1, this.maxN);
            this.setN_(nn);
        }

        @Override
        @Nullable
        public Integer getValue() {
            return (int)Math.pow(2.0, this.n);
        }

        public int getN() {
            return this.n;
        }

        public void setN(int n) {
            int nn = Mth.clamp((int)n, (int)this.minN, (int)this.maxN);
            this.setN_(nn);
        }

        private void setN_(int nn) {
            if (nn == this.n) {
                return;
            }
            this.n = nn;
            this.onValueChange();
        }
    }
}

