/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.crossmod;

import com.xkball.auto_translate.XATConfig;
import com.xkball.auto_translate.crossmod.XAT_JEIPlugin;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;

public class CrossModBridge {
    @Nullable
    public static ItemStack getHoverItemOnJEIOverlay() {
        if (ModList.get().isLoaded("jei")) {
            return JEIHandler.getHoverItemOnJEIOverlay();
        }
        return null;
    }

    public static void tryTranslateFTBQuest(boolean force) {
        if (ModList.get().isLoaded("ftbquests")) {
            FTBQHandler.tryTranslateQuest(force);
        }
    }

    private static class JEIHandler {
        private JEIHandler() {
        }

        @Nullable
        public static ItemStack getHoverItemOnJEIOverlay() {
            if (XAT_JEIPlugin.runtime == null) {
                return null;
            }
            IJeiRuntime runtime = XAT_JEIPlugin.runtime;
            ItemStack is = (ItemStack)runtime.getIngredientListOverlay().getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK);
            if (is != null) {
                return is;
            }
            is = (ItemStack)runtime.getBookmarkOverlay().getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK);
            if (is != null) {
                return is;
            }
            return runtime.getRecipesGui().getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK).orElse(null);
        }
    }

    public static class FTBQHandler {
        public static final Map<String, String> translationMappings = new ConcurrentHashMap<String, String>();

        public static void tryTranslateQuest(boolean force) {
        }

        private static CompletableFuture<Void> translate(String str) {
            if (str.isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            translationMappings.put(str, I18n.get((String)"xkball.translator.translating", (Object[])new Object[0]));
            return XATConfig.TRANSLATOR_TYPE.getTranslator().translate(str).thenAcceptAsync(result -> translationMappings.put(str, (String)result));
        }
    }
}

