/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.data;

import com.mojang.logging.LogUtils;
import com.xkball.auto_translate.data.TranslationCacheSlice;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.fml.loading.FMLPaths;
import org.slf4j.Logger;

public class XATDataBase {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final XATDataBase INSTANCE = XATDataBase.createInstance();
    protected final List<TranslationCacheSlice> trSlices = new ArrayList<TranslationCacheSlice>();
    protected final Connection conn;

    private static XATDataBase createInstance() {
        try {
            Path dir = FMLPaths.GAMEDIR.relative().resolve("data");
            dir.toFile().mkdirs();
            Connection conn = DriverManager.getConnection("jdbc:sqlite:" + String.valueOf(dir.resolve("xkball_s_auto_translate.db")));
            return new XATDataBase(conn);
        }
        catch (Exception e) {
            LOGGER.error("Couldn't open database", (Throwable)e);
            return new InMemory();
        }
    }

    protected XATDataBase(Connection conn) {
        this.conn = conn;
        if (conn == null) {
            return;
        }
        try (Statement stmt = conn.createStatement();){
            String createTokenCount = "CREATE TABLE IF NOT EXISTS extra_data (id    TEXT PRIMARY KEY,value INTEGER NOT NULL)";
            String checkData = "SELECT COUNT(*) FROM extra_data";
            stmt.execute(createTokenCount);
            ResultSet rs = stmt.executeQuery(checkData);
            if (rs.next() && rs.getInt(1) == 0) {
                conn.createStatement().execute("INSERT INTO extra_data(id,value) VALUES('token_count',0)");
                conn.createStatement().execute("INSERT INTO extra_data(id,value) VALUES('inject_lang',0)");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public TranslationCacheSlice createSlice(String name) {
        try (Statement stmt = this.conn.createStatement();){
            stmt.execute("CREATE TABLE IF NOT EXISTS " + name + " (key   TEXT PRIMARY KEY NOT NULL, value TEXT             NOT NULL)");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        TranslationCacheSlice result = new TranslationCacheSlice(this.conn, name);
        this.trSlices.add(result);
        return result;
    }

    public synchronized void recordTokenCost(int count) {
        String sql = "UPDATE extra_data SET value = value + ? WHERE id='token_count'";
        try (PreparedStatement pstmt = this.conn.prepareStatement(sql);){
            pstmt.setInt(1, count);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getTokenCost() {
        String sql = "SELECT value FROM extra_data WHERE id='token_count'";
        try (Statement stmt = this.conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            if (!rs.next()) return 0;
            int n = rs.getInt("value");
            return n;
        }
        catch (SQLException e) {
            LOGGER.error("SELECT failed: {}", (Object)sql, (Object)e);
        }
        return 0;
    }

    public void enableInjectLang(boolean enable) {
        String sql = "UPDATE extra_data SET value = ? WHERE id='inject_lang'";
        try (PreparedStatement pstmt = this.conn.prepareStatement(sql);){
            pstmt.setBoolean(1, enable);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEnableInjectLang() {
        String sql = "SELECT value FROM extra_data WHERE id='inject_lang'";
        try (Statement stmt = this.conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            if (!rs.next()) return false;
            boolean bl = rs.getBoolean("value");
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void clearAllTranslateCache() {
        for (TranslationCacheSlice slice : this.trSlices) {
            slice.clear();
        }
    }

    public static class InMemory
    extends XATDataBase {
        private int cost = 0;

        protected InMemory() {
            super(null);
        }

        @Override
        public TranslationCacheSlice createSlice(String name) {
            TranslationCacheSlice.InMemory result = new TranslationCacheSlice.InMemory(name);
            this.trSlices.add(result);
            return result;
        }

        @Override
        public void recordTokenCost(int count) {
            this.cost += count;
        }

        @Override
        public int getTokenCost() {
            return this.cost;
        }
    }
}

