/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.llm;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.xkball.auto_translate.data.XATDataBase;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public record LLMResponse(@Nullable JsonObject response) {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();

    public static LLMResponse fromString(String response) {
        LLMResponse result;
        try {
            result = new LLMResponse((JsonObject)GSON.fromJson(response, JsonObject.class));
        }
        catch (Exception e) {
            LOGGER.error("Fail to parse llm result: {}", (Object)response, (Object)e);
            result = new LLMResponse(null);
        }
        XATDataBase.INSTANCE.recordTokenCost(result.getTokenUsed());
        return result;
    }

    public String getContent() {
        if (this.response == null) {
            return "";
        }
        JsonArray jsonArray1 = this.response.getAsJsonArray("choices");
        JsonObject jsonObj2 = jsonArray1.get(0).getAsJsonObject();
        JsonObject jsonObj3 = jsonObj2.getAsJsonObject("message");
        return jsonObj3.get("content").getAsString().trim();
    }

    public int getTokenUsed() {
        if (this.response == null) {
            return 0;
        }
        JsonObject jsonObj1 = this.response.getAsJsonObject("usage");
        return jsonObj1.get("total_tokens").getAsInt();
    }
}

