/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.utils;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.network.chat.Style;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;

@ParametersAreNonnullByDefault
public class ClientUtils {
    public static ClientLanguage getClientLanguage(String lang) {
        LanguageInfo langInfo = Minecraft.getInstance().getLanguageManager().getLanguage(lang);
        return ClientLanguage.loadFrom((ResourceManager)Minecraft.getInstance().getResourceManager(), List.of(lang), (langInfo != null && langInfo.bidirectional() ? 1 : 0) != 0);
    }

    public static String getAsString(FormattedCharSequence charSequence) {
        FormattedCharToString s = new FormattedCharToString();
        charSequence.accept((FormattedCharSink)s);
        return s.toString();
    }

    private static class FormattedCharToString
    implements FormattedCharSink {
        public final StringBuilder sb = new StringBuilder();

        private FormattedCharToString() {
        }

        public boolean accept(int positionInCurrentSequence, Style style, int codePoint) {
            this.sb.appendCodePoint(codePoint);
            return true;
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

