/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.utils;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public final class LegacyUtils {
    private static final Yaml YAML;
    private static final Pattern FORMAT_PATTERN;
    private static final Pattern TRANSLATABLE_PATTERN;

    private LegacyUtils() {
    }

    public static boolean hasTranslatableText(String text) {
        if (text == null || text.isBlank()) {
            return false;
        }
        String stripped = FORMAT_PATTERN.matcher(text).replaceAll("");
        return TRANSLATABLE_PATTERN.matcher(stripped).matches();
    }

    @CanIgnoreReturnValue
    public static JsonObject assign(JsonObject object, JsonObject ... sources) {
        for (JsonObject source : sources) {
            source.entrySet().forEach(entry -> object.add((String)entry.getKey(), (JsonElement)entry.getValue()));
        }
        return object;
    }

    public static void shutdownExecutor(ExecutorService service) {
        service.shutdown();
        try {
            if (service.awaitTermination(3L, TimeUnit.SECONDS)) {
                service.shutdownNow();
            }
        }
        catch (InterruptedException interruptedexception) {
            service.shutdownNow();
        }
    }

    public static String toYaml(Object data) {
        return YAML.dump(data);
    }

    public static <T> T parseYaml(String yaml) {
        return (T)YAML.load(yaml);
    }

    static {
        FORMAT_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");
        TRANSLATABLE_PATTERN = Pattern.compile(".*\\p{L}+.*");
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        YAML = new Yaml(options);
    }
}

