/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.utils.translate;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.mojang.logging.LogUtils;
import com.xkball.auto_translate.XATConfig;
import com.xkball.auto_translate.api.ITranslator;
import com.xkball.auto_translate.event.XATConfigUpdateEvent;
import java.io.IOException;
import java.net.CookieManager;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.client.resources.language.I18n;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import org.slf4j.Logger;

@EventBusSubscriber
public class GoogleTranslate
implements ITranslator {
    private static final URI THE_URI = URI.create("https://translate.google.com");
    private static final URI INTERNAL_URI = URI.create("https://translate.google.com/_/TranslateWebserverUi/data/batchexecute");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final CookieManager cookieManager = new CookieManager();
    private static final AtomicInteger cookieUsed = new AtomicInteger(0);
    private static volatile HttpClient CLIENT = GoogleTranslate.createClient();
    public static final GoogleTranslate INSTANCE = new GoogleTranslate();

    private GoogleTranslate() {
    }

    @Override
    public CompletableFuture<String> translate(String text, String lang) {
        LOGGER.debug(text);
        String[] strArray = text.split("\n");
        List<String> strList = Arrays.stream(strArray).filter(s -> !s.isEmpty()).toList();
        if (strList.isEmpty()) {
            return CompletableFuture.completedFuture("");
        }
        CompletionStage task = CompletableFuture.runAsync(() -> GoogleTranslate.updateCookies(false)).thenApplyAsync(v -> GoogleTranslate.tryRunTranslate((String)strList.getFirst(), lang, 0));
        int i = 1;
        while (i < strList.size()) {
            int finalI = i++;
            task = ((CompletableFuture)task).thenApplyAsync(str -> str + "\n" + GoogleTranslate.tryRunTranslate((String)strList.get(finalI), lang, 0));
        }
        ((CompletableFuture)task).exceptionallyAsync(t -> {
            LOGGER.error("Network error", t);
            return I18n.get((String)"xkball.translator.error", (Object[])new Object[0]);
        });
        return task;
    }

    private static synchronized void updateCookies(boolean force) {
        if (!force && !cookieManager.getCookieStore().getCookies().isEmpty()) {
            return;
        }
        cookieManager.getCookieStore().removeAll();
        HttpRequest reqGetCookies = HttpRequest.newBuilder(THE_URI).timeout(Duration.ofSeconds(10L)).GET().build();
        try {
            HttpResponse<String> res = CLIENT.send(reqGetCookies, HttpResponse.BodyHandlers.ofString());
            res.body();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        cookieUsed.set(0);
    }

    private static String tryRunTranslate(String text, String lang, int retries) {
        if (retries > XATConfig.MAX_RETRIES) {
            throw new RuntimeException("Network error: exceeded maximum retry times. " + text);
        }
        if (cookieUsed.incrementAndGet() > 30) {
            GoogleTranslate.updateCookies(true);
        }
        String postContent = "[[[\"MkEWBc\",\"[[\\\"" + text + "\\\",\\\"auto\\\",\\\"" + lang + "\\\",true],[null]]\",null,\"generic\"]]]";
        HttpRequest reqPost = HttpRequest.newBuilder(INTERNAL_URI).timeout(Duration.ofSeconds(10L)).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString("f.req=" + URLEncoder.encode(postContent, StandardCharsets.UTF_8))).build();
        CompletableFuture<HttpResponse<String>> resPost = CLIENT.sendAsync(reqPost, HttpResponse.BodyHandlers.ofString());
        return (String)((CompletableFuture)resPost.thenApplyAsync(res -> {
            if (res.statusCode() != 200) {
                LockSupport.parkNanos(200000L);
                return GoogleTranslate.tryRunTranslate(text, lang, retries + 1);
            }
            return GoogleTranslate.getTranslateResult((String)res.body());
        })).join();
    }

    public static HttpClient createClient() {
        HttpClient.Builder builder = HttpClient.newBuilder();
        if (!XATConfig.HTTP_PROXY_HOST.isEmpty()) {
            builder.proxy(ProxySelector.of(new InetSocketAddress(XATConfig.HTTP_PROXY_HOST, XATConfig.HTTP_PROXY_PORT)));
        }
        return builder.cookieHandler(cookieManager).build();
    }

    public static String getTranslateResult(String str) {
        try {
            str = str.substring(4);
            Gson gson = new Gson();
            JsonArray array1 = (JsonArray)gson.fromJson(str, JsonArray.class);
            JsonArray array2 = array1.get(0).getAsJsonArray();
            String innerStr = array2.get(2).getAsString();
            JsonArray array3 = (JsonArray)gson.fromJson(innerStr, JsonArray.class);
            JsonArray array4 = array3.get(1).getAsJsonArray();
            JsonArray array5 = array4.get(0).getAsJsonArray();
            JsonArray array6 = array5.get(0).getAsJsonArray();
            JsonArray array7 = array6.get(5).getAsJsonArray();
            JsonArray array8 = array7.get(0).getAsJsonArray();
            return array8.get(0).getAsString();
        }
        catch (Exception e) {
            LOGGER.error("Fail to parse translate result: {}", (Object)str, (Object)e);
            return I18n.get((String)"xkball.translator.error", (Object[])new Object[0]);
        }
    }

    @SubscribeEvent
    public static void onUpdateHttpConfig(XATConfigUpdateEvent.Http event) {
        if (event.changed()) {
            CLIENT = GoogleTranslate.createClient();
        }
    }
}

