/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.utils.translate;

import com.mojang.logging.LogUtils;
import com.xkball.auto_translate.llm.ILLMHandler;
import com.xkball.auto_translate.llm.LLMResponse;
import com.xkball.auto_translate.utils.LegacyUtils;
import com.xkball.auto_translate.utils.translate.LangKeyTranslateUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class LangKeyTranslateContext
implements ILLMHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final LangKeyTranslateUnit unit;
    public final List<String> keys = new ArrayList<String>();
    public final List<String> values = new ArrayList<String>();
    public final Map<String, String> raw = new HashMap<String, String>();
    public final Map<String, String> result = new HashMap<String, String>();

    public LangKeyTranslateContext(List<Map.Entry<String, String>> elt, LangKeyTranslateUnit unit) {
        this.unit = unit;
        for (Map.Entry<String, String> entry : elt) {
            if (entry.getValue().isEmpty()) {
                LOGGER.debug("empty key value pair: {},{}", (Object)entry.getKey(), (Object)entry.getValue());
                continue;
            }
            this.keys.add(entry.getKey());
            this.values.add(entry.getValue());
            this.raw.put(entry.getKey(), entry.getValue());
        }
    }

    public String createLLMRequestUserPrompt() {
        ArrayList<Map<String, String>> items = new ArrayList<Map<String, String>>();
        for (int i = 0; i < this.keys.size(); ++i) {
            items.add(Map.of("id", i, "text", this.values.get(i)));
        }
        return LegacyUtils.toYaml(items);
    }

    public Map<String, String> getRawMap() {
        return this.raw;
    }

    @Override
    public boolean handle(LLMResponse response) {
        LOGGER.debug(response.getContent());
        ArrayList<String> translateResult = new ArrayList<String>();
        try {
            List translatedItems = (List)LegacyUtils.parseYaml(response.getContent());
            for (Map map : translatedItems) {
                translateResult.add((Integer)map.get("id"), (String)map.get("text"));
            }
        }
        catch (Exception e) {
            return false;
        }
        if (translateResult.size() != this.keys.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.size(); ++i) {
            this.result.put(this.keys.get(i), (String)translateResult.get(i));
        }
        this.unit.submitResultFinished(this);
        return true;
    }

    @Override
    public void onRetriesExceeded() {
        this.unit.submitResultError(this);
    }
}

