/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.utils.translate;

import com.mojang.logging.LogUtils;
import com.xkball.auto_translate.AutoTranslate;
import com.xkball.auto_translate.XATConfig;
import com.xkball.auto_translate.client.gui.frame.core.IPanel;
import com.xkball.auto_translate.data.TranslationCacheSlice;
import com.xkball.auto_translate.data.XATDataBase;
import com.xkball.auto_translate.llm.LLMClientImpl;
import com.xkball.auto_translate.llm.LLMRequest;
import com.xkball.auto_translate.utils.translate.LLMTranslate;
import com.xkball.auto_translate.utils.translate.LangKeyTranslateContext;
import com.xkball.auto_translate.utils.translate.TranslatorType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.slf4j.Logger;

public class LangKeyTranslateUnit {
    public static final TranslationCacheSlice I18N_KEYS = XATDataBase.INSTANCE.createSlice("i18n_keys");
    public static final String DEFAULT_OPENAI_MULTIPLE_PROMPT = "You will be given a YAML formatted input containing entries with \"id\" and \"text\" fields. Here is the input:\n\n<yaml>\n${yaml}\n</yaml>\n\nFor each entry in the YAML, translate the contents of the \"text\" field into ${targetLanguage}. Write the translation back into the \"text\" field for that entry.\n\nHere is an example of the expected format:\n\n<example>\nInput:\n  - id: 1\n    text: Source\nOutput:\n  - id: 1\n    text: Translation\n</example>\n\nPlease return the translated YAML directly without wrapping <yaml> tag or include any additional information.";
    private static final Logger LOGGER = LogUtils.getLogger();
    public final List<LangKeyTranslateContext> contexts = new ArrayList<LangKeyTranslateContext>();
    public final List<LangKeyTranslateContext> contextFinished = new ArrayList<LangKeyTranslateContext>();
    public final List<LangKeyTranslateContext> contextError = new ArrayList<LangKeyTranslateContext>();
    public boolean finished = true;

    public void submitRequest(List<Map.Entry<String, String>> elt) {
        this.contexts.add(new LangKeyTranslateContext(elt, this));
    }

    public synchronized void checkFinish() {
        int contextSize = this.contexts.size();
        LOGGER.debug("Translating: {}/{}", (Object)this.contextFinished.size(), (Object)contextSize);
        IPanel.GLOBAL_UPDATE_MARKER.setNeedUpdate();
        if (this.contextFinished.size() == contextSize) {
            if (this.errorSize() > 0) {
                this.resolveFailedRequest();
            } else {
                this.finished = true;
                AutoTranslate.injectLanguage();
            }
        }
    }

    public synchronized void resolveFailedRequest() {
        for (LangKeyTranslateContext failedReq : this.contextError) {
            CompletableFuture[] reqs = (CompletableFuture[])failedReq.getRawMap().entrySet().stream().map(entry -> TranslatorType.getCurrentTranslator().translate((String)entry.getValue()).thenAccept(res -> I18N_KEYS.put((String)entry.getKey(), (String)res))).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(reqs).thenAccept(v -> {
                LangKeyTranslateUnit langKeyTranslateUnit = this;
                synchronized (langKeyTranslateUnit) {
                    this.contextError.remove(failedReq);
                    this.checkFinish();
                }
            });
        }
    }

    public synchronized void start() {
        this.finished = false;
        String sp = StrSubstitutor.replace((Object)DEFAULT_OPENAI_MULTIPLE_PROMPT, Map.of("targetLanguage", XATConfig.TARGET_LANGUAGE));
        LLMClientImpl llmClient = LLMTranslate.createLLMClient();
        for (LangKeyTranslateContext lktc : this.contexts) {
            LLMRequest request = new LLMRequest(sp, lktc.createLLMRequestUserPrompt());
            llmClient.addRequest(request, lktc);
        }
        llmClient.send();
    }

    public synchronized void cancel() {
        this.finished = true;
    }

    public synchronized void reset() {
        LOGGER.warn("Failed request in last round: {}", this.contextError);
        this.finished = true;
        this.contextFinished.clear();
        this.contextError.clear();
        this.contexts.clear();
    }

    public synchronized void submitResultFinished(LangKeyTranslateContext context) {
        LOGGER.debug("Context result : {} {} {}", new Object[]{context.keys, context.values, context.result});
        if (this.finished) {
            return;
        }
        this.contextFinished.add(context);
        for (Map.Entry<String, String> entry : context.result.entrySet()) {
            I18N_KEYS.put(entry.getKey(), entry.getValue());
        }
        this.checkFinish();
    }

    public synchronized void submitResultError(LangKeyTranslateContext context) {
        LOGGER.warn("Failed request : {}", (Object)context);
        if (this.finished) {
            return;
        }
        this.contextFinished.add(context);
        this.contextError.add(context);
        this.checkFinish();
    }

    public int size() {
        return this.contexts.size();
    }

    public int normalFinishedSize() {
        return this.contextFinished.size() - this.contextError.size();
    }

    public int errorSize() {
        return this.contextError.size();
    }
}

