/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import com.xkball.auto_translate.XATConfig;
import com.xkball.auto_translate.client.gui.frame.core.IPanel;
import com.xkball.auto_translate.client.gui.screen.XATConfigScreen;
import com.xkball.auto_translate.data.XATDataBase;
import com.xkball.auto_translate.utils.translate.LangKeyTranslateUnit;
import com.xkball.auto_translate.utils.translate.TranslatorType;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.commands.Commands;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import org.slf4j.Logger;

@Mod(value="xkball_s_auto_translate")
@Mod.EventBusSubscriber
public class AutoTranslate {
    public static final String MODID = "xkball_s_auto_translate";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final boolean IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().stream().anyMatch(str -> str.startsWith("-agentlib:jdwp"));

    public AutoTranslate(FMLJavaModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)XATConfig.SPEC);
        FMLModContainer container = context.getContainer();
        container.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory(XATConfigScreen::new));
    }

    public static void updateLanguageMap(ResourceManager resourceManager) {
        if (XATDataBase.INSTANCE.isEnableInjectLang()) {
            AutoTranslate.injectLanguage();
        }
    }

    @SubscribeEvent
    public static void onPlayerEnterWorld(ClientPlayerNetworkEvent.LoggingIn event) {
        LocalPlayer player = event.getPlayer();
        boolean flag = false;
        if (XATConfig.TRANSLATOR_TYPE == TranslatorType.DEFAULT) {
            flag = true;
            player.m_5661_((Component)Component.m_237115_((String)"xat.warn").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237115_((String)"xat.warn.no_translator").m_130940_(ChatFormatting.RED)), false);
        }
        if (!XATDataBase.INSTANCE.isEnableInjectLang()) {
            flag = true;
            player.m_5661_((Component)Component.m_237115_((String)"xat.warn").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237115_((String)"xat.warn.no_inject").m_130940_(ChatFormatting.RED)), false);
        }
        if (flag) {
            player.m_5661_((Component)Component.m_237115_((String)"xat.warn").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237115_((String)"xat.warn.open_config_screen").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/xat open_config_screen")))), false);
        }
    }

    @SubscribeEvent
    public static void onRegClientCommand(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"xat").then(Commands.m_82127_((String)"open_config_screen").executes(s -> {
            Minecraft.m_91087_().m_91152_((Screen)new XATConfigScreen(null));
            return 0;
        })));
    }

    public static void injectLanguage() {
        LOGGER.info("Injecting language.");
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(Language.m_128107_().getLanguageData());
        map.putAll(LangKeyTranslateUnit.I18N_KEYS.toMap());
        boolean defaultRightToLeft = Language.m_128107_().m_6627_();
        ClientLanguage clientLang = new ClientLanguage(map, defaultRightToLeft);
        I18n.m_118941_((Language)clientLang);
        Language.m_128114_((Language)clientLang);
        IPanel.GLOBAL_UPDATE_MARKER.setNeedUpdate();
    }

    public static void cancelInjectLanguage() {
        LanguageInfo languageinfo;
        LOGGER.info("Cancel Inject language.");
        LanguageManager langManger = Minecraft.m_91087_().m_91102_();
        String currentCode = langManger.m_264236_();
        ArrayList<String> list = new ArrayList<String>(2);
        boolean flag = Objects.requireNonNull(langManger.m_118976_("en_us")).f_118946_();
        list.add("en_us");
        if (!currentCode.equals("en_us") && (languageinfo = langManger.m_118976_(currentCode)) != null) {
            list.add(currentCode);
            flag = languageinfo.f_118946_();
        }
        ClientLanguage clientlanguage = ClientLanguage.m_264420_((ResourceManager)Minecraft.m_91087_().m_91098_(), list, (boolean)flag);
        I18n.m_118941_((Language)clientlanguage);
        Language.m_128114_((Language)clientlanguage);
    }

    @Mod.EventBusSubscriber(modid="xkball_s_auto_translate", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }

        @SubscribeEvent
        public static void onResourceReload(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)AutoTranslate::updateLanguageMap));
        }
    }
}

