/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.datafixers.util.Either;
import com.xkball.auto_translate.XATConfig;
import com.xkball.auto_translate.data.TranslationCacheSlice;
import com.xkball.auto_translate.data.XATDataBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ItemStackTooltipTranslator {
    public static final Map<String, String> translating = new ConcurrentHashMap<String, String>();
    public static final TranslationCacheSlice tooltipCache = XATDataBase.INSTANCE.createSlice("tooltip");
    private static final Style DARK_GRAY = Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY);
    @Nullable
    private static volatile ItemStack track = null;
    private static volatile boolean force = false;

    public static void submit(@Nullable ItemStack stack, boolean force) {
        if (stack == null) {
            return;
        }
        if (stack.m_41619_()) {
            return;
        }
        track = stack;
        ItemStackTooltipTranslator.force = force;
        Window window = Minecraft.m_91087_().m_91268_();
        List textList = Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)stack);
        ForgeHooksClient.gatherTooltipComponents((ItemStack)stack, (List)textList, (Optional)stack.m_150921_(), (int)0, (int)window.m_85443_(), (int)window.m_85444_(), (Font)Minecraft.m_91087_().f_91062_);
        track = null;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGatherTooltip(RenderTooltipEvent.GatherComponents event) {
        if (event.getItemStack().equals(track)) {
            ItemStackTooltipTranslator.submit(event.getTooltipElements(), force);
        }
        ArrayList newTooltips = new ArrayList();
        for (Either either : event.getTooltipElements()) {
            either.ifLeft(text -> {
                newTooltips.add(either);
                String str = text.getString();
                if (str.isEmpty()) {
                    return;
                }
                boolean translating = translating.containsKey(str);
                if (translating) {
                    newTooltips.add(Either.left((Object)FormattedText.m_130762_((String)I18n.m_118938_((String)"xkball.translator.translating", (Object[])new Object[0]), (Style)DARK_GRAY)));
                } else {
                    String trResult = tooltipCache.get(str);
                    if (trResult != null) {
                        newTooltips.add(Either.left((Object)FormattedText.m_130762_((String)trResult, (Style)DARK_GRAY)));
                    }
                }
            });
            either.ifRight(text -> newTooltips.add(either));
        }
        event.getTooltipElements().clear();
        event.getTooltipElements().addAll(newTooltips);
    }

    private static void submit(List<Either<FormattedText, TooltipComponent>> components, boolean force) {
        for (Either<FormattedText, TooltipComponent> either : components) {
            either.ifLeft(text -> {
                String str = text.getString();
                if (str.isEmpty() || !force && tooltipCache.get(str) != null) {
                    return;
                }
                translating.put(str, "");
                XATConfig.TRANSLATOR_TYPE.getTranslator().translate(str).whenCompleteAsync((result, t) -> {
                    translating.remove(str);
                    tooltipCache.put(str, (String)result);
                });
            });
        }
    }
}

