/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.client.gui.frame.core;

import com.xkball.auto_translate.AutoTranslate;
import com.xkball.auto_translate.client.gui.frame.core.HorizontalAlign;
import com.xkball.auto_translate.client.gui.frame.core.IUpdateMarker;
import com.xkball.auto_translate.client.gui.frame.core.VerticalAlign;
import com.xkball.auto_translate.client.gui.frame.core.WidgetBoundary;
import com.xkball.auto_translate.client.gui.frame.core.WidgetPos;
import com.xkball.auto_translate.client.gui.frame.core.render.IGUIDecoRenderer;
import com.xkball.auto_translate.client.gui.frame.screen.FrameScreen;
import com.xkball.auto_translate.utils.VanillaUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;

public interface IPanel {
    public static final IUpdateMarker GLOBAL_UPDATE_MARKER = new IUpdateMarker(){

        @Override
        public boolean needUpdate() {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof FrameScreen) {
                FrameScreen frameScreen = (FrameScreen)screen;
                return frameScreen.needUpdate();
            }
            return false;
        }

        @Override
        public void setNeedUpdate() {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof FrameScreen) {
                FrameScreen frameScreen = (FrameScreen)screen;
                frameScreen.setNeedUpdate();
            }
        }
    };
    public static final List<IPanel> EMPTY = List.of();

    public float getXPercentage();

    public float getYPercentage();

    public float getLeftPadding();

    public float getRightPadding();

    public float getTopPadding();

    public float getBottomPadding();

    public int getXMax();

    public int getYMax();

    public int getXMin();

    public int getYMin();

    public WidgetBoundary getBoundary();

    @Nullable
    public IGUIDecoRenderer getDecoRenderer();

    public boolean getIsFocused();

    public void setXPercentage(float var1);

    public void setYPercentage(float var1);

    public void setLeftPadding(float var1);

    public void setRightPadding(float var1);

    public void setTopPadding(float var1);

    public void setBottomPadding(float var1);

    public void setXMax(int var1);

    public void setYMax(int var1);

    public void setXMin(int var1);

    public void setYMin(int var1);

    public void setBoundary(WidgetBoundary var1);

    public void setDecoRenderer(IGUIDecoRenderer var1);

    default public List<IPanel> getChildren() {
        return EMPTY;
    }

    default public void resize() {
    }

    default public boolean update(IUpdateMarker updateMarker) {
        boolean flag = false;
        for (IPanel child : this.getChildren()) {
            flag |= child.update(updateMarker);
        }
        if (flag) {
            this.resize();
        }
        return false;
    }

    default public void trim() {
    }

    default public void setFixWidth(int width) {
        this.setXMax(width);
        this.setXMin(width);
    }

    default public void setFixHeight(int height) {
        this.setYMax(height);
        this.setYMin(height);
    }

    default public void shiftWidgetBoundary(int x, int y) {
        if (x == 0 && y == 0) {
            return;
        }
        WidgetBoundary boundary = this.getBoundary();
        WidgetPos newInner = new WidgetPos(boundary.inner().x() + x, boundary.inner().y() + y, boundary.inner().width(), boundary.inner().height());
        WidgetPos newOuter = new WidgetPos(boundary.outer().x() + x, boundary.outer().y() + y, boundary.outer().width(), boundary.outer().height());
        this.setBoundary(new WidgetBoundary(newOuter, newInner));
    }

    default public void renderDecoration(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.getDecoRenderer() != null) {
            this.getDecoRenderer().render(guiGraphics, this.getBoundary(), mouseX, mouseY, partialTick);
        }
        this.recordDebugBoundary(this.getBoundary());
    }

    default public void recordDebugBoundary(WidgetBoundary boundary) {
        if (AutoTranslate.IS_DEBUG && Minecraft.m_91087_().f_91066_.f_92063_) {
            WidgetPos od = boundary.outer();
            WidgetPos id = boundary.inner();
            int blue0 = VanillaUtils.getColor(173, 216, 230, 10);
            int yellow0 = VanillaUtils.getColor(255, 250, 205, 10);
            int blue1 = VanillaUtils.getColor(0, 0, 255, 255);
            int yellow1 = VanillaUtils.getColor(255, 255, 0, 255);
            DebugLine.lines.add(new DebugLine(od.x(), od.y(), od.width(), od.height(), this.getIsFocused() ? blue1 : blue0));
            DebugLine.lines.add(new DebugLine(id.x(), id.y(), id.width(), id.height(), this.getIsFocused() ? yellow1 : yellow0));
        }
    }

    default public boolean drawBorderOnFocused() {
        return false;
    }

    public static float calculatePadding(float padding, int base) {
        return padding > 1.0f ? padding : Mth.m_14036_((float)((float)base * padding), (float)0.0f, (float)base);
    }

    public static void calculateBoundary(IPanel widget, WidgetPos parentPos, int x, int y) {
        float width = Mth.m_14036_((float)((float)parentPos.width() * (widget.getXPercentage() < -1.0f ? 1.0f : widget.getXPercentage())), (float)widget.getXMin(), (float)Math.min(widget.getXMax(), parentPos.maxX() - x));
        if (widget.getXPercentage() < -1.0f) {
            width += widget.getXPercentage();
        }
        float height = Mth.m_14036_((float)((float)parentPos.height() * widget.getYPercentage()), (float)widget.getYMin(), (float)Math.min(widget.getYMax(), parentPos.maxY() - y));
        float leftPadding = IPanel.calculatePadding(widget.getLeftPadding(), parentPos.width());
        float rightPadding = IPanel.calculatePadding(widget.getRightPadding(), parentPos.width());
        float topPadding = IPanel.calculatePadding(widget.getTopPadding(), parentPos.height());
        float bottomPadding = IPanel.calculatePadding(widget.getBottomPadding(), parentPos.height());
        int outerWidth = (int)(leftPadding + width + rightPadding);
        int outerHeight = (int)(topPadding + height + bottomPadding);
        WidgetPos outer = new WidgetPos(x, y, outerWidth, outerHeight);
        WidgetPos inner = new WidgetPos((int)((float)x + leftPadding), (int)((float)y + topPadding), (int)width, (int)height);
        widget.setBoundary(new WidgetBoundary(outer, inner));
    }

    public static int calculateShift(HorizontalAlign align, int sizeLimit, int size) {
        return switch (align) {
            default -> throw new IncompatibleClassChangeError();
            case HorizontalAlign.LEFT -> 0;
            case HorizontalAlign.CENTER -> (int)((float)sizeLimit / 2.0f - (float)size / 2.0f);
            case HorizontalAlign.RIGHT -> sizeLimit - size;
        };
    }

    public static int calculateShift(VerticalAlign align, int sizeLimit, int size) {
        return switch (align) {
            default -> throw new IncompatibleClassChangeError();
            case VerticalAlign.TOP -> 0;
            case VerticalAlign.CENTER -> (int)((float)sizeLimit / 2.0f - (float)size / 2.0f);
            case VerticalAlign.BOTTOM -> sizeLimit - size;
        };
    }

    public record DebugLine(int x, int y, int width, int height, int color) {
        public static final List<DebugLine> lines = new ArrayList<DebugLine>();

        public static void drawAllDebugLines(GuiGraphics guiGraphics) {
            for (DebugLine line : lines) {
                guiGraphics.m_280637_(line.x(), line.y(), line.width(), line.height(), line.color());
            }
            lines.clear();
        }
    }
}

