/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.client.gui.frame.core;

import com.xkball.auto_translate.client.gui.frame.core.HorizontalAlign;
import com.xkball.auto_translate.client.gui.frame.core.IPanel;
import com.xkball.auto_translate.client.gui.frame.core.ITypeset;
import com.xkball.auto_translate.client.gui.frame.core.VerticalAlign;
import com.xkball.auto_translate.client.gui.frame.core.render.CombineRenderer;
import com.xkball.auto_translate.client.gui.frame.core.render.IGUIDecoRenderer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;

public class PanelConfig {
    public float xPercentage = -1.0f;
    public float yPercentage = -1.0f;
    public float leftPadding = -1.0f;
    public float rightPadding = -1.0f;
    public float topPadding = -1.0f;
    public float bottomPadding = -1.0f;
    public int xMax = -1;
    public int yMax = -1;
    public int xMin = -1;
    public int yMin = -1;
    @Nullable
    public HorizontalAlign horizontalAlign = null;
    @Nullable
    public VerticalAlign verticalAlign = null;
    @Nullable
    public IGUIDecoRenderer guiDecoRenderer = null;
    @Nullable
    public Tooltip tooltip = null;
    public boolean trim = false;

    public static PanelConfig of() {
        return new PanelConfig();
    }

    public static PanelConfig ofFixSize(int width, int height) {
        return PanelConfig.of().fixSize(width, height);
    }

    public static PanelConfig of(float xPercentage, float yPercentage) {
        PanelConfig result = new PanelConfig();
        result.xPercentage = xPercentage;
        result.yPercentage = yPercentage;
        return result;
    }

    public PanelConfig tooltip(String trans_key) {
        this.tooltip = Tooltip.m_257550_((Component)Component.m_237115_((String)trans_key));
        return this;
    }

    public PanelConfig tooltip(Tooltip tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public PanelConfig fixSize(int width, int height) {
        this.fixWidth(width);
        this.fixHeight(height);
        return this;
    }

    public PanelConfig fixWidth(int width) {
        this.xMax = width;
        this.xMin = width;
        return this;
    }

    public PanelConfig fixHeight(int height) {
        this.yMax = height;
        this.yMin = height;
        return this;
    }

    public PanelConfig paddingLeft(float leftPadding) {
        this.leftPadding = leftPadding;
        return this;
    }

    public PanelConfig paddingRight(float rightPadding) {
        this.rightPadding = rightPadding;
        return this;
    }

    public PanelConfig paddingTop(float topPadding) {
        this.topPadding = topPadding;
        return this;
    }

    public PanelConfig paddingBottom(float bottomPadding) {
        this.bottomPadding = bottomPadding;
        return this;
    }

    public PanelConfig padding(float leftPadding, float rightPadding, float topPadding, float bottomPadding) {
        this.leftPadding = leftPadding;
        this.rightPadding = rightPadding;
        this.topPadding = topPadding;
        this.bottomPadding = bottomPadding;
        return this;
    }

    public PanelConfig sizeLimitXMin(int xMin) {
        this.xMin = xMin;
        return this;
    }

    public PanelConfig sizeLimitYMin(int yMin) {
        this.yMin = yMin;
        return this;
    }

    public PanelConfig sizeLimitXMax(int xMax) {
        this.xMax = xMax;
        return this;
    }

    public PanelConfig sizeLimitYMax(int yMax) {
        this.yMax = yMax;
        return this;
    }

    public PanelConfig sizeLimit(int xMin, int yMin, int xMax, int yMax) {
        this.xMin = xMin;
        this.yMin = yMin;
        this.xMax = xMax;
        this.yMax = yMax;
        return this;
    }

    public PanelConfig trim() {
        this.trim = true;
        return this;
    }

    public PanelConfig align(HorizontalAlign horizontalAlign, VerticalAlign verticalAlign) {
        this.horizontalAlign = horizontalAlign;
        this.verticalAlign = verticalAlign;
        return this;
    }

    public PanelConfig decoRenderer(IGUIDecoRenderer decoRenderer) {
        this.guiDecoRenderer = this.guiDecoRenderer == null ? decoRenderer : new CombineRenderer(this.guiDecoRenderer, decoRenderer);
        return this;
    }

    public PanelConfig fork() {
        PanelConfig newConfig = new PanelConfig();
        newConfig.horizontalAlign = this.horizontalAlign;
        newConfig.verticalAlign = this.verticalAlign;
        newConfig.guiDecoRenderer = this.guiDecoRenderer;
        newConfig.tooltip = this.tooltip;
        newConfig.trim = this.trim;
        newConfig.xMax = this.xMax;
        newConfig.yMax = this.yMax;
        newConfig.xMin = this.xMin;
        newConfig.yMin = this.yMin;
        newConfig.leftPadding = this.leftPadding;
        newConfig.rightPadding = this.rightPadding;
        newConfig.topPadding = this.topPadding;
        newConfig.bottomPadding = this.bottomPadding;
        newConfig.xPercentage = this.xPercentage;
        newConfig.yPercentage = this.yPercentage;
        return newConfig;
    }

    public <T extends IPanel> T apply(T panel) {
        if (this.trim) {
            panel.trim();
        }
        panel.setXPercentage(this.xPercentage);
        panel.setYPercentage(this.yPercentage);
        if (this.leftPadding > 0.0f) {
            panel.setLeftPadding(this.leftPadding);
        }
        if (this.rightPadding > 0.0f) {
            panel.setRightPadding(this.rightPadding);
        }
        if (this.topPadding > 0.0f) {
            panel.setTopPadding(this.topPadding);
        }
        if (this.bottomPadding > 0.0f) {
            panel.setBottomPadding(this.bottomPadding);
        }
        if (this.xMax > 0) {
            panel.setXMax(this.xMax);
        }
        if (this.yMax > 0) {
            panel.setYMax(this.yMax);
        }
        if (this.xMin > 0) {
            panel.setXMin(this.xMin);
        }
        if (this.yMin > 0) {
            panel.setYMin(this.yMin);
        }
        if (this.guiDecoRenderer != null) {
            panel.setDecoRenderer(this.guiDecoRenderer);
        }
        if (panel instanceof ITypeset) {
            ITypeset t = (ITypeset)((Object)panel);
            if (this.verticalAlign != null) {
                t.setVerticalAlign(this.verticalAlign);
            }
            if (this.horizontalAlign != null) {
                t.setHorizontalAlign(this.horizontalAlign);
            }
        }
        if (panel instanceof AbstractWidget) {
            AbstractWidget widget = (AbstractWidget)panel;
            if (this.tooltip != null) {
                widget.m_257544_(this.tooltip);
            }
        }
        return panel;
    }
}

