/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.client.gui.frame.screen;

import com.xkball.auto_translate.AutoTranslate;
import com.xkball.auto_translate.client.gui.frame.core.HorizontalAlign;
import com.xkball.auto_translate.client.gui.frame.core.IPanel;
import com.xkball.auto_translate.client.gui.frame.core.IUpdateMarker;
import com.xkball.auto_translate.client.gui.frame.core.PanelConfig;
import com.xkball.auto_translate.client.gui.frame.core.VerticalAlign;
import com.xkball.auto_translate.client.gui.frame.core.render.GuiDecorations;
import com.xkball.auto_translate.client.gui.frame.core.render.SimpleBackgroundRenderer;
import com.xkball.auto_translate.client.gui.frame.widget.BlankWidget;
import com.xkball.auto_translate.client.gui.frame.widget.Label;
import com.xkball.auto_translate.client.gui.frame.widget.basic.AutoResizeWidgetWrapper;
import com.xkball.auto_translate.client.gui.frame.widget.basic.HorizontalPanel;
import com.xkball.auto_translate.client.gui.frame.widget.basic.VerticalPanel;
import com.xkball.auto_translate.client.gui.widget.ObjectInputBox;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;

public class FrameScreen
extends Screen
implements IUpdateMarker {
    public static final float THE_SCALE = 0.3731f;
    protected volatile boolean needUpdate = false;
    protected final Queue<Runnable> renderTasks = new ConcurrentLinkedQueue<Runnable>();

    public FrameScreen(Component title) {
        super(title);
    }

    public void updateScreen() {
        for (GuiEventListener child : this.m_6702_()) {
            if (!(child instanceof IPanel)) continue;
            IPanel panel = (IPanel)child;
            panel.update(this);
        }
    }

    @Override
    public void setNeedUpdate() {
        this.needUpdate = true;
    }

    @Override
    public boolean needUpdate() {
        return this.needUpdate;
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.needUpdate) {
            this.needUpdate = false;
            this.updateScreen();
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        IPanel.DebugLine.drawAllDebugLines(guiGraphics);
        while (!this.renderTasks.isEmpty()) {
            this.renderTasks.poll().run();
        }
        if (AutoTranslate.IS_DEBUG && Minecraft.m_91087_().f_91066_.f_92063_) {
            guiGraphics.m_280488_(this.f_96547_, mouseX + ":" + mouseY, 10, 10, -1);
        }
    }

    public void submitRenderTask(Runnable runnable) {
        this.renderTasks.add(runnable);
    }

    public boolean m_7043_() {
        return false;
    }

    public <T extends AbstractWidget> VerticalPanel screenFrame(String titleTransKey, T content) {
        VerticalPanel screen = PanelConfig.of().align(HorizontalAlign.LEFT, VerticalAlign.TOP).apply(VerticalPanel.of(this));
        screen.addWidget(PanelConfig.of(1.0f, 0.04f).align(HorizontalAlign.CENTER, VerticalAlign.CENTER).sizeLimitYMin(25).decoRenderer(SimpleBackgroundRenderer.GRAY).decoRenderer(GuiDecorations.BOTTOM_DARK_BORDER_LINE).apply(new HorizontalPanel().addWidget(PanelConfig.of().trim().apply(Label.of((Component)Component.m_237115_((String)titleTransKey), 1.5f))).addWidget(PanelConfig.of().fixHeight(20).fixWidth(20).tooltip("xat.gui.open_config_file").apply(FrameScreen.iconButton(btn -> Util.m_137581_().m_137644_(FMLPaths.CONFIGDIR.get().resolve("xkball_s_auto_translate-common.toml").toFile()), ResourceLocation.withDefaultNamespace((String)"toast/recipe_book")))))).addWidget(PanelConfig.of(1.0f, 0.92f).sizeLimitYMax(this.f_96544_ - 40).decoRenderer(GuiDecorations.BOTTOM_DARK_BORDER_LINE).apply(AutoResizeWidgetWrapper.of(content))).addWidget(PanelConfig.of(1.0f, 0.04f).sizeLimitYMin(15).decoRenderer(SimpleBackgroundRenderer.GRAY).apply(new BlankWidget()));
        return screen;
    }

    public AutoResizeWidgetWrapper createEditBox(Supplier<String> valueGetter, Consumer<String> valueSetter) {
        return this.createEditBox(() -> new EditBox(this.f_96547_, 0, 0, 0, 0, (Component)Component.m_237119_()), valueGetter, valueSetter);
    }

    public AutoResizeWidgetWrapper createEditBox(Supplier<? extends EditBox> editBoxSupplier, Supplier<String> valueGetter, Consumer<String> valueSetter) {
        EditBox editBox = editBoxSupplier.get();
        FrameScreen.setupSimpleEditBox(editBox);
        editBox.m_94144_(valueGetter.get());
        editBox.f_94100_ = 0;
        editBox.m_94151_(str -> {
            valueSetter.accept((String)str);
            this.setNeedUpdate();
        });
        return new AutoResizeWidgetWrapper((AbstractWidget)editBox);
    }

    public <T> AutoResizeWidgetWrapper createObjInputBox(Predicate<String> validator, Function<String, T> responder, Consumer<T> valueSetter) {
        ObjectInputBox editBox = new ObjectInputBox(this.f_96547_, 0, 0, 0, 0, (Component)Component.m_237119_(), validator, responder);
        FrameScreen.setupSimpleEditBox(editBox);
        editBox.m_94151_(str -> {
            valueSetter.accept(editBox.get());
            this.setNeedUpdate();
        });
        return new AutoResizeWidgetWrapper((AbstractWidget)editBox);
    }

    public static void setupSimpleEditBox(EditBox editBox) {
        editBox.m_94199_(114514);
        editBox.m_94190_(true);
        editBox.m_94198_();
    }

    public static AutoResizeWidgetWrapper iconButton(Button.OnPress onPress, ResourceLocation sprite) {
        ImageButton btn = new ImageButton(0, 0, 0, 0, 0, 0, 0, sprite, 16, 16, onPress, (Component)Component.m_237119_());
        return AutoResizeWidgetWrapper.of((AbstractWidget)btn);
    }

    public static AutoResizeWidgetWrapper createButton(String message, Runnable onPress) {
        Button button = Button.m_253074_((Component)Component.m_237115_((String)message), btn -> onPress.run()).m_253136_();
        return AutoResizeWidgetWrapper.of((AbstractWidget)button);
    }
}

