/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.client.gui.frame.widget;

import com.xkball.auto_translate.client.gui.frame.core.IUpdateMarker;
import com.xkball.auto_translate.client.gui.frame.core.WidgetPos;
import com.xkball.auto_translate.client.gui.frame.widget.basic.AutoResizeWidget;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class Label
extends AutoResizeWidget {
    private float scale;
    public int color = -1;
    public boolean dropShadow = true;
    private int length;

    public static Label of(String str) {
        return Label.of((Component)Component.m_237113_((String)str));
    }

    public static Label ofKey(String str) {
        return Label.of((Component)Component.m_237115_((String)str));
    }

    public static Label ofKey(String str, float scale) {
        return Label.of((Component)Component.m_237115_((String)str), scale);
    }

    public static Label of(Component message) {
        return Label.of(message, 1.0f);
    }

    public static Label of(Supplier<Component> message) {
        return Label.of(message, 1.0f);
    }

    public static Label of(Component message, float scale) {
        return new Label(message, scale, -1, true);
    }

    public static Label of(Supplier<Component> message, float scale) {
        return new DynamicLabel(message, scale, -1, true);
    }

    public Label(Component message, float scale, int color, boolean dropShadow) {
        super(message);
        this.setScale(scale);
        this.color = color;
        this.dropShadow = dropShadow;
    }

    protected boolean m_7972_(int button) {
        return false;
    }

    @Override
    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(this.scale, this.scale, 1.0f);
        WidgetPos boundary = this.getBoundary().inner();
        Font font = Minecraft.m_91087_().f_91062_;
        if (boundary.width() < this.length) {
            Label.renderScrollingString(guiGraphics, font, this.m_6035_(), (int)((float)boundary.x() / this.scale), (int)((float)boundary.y() / this.scale), (int)((float)boundary.maxX() / this.scale), (int)((float)boundary.maxY() / this.scale), this.color, this.dropShadow);
        } else {
            guiGraphics.m_280649_(font, this.m_6035_().m_7532_(), (int)((float)boundary.x() / this.scale), (int)((float)boundary.y() / this.scale), this.color, this.dropShadow);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component text, int minX, int minY, int maxX, int maxY, int color, boolean dropShadow) {
        Label.renderScrollingString(guiGraphics, font, text, (minX + maxX) / 2, minX, minY, maxX, maxY, color, dropShadow);
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component text, int centerX, int minX, int minY, int maxX, int maxY, int color, boolean dropShadow) {
        int i = font.m_92852_((FormattedText)text);
        int j = (minY + maxY - 9) / 2 + 1;
        int k = maxX - minX;
        if (i > k) {
            int l = i - k;
            double d0 = (double)Util.m_137550_() / 1000.0;
            double d1 = Math.max((double)l * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double d3 = Mth.m_14139_((double)d2, (double)0.0, (double)l);
            guiGraphics.m_280588_(minX, 0, maxX, Integer.MAX_VALUE);
            guiGraphics.m_280430_(font, text, minX - (int)d3, j, color);
            guiGraphics.m_280618_();
        } else {
            int i1 = Mth.m_14045_((int)centerX, (int)(minX + i / 2), (int)(maxX - i / 2));
            guiGraphics.m_280653_(font, text, i1, j, color);
        }
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, this.m_6035_());
    }

    public void m_93666_(Component message) {
        super.m_93666_(message);
        this.setScale(this.scale);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
        Font font = Minecraft.m_91087_().f_91062_;
        this.length = font.m_92852_((FormattedText)this.m_6035_());
        this.setFixWidth((int)((float)this.length * scale));
        Objects.requireNonNull(font);
        this.setYMin((int)(9.0f * scale));
    }

    @Override
    public void trim() {
        Font font = Minecraft.m_91087_().f_91062_;
        this.length = font.m_92852_((FormattedText)this.m_6035_());
        this.setFixWidth((int)((float)this.length * this.scale));
        Objects.requireNonNull(font);
        this.setFixHeight((int)(9.0f * this.scale));
    }

    public Label setColor(int color) {
        this.color = color;
        return this;
    }

    public static class DynamicLabel
    extends Label {
        private final Supplier<Component> textSupplier;

        public DynamicLabel(Supplier<Component> textSupplier, float scale, int color, boolean dropShadow) {
            super(textSupplier.get(), scale, color, dropShadow);
            this.textSupplier = textSupplier;
        }

        @Override
        public boolean update(IUpdateMarker marker) {
            Component newText = this.textSupplier.get();
            if (this.m_6035_().equals(newText)) {
                return false;
            }
            this.m_93666_(newText);
            return true;
        }
    }
}

