/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.client.gui.frame.widget.basic;

import com.xkball.auto_translate.client.gui.frame.core.HorizontalAlign;
import com.xkball.auto_translate.client.gui.frame.core.IPanel;
import com.xkball.auto_translate.client.gui.frame.core.ITypeset;
import com.xkball.auto_translate.client.gui.frame.core.VerticalAlign;
import com.xkball.auto_translate.client.gui.frame.core.WidgetBoundary;
import com.xkball.auto_translate.client.gui.frame.core.WidgetPos;
import com.xkball.auto_translate.client.gui.frame.widget.basic.BaseContainerWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class HorizontalPanel
extends BaseContainerWidget
implements ITypeset {
    public final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
    public final List<IPanel> childrenPanels = new ArrayList<IPanel>();
    public HorizontalAlign horizontalAlign = HorizontalAlign.CENTER;
    public VerticalAlign verticalAlign = VerticalAlign.CENTER;

    public HorizontalPanel() {
        this(0, 0, (Component)Component.m_237119_());
    }

    public HorizontalPanel(int width, int height, Component message) {
        super(message);
        this.xPercentage = 1.0f;
        this.yPercentage = 1.0f;
        this.widgetBoundary = new WidgetBoundary(new WidgetPos(0, 0, width, height), new WidgetPos(0, 0, width, height));
    }

    public <T extends AbstractWidget> HorizontalPanel addWidget(T wrapper) {
        return this.addWidget(wrapper, false);
    }

    public <T extends AbstractWidget> HorizontalPanel addWidget(T wrapper, boolean resize) {
        this.children.add(wrapper);
        this.childrenPanels.add((IPanel)wrapper);
        if (resize) {
            this.resize();
        }
        return this;
    }

    public <T extends AbstractWidget> HorizontalPanel addWidgets(Supplier<List<T>> widgets, boolean resize) {
        List<T> list = widgets.get();
        this.children.addAll(list);
        this.childrenPanels.addAll(list);
        if (resize) {
            this.resize();
        }
        return this;
    }

    public void clearWidget() {
        this.children.clear();
        this.childrenPanels.clear();
    }

    public WidgetPos getInnerPos() {
        return this.widgetBoundary.inner();
    }

    @Override
    public void resize() {
        WidgetPos parentPos = this.getInnerPos();
        int x = parentPos.x();
        for (IPanel widget : this.childrenPanels) {
            IPanel.calculateBoundary(widget, parentPos, x, parentPos.y());
            x += widget.getBoundary().outer().width();
        }
        int widthSum = x - parentPos.x();
        int shiftX = IPanel.calculateShift(this.horizontalAlign, parentPos.width(), widthSum);
        for (IPanel widget : this.childrenPanels) {
            int shiftY = IPanel.calculateShift(this.verticalAlign, parentPos.height(), widget.getBoundary().outer().height());
            widget.shiftWidgetBoundary(shiftX, shiftY);
            widget.resize();
        }
    }

    protected boolean m_7972_(int button) {
        return false;
    }

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderDecoration(guiGraphics, mouseX, mouseY, partialTick);
        for (AbstractWidget child : this.children) {
            child.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        for (AbstractWidget child : this.children) {
            child.m_142291_(narrationElementOutput);
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.f_93623_ && this.f_93624_ && this.getBoundary().inner().inside(mouseX, mouseY);
    }

    @Override
    public List<IPanel> getChildren() {
        return this.childrenPanels;
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }

    @Override
    public VerticalAlign getVerticalAlign() {
        return this.verticalAlign;
    }

    @Override
    public HorizontalAlign getHorizontalAlign() {
        return this.horizontalAlign;
    }

    @Override
    public void setVerticalAlign(VerticalAlign verticalAlign) {
        this.verticalAlign = verticalAlign;
    }

    @Override
    public void setHorizontalAlign(HorizontalAlign horizontalAlign) {
        this.horizontalAlign = horizontalAlign;
    }
}

