/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.client.gui.frame.widget.basic;

import com.mojang.blaze3d.systems.RenderSystem;
import com.xkball.auto_translate.api.IExtendedGuiGraphics;
import com.xkball.auto_translate.client.gui.frame.core.IPanel;
import com.xkball.auto_translate.client.gui.frame.core.WidgetBoundary;
import com.xkball.auto_translate.client.gui.frame.core.WidgetPos;
import com.xkball.auto_translate.client.gui.frame.core.render.GuiDecorations;
import com.xkball.auto_translate.client.gui.frame.core.render.SimpleBackgroundRenderer;
import com.xkball.auto_translate.client.gui.frame.widget.basic.VerticalPanel;
import com.xkball.auto_translate.mixin.MixinAbstractWidgetAccess;
import com.xkball.auto_translate.utils.VanillaUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Vector2f;

public class ScrollableVerticalPanel
extends VerticalPanel {
    protected static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/scroller");
    protected static final ResourceLocation SCROLLER_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/scroller_background");
    public IntArrayList heightList = new IntArrayList();
    public int maxScroll = 0;
    public int maxPosition = 0;
    public double scrollAmount;
    public boolean scrolling;
    @Nullable
    public AbstractWidget selected;
    @Nullable
    public AbstractWidget hovered;

    @Override
    public void clearWidget() {
        super.clearWidget();
        this.heightList.clear();
        this.selected = null;
        this.hovered = null;
    }

    @Override
    public void resize() {
        int heightSum;
        this.heightList.clear();
        WidgetPos parentPos = this.widgetBoundary.inner();
        WidgetPos parentPos_ = new WidgetPos(parentPos.x(), parentPos.y(), parentPos.width(), 0x3FFFFFFF);
        int y = parentPos.y();
        for (IPanel widget : this.childrenPanels) {
            IPanel.calculateBoundary(widget, parentPos_, parentPos.x(), y);
            this.heightList.add((y += widget.getBoundary().outer().height()) - parentPos.y());
        }
        this.maxPosition = heightSum = y - parentPos.y();
        this.maxScroll = Math.max(0, heightSum - parentPos.height() + 6);
        int shiftY = IPanel.calculateShift(this.verticalAlign, parentPos.height(), heightSum);
        for (IPanel widget : this.childrenPanels) {
            int shiftX = IPanel.calculateShift(this.horizontalAlign, parentPos.width(), widget.getBoundary().outer().width());
            widget.shiftWidgetBoundary(shiftX, shiftY);
            widget.resize();
        }
        this.clampScrollAmount();
    }

    public void renderSelectedBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.selected == null) {
            return;
        }
        AbstractWidget abstractWidget = this.selected;
        if (abstractWidget instanceof IPanel) {
            IPanel panel = (IPanel)abstractWidget;
            if (!panel.drawBorderOnFocused()) {
                return;
            }
            WidgetBoundary boundary = panel.getBoundary();
            SimpleBackgroundRenderer.GRAY.render(guiGraphics, boundary, mouseX, mouseY, partialTicks);
            if (boundary.outer().inside(mouseX, mouseY)) {
                GuiDecorations.WHITE_BORDER.render(guiGraphics, boundary, mouseX, mouseY, partialTicks);
            } else {
                GuiDecorations.GRAY_BORDER.render(guiGraphics, boundary, mouseX, mouseY, partialTicks);
            }
        } else {
            guiGraphics.m_280509_(this.selected.m_252754_(), this.selected.m_252907_(), this.selected.m_252754_() + this.selected.m_5711_(), this.selected.m_252907_() + this.selected.m_93694_(), VanillaUtils.GUI_GRAY);
        }
    }

    public int getBoundaryHeight() {
        return this.getBoundary().inner().height();
    }

    public int getBoundaryY() {
        return this.getBoundary().inner().y();
    }

    public void translateGUIMatrix(GuiGraphics guiGraphics) {
        guiGraphics.m_280168_().m_85837_(0.0, -this.scrollAmount, 0.0);
    }

    public Vector2f getActualMousePos(float mouseX, float mouseY) {
        return new Vector2f(mouseX, (float)((double)mouseY + this.scrollAmount));
    }

    @Override
    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderDecoration(guiGraphics, mouseX, mouseY, partialTick);
        this.hovered = this.getEntryAtPosition(mouseX, mouseY);
        guiGraphics.m_280168_().m_85836_();
        this.enableScissor(guiGraphics);
        this.translateGUIMatrix(guiGraphics);
        this.renderSelectedBackground(guiGraphics, mouseX, mouseY, partialTick);
        Vector2f actualMouse = this.getActualMousePos(mouseX, mouseY);
        IExtendedGuiGraphics.cast(guiGraphics).xat_pushOffset(0, (int)this.scrollAmount);
        for (int i = 0; i < this.heightList.size(); ++i) {
            int pos = this.heightList.getInt(i);
            AbstractWidget widget = (AbstractWidget)this.children.get(i);
            if ((double)pos < this.scrollAmount - 10.0) continue;
            if ((double)pos > this.scrollAmount + (double)this.getBoundaryHeight() + (double)widget.m_93694_() + 10.0) break;
            ScreenRectangle widgetRec = widget.m_264198_();
            widget.f_93622_ = actualMouse.x >= (float)widget.m_252754_() && actualMouse.y >= (float)widget.m_252907_() && actualMouse.x < (float)(widget.m_252754_() + widget.m_5711_()) && actualMouse.y < (float)(widget.m_252907_() + widget.m_93694_());
            ((MixinAbstractWidgetAccess)widget).invokeRenderWidget(guiGraphics, mouseX, (int)actualMouse.y, partialTick);
            this.refreshScrollWidgetTooltip(widget.m_278622_(), widget.m_274382_(), widget.m_93696_(), new ScreenRectangle(new ScreenPosition(widgetRec.m_274563_(), (int)((double)widgetRec.m_274449_() - this.scrollAmount)), widgetRec.f_263770_(), widgetRec.f_263800_()));
        }
        this.renderDecoration(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280618_();
        guiGraphics.m_280168_().m_85849_();
        IExtendedGuiGraphics.cast(guiGraphics).xat_popOffset();
        if (this.scrollbarVisible()) {
            int l = this.getScrollbarPosition();
            int h = this.getBoundaryHeight();
            int y = this.getBoundaryY();
            int i1 = (int)((float)(h * h) / (float)this.maxPosition);
            int k = (int)this.scrollAmount * (h - (i1 = Mth.m_14045_((int)i1, (int)32, (int)(h - 8)))) / this.maxScroll + y;
            if (k < this.m_252907_()) {
                k = this.m_252907_();
            }
            RenderSystem.enableBlend();
            guiGraphics.m_280218_(SCROLLER_BACKGROUND_SPRITE, l, y, 0, 0, 6, h);
            guiGraphics.m_280218_(SCROLLER_SPRITE, l, k, 0, 0, 6, i1);
            RenderSystem.disableBlend();
        }
    }

    private void refreshScrollWidgetTooltip(@Nullable Tooltip tooltip, boolean isHovered, boolean isFocused, ScreenRectangle rect) {
        Screen screen;
        boolean flag;
        if (tooltip == null) {
            return;
        }
        boolean bl = flag = isHovered || isFocused && Minecraft.m_91087_().m_264529_().m_264505_();
        if (flag && (screen = Minecraft.m_91087_().f_91080_) != null) {
            screen.m_262791_(tooltip, DefaultTooltipPositioner.f_262752_, isFocused);
        }
    }

    protected boolean scrollbarVisible() {
        return this.maxScroll > 0;
    }

    protected void enableScissor(GuiGraphics guiGraphics) {
        WidgetPos bound = this.getBoundary().inner();
        guiGraphics.m_280588_(bound.x(), bound.y(), bound.maxX() - 6, bound.maxY());
    }

    protected void scroll(int scroll) {
        this.setScrollAmount(this.scrollAmount + (double)scroll);
    }

    public void setClampedScrollAmount(double scroll) {
        this.scrollAmount = Mth.m_14008_((double)scroll, (double)0.0, (double)this.maxScroll);
    }

    public void setScrollAmount(double scroll) {
        this.setClampedScrollAmount(scroll);
    }

    public void clampScrollAmount() {
        this.setClampedScrollAmount(this.scrollAmount);
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPosition() && mouseX < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.getBoundary().inner().maxX() - 6;
    }

    protected boolean isValidMouseClick(int button) {
        return button == 0;
    }

    @Nullable
    protected AbstractWidget getEntryAtPosition(double mouseX, double mouseY) {
        if (!this.m_5953_(mouseX, mouseY)) {
            return null;
        }
        double yOnPanel = mouseY - (double)this.getBoundaryY() + this.scrollAmount;
        for (int i = 0; i < this.heightList.size(); ++i) {
            if (!(yOnPanel < (double)this.heightList.getInt(i))) continue;
            return (AbstractWidget)this.children.get(i);
        }
        return null;
    }

    protected boolean anyScrolling() {
        return this.scrolling;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.isValidMouseClick(button)) {
            return false;
        }
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        AbstractWidget widget = this.getEntryAtPosition(mouseX, mouseY);
        if (widget != null) {
            Vector2f actualMouse = this.getActualMousePos((float)mouseX, (float)mouseY);
            if (widget.m_6375_((double)actualMouse.x, (double)actualMouse.y, button)) {
                GuiEventListener oldFocused = this.m_7222_();
                if (oldFocused != widget && oldFocused instanceof ContainerEventHandler) {
                    ContainerEventHandler containereventhandler = (ContainerEventHandler)oldFocused;
                    containereventhandler.m_7522_(null);
                }
                this.m_7522_((GuiEventListener)widget);
                this.m_7897_(true);
                return true;
            }
        }
        return this.anyScrolling();
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.getBoundaryY()) {
                this.setScrollAmount(0.0);
            } else if (mouseY > (double)this.getBoundary().inner().maxY()) {
                this.setScrollAmount(this.maxScroll);
            } else {
                double d0 = Math.max(1, this.maxScroll);
                int i = this.getBoundaryHeight();
                int j = Mth.m_14045_((int)((int)((float)(i * i) / (float)this.maxPosition)), (int)32, (int)(i - 8));
                double d1 = Math.max(1.0, d0 / (double)(i - j));
                this.setScrollAmount(this.scrollAmount + dragY * d1);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        this.setScrollAmount(this.scrollAmount - scrollY * 10.0);
        return true;
    }

    public void setSelected(@Nullable AbstractWidget selected) {
        this.selected = selected;
    }

    @Override
    public void m_7522_(@Nullable GuiEventListener focused) {
        super.m_7522_(focused);
        if (focused == null) {
            this.selected = null;
        }
        if (!(focused instanceof AbstractWidget)) {
            return;
        }
        super.m_7522_(focused);
        int i = this.children.indexOf(focused);
        if (i >= 0) {
            AbstractWidget e = (AbstractWidget)this.children.get(i);
            this.setSelected(e);
            if (Minecraft.m_91087_().m_264529_().m_264505_()) {
                this.ensureVisible(e);
            }
        }
    }

    protected void ensureVisible(AbstractWidget entry) {
        int index = this.m_6702_().indexOf(entry);
        if (index < 0) {
            return;
        }
        int top = this.heightList.getInt(index);
        int bottom = index == 0 ? 0 : this.heightList.getInt(index - 1);
        double currentBottom = this.scrollAmount + (double)this.getBoundaryHeight();
        if ((double)top > currentBottom) {
            this.scroll((int)((double)top - currentBottom));
        }
        if ((double)bottom < this.scrollAmount) {
            this.scroll((int)((double)bottom - this.scrollAmount));
        }
    }
}

