/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.client.gui.screen;

import com.xkball.auto_translate.AutoTranslate;
import com.xkball.auto_translate.XATConfig;
import com.xkball.auto_translate.client.gui.frame.core.HorizontalAlign;
import com.xkball.auto_translate.client.gui.frame.core.IUpdateMarker;
import com.xkball.auto_translate.client.gui.frame.core.PanelConfig;
import com.xkball.auto_translate.client.gui.frame.core.VerticalAlign;
import com.xkball.auto_translate.client.gui.frame.screen.FrameScreen;
import com.xkball.auto_translate.client.gui.frame.widget.Label;
import com.xkball.auto_translate.client.gui.frame.widget.basic.AutoResizeWidgetWrapper;
import com.xkball.auto_translate.client.gui.frame.widget.basic.BaseContainerWidget;
import com.xkball.auto_translate.client.gui.frame.widget.basic.HorizontalPanel;
import com.xkball.auto_translate.client.gui.frame.widget.basic.ScrollableVerticalPanel;
import com.xkball.auto_translate.client.gui.frame.widget.basic.VerticalPanel;
import com.xkball.auto_translate.client.gui.widget.ObjectInputBox;
import com.xkball.auto_translate.data.XATDataBase;
import com.xkball.auto_translate.utils.ClientUtils;
import com.xkball.auto_translate.utils.VanillaUtils;
import com.xkball.auto_translate.utils.translate.LangKeyTranslateUnit;
import com.xkball.auto_translate.utils.translate.TranslatorType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;

public class XATConfigScreen
extends FrameScreen {
    private static final PanelConfig LINE_BASE = PanelConfig.of(0.5f, 1.0f).align(HorizontalAlign.LEFT, VerticalAlign.CENTER).paddingTop(8.0f).paddingLeft(0.25f);
    @Nullable
    private final Screen parentScreen;
    private static final LangKeyTranslateUnit translateUnit = new LangKeyTranslateUnit();

    public XATConfigScreen(@Nullable Screen parent) {
        super((Component)Component.m_237119_());
        this.parentScreen = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        VerticalPanel content = PanelConfig.of(1.0f, 1.0f).align(HorizontalAlign.LEFT, VerticalAlign.TOP).apply(new ScrollableVerticalPanel().addWidget(this.createConfigTitle("xat.gui.config.title.network")).addWidget(this.createEntry("xat.gui.config.http_host", XATConfig.HTTP_PROXY_HOST_CONFIG, ObjectInputBox::createStringInput)).addWidget(this.createEntry("xat.gui.config.http_port", (ForgeConfigSpec.ConfigValue)XATConfig.HTTP_PROXY_PORT_CONFIG, () -> new ObjectInputBox<Integer>(ObjectInputBox.INT_VALIDATOR, ObjectInputBox.INT_RESPONDER))).addWidget(this.createEntry("xat.gui.config.max_retries", (ForgeConfigSpec.ConfigValue)XATConfig.MAX_RETRIES_CONFIG, () -> new ObjectInputBox<Integer>(ObjectInputBox.INT_VALIDATOR, ObjectInputBox.INT_RESPONDER))).addWidget(this.createConfigTitle("xat.gui.config.title.translator")).addWidget(this.createEntryEnum("xat.gui.config.translator", XATConfig.TRANSLATOR_TYPE_CONFIG, TranslatorType.class)).addWidget(this.createTargetEntry()).addWidget(this.createConfigTitle("xat.gui.config.title.llm_config")).addWidget(this.createEntry("xat.gui.config.llm_api_url", XATConfig.LLM_API_URL_CONFIG, ObjectInputBox::createStringInput)).addWidget(this.createEntry("xat.gui.config.llm_model", XATConfig.LLM_MODEL_CONFIG, ObjectInputBox::createStringInput)).addWidget(this.createAPIKeyInput()).addWidget(this.createConfigTitle("xat.gui.run_trans_keys")).addWidget(this.addNotice("xat.gui.config.run_trans_notice")).addWidget(this.createRunTransKeys()).addWidget(this.createProcessingBar()).addWidget(this.createConfigTitle("xat.gui.config.title.others")).addWidget(this.createTokenCostLabel()).addWidget(this.createClearAllButton()));
        VerticalPanel screen = this.screenFrame("xat.gui.config", content);
        screen.resize();
        this.m_142416_((GuiEventListener)screen);
        this.updateScreen();
    }

    public Label createConfigTitle(String key) {
        return PanelConfig.of(1.0f, 1.0f).paddingTop(12.0f).paddingLeft(0.2f).trim().apply(Label.ofKey(key, 1.6f));
    }

    public BaseContainerWidget addNotice(String key) {
        return LINE_BASE.fork().fixHeight(10).apply(new HorizontalPanel().addWidget(PanelConfig.of(1.0f, 1.0f).trim().apply(Label.ofKey(key))));
    }

    public BaseContainerWidget createTokenCostLabel() {
        return LINE_BASE.fork().fixHeight(10).apply(new HorizontalPanel(){

            @Override
            public boolean update(IUpdateMarker updateMarker) {
                this.clearWidget();
                this.addWidget(PanelConfig.of(1.0f, 1.0f).trim().apply(Label.of((Component)Component.m_237110_((String)"xat.gui.token_cost", (Object[])new Object[]{XATDataBase.INSTANCE.getTokenCost()}))));
                return true;
            }
        });
    }

    public BaseContainerWidget createClearAllButton() {
        return LINE_BASE.fork().fixHeight(40).apply(new HorizontalPanel().addWidget(PanelConfig.of(1.0f, 1.0f).fixHeight(20).paddingLeft(8.0f).paddingRight(8.0f).apply(FrameScreen.createButton("xat.gui.btn.clear_all_cache", XATDataBase.INSTANCE::clearAllTranslateCache))));
    }

    public BaseContainerWidget createProcessingBar() {
        return LINE_BASE.fork().align(HorizontalAlign.CENTER, VerticalAlign.CENTER).fixHeight(10).apply(new HorizontalPanel(){

            @Override
            public boolean update(IUpdateMarker updateMarker) {
                this.clearWidget();
                this.addWidget(PanelConfig.of(0.4f, 1.0f).paddingRight(4.0f).trim().apply(Label.of(I18n.m_118938_((String)"xat.gui.processing", (Object[])new Object[0]) + translateUnit.normalFinishedSize() + "/" + translateUnit.size()).setColor(VanillaUtils.getColor(0, 255, 0, 255))));
                this.addWidget(PanelConfig.of(0.4f, 1.0f).paddingLeft(4.0f).trim().apply(Label.of(I18n.m_118938_((String)"xat.gui.error", (Object[])new Object[0]) + translateUnit.errorSize() + "/" + translateUnit.size()).setColor(VanillaUtils.getColor(255, 0, 0, 255))));
                return true;
            }
        });
    }

    public BaseContainerWidget createRunTransKeys() {
        final AutoResizeWidgetWrapper btn1 = FrameScreen.createButton("xat.gui.btn.run_trans_keys", this::runTransKeys);
        final AutoResizeWidgetWrapper btn2 = FrameScreen.createButton("xat.gui.btn.cancel_inject_lang", () -> {
            translateUnit.cancel();
            XATDataBase.INSTANCE.enableInjectLang(false);
            AutoTranslate.cancelInjectLanguage();
            this.setNeedUpdate();
        });
        final AutoResizeWidgetWrapper btn3 = FrameScreen.createButton("xat.gui.btn.clear_cache", LangKeyTranslateUnit.I18N_KEYS::clear);
        final PanelConfig btnConfig = PanelConfig.of(0.25f, 1.0f).paddingLeft(4.0f).paddingRight(4.0f).fixHeight(20);
        return LINE_BASE.fork().align(HorizontalAlign.CENTER, VerticalAlign.CENTER).fixHeight(40).apply(new HorizontalPanel(){

            @Override
            public boolean update(IUpdateMarker updateMarker) {
                btn1.inner.f_93623_ = XATConfigScreen.translateUnit.finished;
                btn2.inner.f_93623_ = XATDataBase.INSTANCE.isEnableInjectLang();
                this.clearWidget();
                this.addWidget(btnConfig.apply(btn1));
                this.addWidget(btnConfig.apply(btn2));
                this.addWidget(btnConfig.apply(btn3));
                return true;
            }
        });
    }

    public void runTransKeys() {
        translateUnit.reset();
        this.setNeedUpdate();
        XATDataBase.INSTANCE.enableInjectLang(true);
        ClientLanguage en = ClientUtils.getClientLanguage("en_us");
        Set target = ClientUtils.getClientLanguage((String)XATConfig.TARGET_LANGUAGE_CONFIG.get()).getLanguageData().keySet();
        List<Map.Entry> diff = en.getLanguageData().entrySet().stream().filter(entry -> !((String)entry.getValue()).isEmpty() && LangKeyTranslateUnit.I18N_KEYS.get((String)entry.getKey()) == null && !target.contains(entry.getKey())).toList();
        if (diff.isEmpty()) {
            AutoTranslate.injectLanguage();
            return;
        }
        ArrayList<Map.Entry> diff1 = new ArrayList<Map.Entry>();
        ArrayList<Map.Entry> diff2 = new ArrayList<Map.Entry>();
        for (Map.Entry entry2 : diff) {
            if (((String)entry2.getValue()).startsWith("%") || ((String)entry2.getValue()).startsWith("-")) {
                diff2.add(entry2);
                continue;
            }
            diff1.add(entry2);
        }
        IntStream.range(0, diff1.size()).boxed().collect(Collectors.groupingBy(i -> i / 20)).values().stream().map(indexes -> indexes.stream().map(diff::get).toList()).forEach(translateUnit::submitRequest);
        diff2.forEach(entry -> translateUnit.submitRequest((String)entry.getKey(), (String)entry.getValue()));
        translateUnit.start();
    }

    public <T> AutoResizeWidgetWrapper saveButton(Supplier<T> supplier, ForgeConfigSpec.ConfigValue<T> config) {
        return XATConfigScreen.iconButton(btn -> {
            Object t = supplier.get();
            if (t == null) {
                return;
            }
            config.set(t);
            config.save();
        }, VanillaUtils.modRL("icon/save"));
    }

    public <T> BaseContainerWidget createEntry(String key, ForgeConfigSpec.ConfigValue<T> config, Supplier<ObjectInputBox<T>> inputBSupplier) {
        ObjectInputBox<T> input = inputBSupplier.get();
        FrameScreen.setupSimpleEditBox(input);
        input.m_94144_(config.get().toString());
        input.m_94198_();
        return this.createEntry_(key, AutoResizeWidgetWrapper.of(input), this.saveButton(input::get, config));
    }

    public BaseContainerWidget createTargetEntry() {
        ObjectInputBox<String> input = ObjectInputBox.createStringInput();
        ForgeConfigSpec.ConfigValue<String> config = XATConfig.TARGET_LANGUAGE_CONFIG;
        FrameScreen.setupSimpleEditBox(input);
        input.m_94144_((String)config.get());
        input.m_94198_();
        AutoResizeWidgetWrapper syncButton = FrameScreen.iconButton(btn -> input.m_94144_(Minecraft.m_91087_().m_91102_().m_264236_()), VanillaUtils.modRL("icon/sync"));
        HorizontalPanel panel = new HorizontalPanel().addWidget(PanelConfig.of(-28.0f, 1.0f).paddingRight(8.0f).apply(AutoResizeWidgetWrapper.of(input))).addWidget(PanelConfig.ofFixSize(20, 20).tooltip("xat.gui.config.tooltip.sync").apply(syncButton));
        PanelConfig.of(1.0f, 1.0f).align(HorizontalAlign.CENTER, VerticalAlign.CENTER).apply(panel);
        return this.createEntry_("xat.gui.config.target", panel, this.saveButton(input::get, config));
    }

    public <T extends Enum<T>> BaseContainerWidget createEntryEnum(String key, ForgeConfigSpec.ConfigValue<T> config, Class<T> enumValue) {
        CycleButton btn = new CycleButton.Builder(t -> Component.m_237113_((String)t.toString())).m_168961_((Object[])((Enum[])enumValue.getEnumConstants())).m_168948_((Object)((Enum)config.get())).m_168929_().m_168936_(0, 0, 0, 0, (Component)Component.m_237119_(), (cbt, t) -> {});
        return this.createEntry_(key, AutoResizeWidgetWrapper.of((AbstractWidget)btn), this.saveButton(() -> ((CycleButton)btn).m_168883_(), config));
    }

    public BaseContainerWidget createAPIKeyInput() {
        return this.createEntry_("xat.gui.config.llm_api_key", XATConfigScreen.createButton("xat.gui.config.copy_form_clipboard", () -> XATConfig.LLM_API_KEY_CONFIG.set((Object)Minecraft.m_91087_().f_91068_.m_90876_())), XATConfigScreen.iconButton(bt -> XATConfig.LLM_API_KEY_CONFIG.save(), VanillaUtils.modRL("icon/save")));
    }

    private BaseContainerWidget createEntry_(String key, BaseContainerWidget input, AutoResizeWidgetWrapper save) {
        return LINE_BASE.fork().fixHeight(40).apply(new HorizontalPanel().addWidget(PanelConfig.of(1.0f, 1.0f).fixWidth(90).paddingRight(16.0f).trim().apply(Label.ofKey(key, 1.2f))).addWidget(PanelConfig.of(0.6f, 1.0f).fixHeight(20).paddingRight(8.0f).apply(input))).addWidget(PanelConfig.ofFixSize(20, 20).tooltip("xat.gui.config.save").apply(save));
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parentScreen);
        }
    }

    @Override
    public boolean m_7043_() {
        return true;
    }
}

