/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.xkball.auto_translate.utils.VanillaUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ObjectInputBox<T>
extends EditBox
implements Renderable {
    public static final Predicate<String> PASS_VALIDATOR = str -> true;
    public static final Predicate<String> LONG_VALIDATOR = str -> {
        try {
            Long.parseLong(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    public static final Predicate<String> TIMESTAMP_VALIDATOR = LONG_VALIDATOR.and(str -> {
        try {
            LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(str)), ZoneOffset.UTC);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    });
    public static final Predicate<String> INT_VALIDATOR = str -> {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    };
    public static final Predicate<String> LOCAL_TIME_VALIDATOR = INT_VALIDATOR.and(str -> {
        if (str.length() != 9) {
            return false;
        }
        int time = Integer.parseInt(str);
        if (time < 0 || time > 240000000) {
            return false;
        }
        if (time % 10000000 / 100000 > 60) {
            return false;
        }
        return time % 100000 / 1000 <= 60;
    });
    public static final Predicate<String> FLOAT_VALIDATOR = str -> {
        try {
            Float.parseFloat(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    };
    public static final Predicate<String> NORMALIZED_FLOAT_VALIDATOR = FLOAT_VALIDATOR.and(str -> Float.parseFloat(str) >= 0.0f && Float.parseFloat(str) <= 1.0f);
    public static final Predicate<String> RGB_COLOR_VALIDATOR = str -> {
        try {
            VanillaUtils.parseColorHEX(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    };
    public static final Predicate<String> TEXTURE_VALIDATOR = str -> {
        ResourceLocation rl = ResourceLocation.m_135820_((String)str);
        if (rl == null) {
            return false;
        }
        TextureAtlasSprite texture = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_).m_118316_(rl);
        return !VanillaUtils.MISSING_TEXTURE.equals((Object)texture.m_247685_());
    };
    public static final Function<String, String> PASS_RESPONDER = str -> str;
    public static final Function<String, Integer> INT_RESPONDER = Integer::parseInt;
    public static final Function<String, Long> LONG_RESPONDER = Long::parseLong;
    public static final Function<String, Float> FLOAT_RESPONDER = Float::parseFloat;
    public static final Function<String, Integer> RGB_COLOR_RESPONDER = VanillaUtils::parseColorHEX;
    public static final Function<String, ResourceLocation> TEXTURE_RESPONDER = str -> Objects.requireNonNullElse(ResourceLocation.m_135820_((String)str), VanillaUtils.MISSING_TEXTURE);
    protected final Predicate<String> validator;
    protected final Function<String, T> responder;
    protected boolean renderState = true;
    @Nullable
    private Consumer<ObjectInputBox<T>> onLoseFocused;

    public static ObjectInputBox<String> createStringInput() {
        return new ObjectInputBox<String>(PASS_VALIDATOR, PASS_RESPONDER);
    }

    public ObjectInputBox(Predicate<String> validator, Function<String, T> responder) {
        this(Minecraft.m_91087_().f_91062_, 0, 0, 0, 0, (Component)Component.m_237119_(), validator, responder);
    }

    public ObjectInputBox(Font font, int x, int y, int width, int height, Component message, Predicate<String> validator, Function<String, T> responder) {
        super(font, x, y, width, height, message);
        this.validator = validator;
        this.responder = responder;
        this.m_93692_(false);
        this.m_94190_(true);
    }

    @Nullable
    public T get() {
        if (this.validator.test(this.m_94155_())) {
            return this.responder.apply(this.m_94155_());
        }
        return null;
    }

    public void m_93692_(boolean focused) {
        super.m_93692_(focused);
        if (this.onLoseFocused != null && !focused) {
            this.onLoseFocused.accept(this);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_93696_() && !this.m_5953_(mouseX, mouseY)) {
            this.m_93692_(false);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        String title;
        ScreenRectangle rec;
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
        if (!this.f_93624_) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        ScreenRectangle screenRectangle = rec = guiGraphics.f_279587_.f_279656_.isEmpty() ? null : (ScreenRectangle)guiGraphics.f_279587_.f_279656_.peekLast();
        if (rec != null) {
            RenderSystem.disableScissor();
            guiGraphics.m_280185_(new ScreenRectangle(rec.f_263846_().f_263719_() - 2, rec.f_263846_().f_263694_(), rec.f_263770_() + 2, rec.f_263800_()));
        }
        if (this.renderState) {
            if (this.validator.test(this.m_94155_())) {
                guiGraphics.m_280509_(this.m_252754_() - 2, this.m_252907_(), this.m_252754_(), this.m_252907_() + this.m_93694_(), VanillaUtils.getColor(0, 255, 0, 255));
            } else {
                guiGraphics.m_280509_(this.m_252754_() - 2, this.m_252907_(), this.m_252754_(), this.m_252907_() + this.m_93694_(), VanillaUtils.getColor(255, 0, 0, 255));
            }
        }
        if (rec != null) {
            guiGraphics.m_280185_(rec);
        }
        if (!(title = this.m_6035_().getString()).isEmpty()) {
            guiGraphics.m_280488_(font, title, this.m_252754_() - font.m_92895_(title) - (this.renderState ? 12 : 2), this.m_252907_() + 2, 0xFFFFFF);
        }
    }

    public boolean isRenderState() {
        return this.renderState;
    }

    public void setRenderState(boolean renderState) {
        this.renderState = renderState;
    }

    public void setOnLoseFocused(Consumer<ObjectInputBox<T>> onLoseFocused) {
        this.onLoseFocused = onLoseFocused;
    }
}

