/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.crossmod;

import com.xkball.auto_translate.XATConfig;
import com.xkball.auto_translate.api.IXATQuestExtension;
import com.xkball.auto_translate.api.IXATQuestScreenExtension;
import com.xkball.auto_translate.crossmod.XAT_JEIPlugin;
import com.xkball.auto_translate.data.TranslationCacheSlice;
import com.xkball.auto_translate.data.XATDataBase;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.quest.Quest;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;

public class CrossModBridge {
    public static final TranslationCacheSlice FTBQ_CACHE = XATDataBase.INSTANCE.createSlice("ftbq");

    @Nullable
    public static ItemStack getHoverItemOnJEIOverlay() {
        if (ModList.get().isLoaded("jei")) {
            return JEIHandler.getHoverItemOnJEIOverlay();
        }
        return null;
    }

    public static void tryTranslateFTBQuest(boolean force) {
        if (ModList.get().isLoaded("ftbquests")) {
            FTBQHandler.tryTranslateQuest(force);
        }
    }

    private static class JEIHandler {
        private JEIHandler() {
        }

        @Nullable
        public static ItemStack getHoverItemOnJEIOverlay() {
            if (XAT_JEIPlugin.runtime == null) {
                return null;
            }
            IJeiRuntime runtime = XAT_JEIPlugin.runtime;
            ItemStack is = (ItemStack)runtime.getIngredientListOverlay().getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK);
            if (is != null) {
                return is;
            }
            is = (ItemStack)runtime.getBookmarkOverlay().getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK);
            if (is != null) {
                return is;
            }
            return runtime.getRecipesGui().getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK).orElse(null);
        }
    }

    public static class FTBQHandler {
        public static void tryTranslateQuest(boolean force) {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (!(screen instanceof IScreenWrapper)) {
                return;
            }
            IScreenWrapper isw = (IScreenWrapper)screen;
            BaseScreen baseScreen = isw.getGui();
            if (!(baseScreen instanceof QuestScreen)) {
                return;
            }
            QuestScreen questScreen = (QuestScreen)baseScreen;
            Quest quest = questScreen.getViewedQuest();
            if (quest == null) {
                return;
            }
            IXATQuestExtension qExtension = IXATQuestExtension.asExtension(quest);
            IXATQuestScreenExtension qsExtension = IXATQuestScreenExtension.asExtension(questScreen);
            FTBQHandler.translate(qExtension.xkball_sAutoTranslate$getTitleUnmodified().getString(), force).thenRunAsync(() -> {
                qExtension.xkball_sAutoTranslate$invalidTitleCache();
                qsExtension.xkball_sAutoTranslate$markNeedRefresh();
            });
            FTBQHandler.translate(qExtension.xkball_sAutoTranslate$getSubtitleUnmodified().getString(), force).thenRunAsync(() -> {
                qExtension.xkball_sAutoTranslate$invalidSubtitleCache();
                qsExtension.xkball_sAutoTranslate$markNeedRefresh();
            });
            CompletableFuture.allOf((CompletableFuture[])qExtension.xkball_sAutoTranslate$getDescriptionUnmodified().stream().map(Component::getString).map(str -> FTBQHandler.translate(str, force)).toArray(CompletableFuture[]::new)).thenRunAsync(() -> {
                qExtension.xkball_sAutoTranslate$invalidDescriptionCache();
                qsExtension.xkball_sAutoTranslate$markNeedRefresh();
            });
            qExtension.clearAllCache();
            qsExtension.xkball_sAutoTranslate$markNeedRefresh();
        }

        private static CompletableFuture<Void> translate(String str, boolean force) {
            if (str.isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            if (!force && FTBQ_CACHE.get(str) != null) {
                return CompletableFuture.completedFuture(null);
            }
            FTBQ_CACHE.putTranslating(str);
            return XATConfig.TRANSLATOR_TYPE.getTranslator().translate(str).thenAcceptAsync(result -> FTBQ_CACHE.put(str, (String)result));
        }
    }
}

