/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.data;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.language.I18n;

public class TranslationCacheSlice {
    private final Connection conn;
    private final Set<String> translating = new HashSet<String>();
    public final String tableName;

    public TranslationCacheSlice(Connection conn, String tableName) {
        this.conn = conn;
        this.tableName = tableName;
    }

    public void putTranslating(String key) {
        this.translating.add(key);
    }

    public String get(String key) {
        String string;
        block8: {
            PreparedStatement ps = this.conn.prepareStatement("SELECT value FROM " + this.tableName + " WHERE key = ?");
            try {
                ps.setString(1, key);
                ResultSet rs = ps.executeQuery();
                String string2 = string = rs.next() ? rs.getString("value") : null;
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            ps.close();
        }
        return string;
    }

    public String getOrDefault(String key) {
        String result = this.get(key);
        if (result != null) {
            return result;
        }
        return this.translating.contains(key) ? I18n.m_118938_((String)"xkball.translator.translating", (Object[])new Object[0]) : null;
    }

    public void put(String key, String value) {
        this.translating.remove(key);
        try (PreparedStatement ps = this.conn.prepareStatement("INSERT INTO " + this.tableName + " (key, value) VALUES (?, ?) ON CONFLICT(key) DO UPDATE SET value=excluded.value");){
            ps.setString(1, key);
            ps.setString(2, value);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> toMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        String sql = "SELECT key, value FROM " + this.tableName;
        try (PreparedStatement ps = this.conn.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.put(rs.getString("key"), rs.getString("value"));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public void clear() {
        String sql = "DELETE FROM " + this.tableName;
        try (Statement stmt = this.conn.createStatement();){
            stmt.execute(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static class InMemory
    extends TranslationCacheSlice {
        private final Map<String, String> cache = new HashMap<String, String>();

        public InMemory(String tableName) {
            super(null, tableName);
        }

        @Override
        public void put(String key, String value) {
            this.cache.put(key, value);
        }

        @Override
        public String get(String key) {
            return this.cache.get(key);
        }

        @Override
        public Map<String, String> toMap() {
            return Map.copyOf(this.cache);
        }

        @Override
        public void clear() {
            this.cache.clear();
        }
    }
}

