/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.llm;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.xkball.auto_translate.XATConfig;
import com.xkball.auto_translate.event.XATConfigUpdateEvent;
import com.xkball.auto_translate.llm.ILLMHandler;
import com.xkball.auto_translate.llm.LLMRequest;
import com.xkball.auto_translate.llm.LLMResponse;
import com.xkball.auto_translate.utils.HttpUtils;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

public class LLMClientImpl {
    private static volatile HttpClient CLIENT = HttpHandler.createClient();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Executor EXECUTOR = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 6L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private final Semaphore semaphore = new Semaphore(8);
    private final String url;
    private final String apiKey;
    private final String model;
    private final int maxRetries;
    private Boolean valid = null;
    private final Queue<Pair<LLMRequest, ILLMHandler>> requests = new ConcurrentLinkedQueue<Pair<LLMRequest, ILLMHandler>>();

    protected LLMClientImpl(String url, String apiKey, String model, int maxRetries) {
        this.url = url;
        this.apiKey = apiKey;
        this.model = model;
        this.maxRetries = maxRetries;
    }

    public boolean valid() {
        if (this.valid == null) {
            this.validification();
        }
        return this.valid != null && this.valid != false;
    }

    public boolean validification() {
        boolean flag = false;
        Either<Boolean, Throwable> result = this.sendSync(new LLMRequest("", "Checking your state. Please return true. ONLY FOUR LETTERS."), response -> !response.getContent().isEmpty());
        if (result.left().isPresent()) {
            flag = (Boolean)result.left().get();
        }
        this.valid = flag;
        return flag;
    }

    public LLMClientImpl addRequest(LLMRequest request, ILLMHandler handler) {
        this.requests.add((Pair<LLMRequest, ILLMHandler>)Pair.of((Object)request, (Object)handler));
        return this;
    }

    private HttpRequest createHttpRequest(LLMRequest request) {
        JsonObject json = new JsonObject();
        json.addProperty("model", this.model);
        for (Map.Entry<String, String> entry : request.params().entrySet()) {
            json.addProperty(entry.getKey(), entry.getValue());
        }
        JsonArray messages = new JsonArray();
        JsonObject system = new JsonObject();
        system.addProperty("role", "system");
        system.addProperty("content", request.systemPrompt());
        JsonObject user = new JsonObject();
        user.addProperty("role", "user");
        user.addProperty("content", request.userPrompt());
        messages.add((JsonElement)system);
        messages.add((JsonElement)user);
        json.add("messages", (JsonElement)messages);
        HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(this.url.trim()));
        if (!this.apiKey.isEmpty()) {
            builder.header("Authorization", "Bearer " + this.apiKey);
        }
        return builder.header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json.toString().replace('\n', ' '))).timeout(Duration.ofSeconds(20L)).build();
    }

    public void send() {
        CompletableFuture.runAsync(() -> {
            while (!this.requests.isEmpty()) {
                Pair<LLMRequest, ILLMHandler> request = this.requests.poll();
                this.sendAsyncWithRetry((LLMRequest)request.getFirst(), (ILLMHandler)request.getSecond(), 0);
            }
        }, EXECUTOR);
    }

    public void sendAsyncWithRetry(LLMRequest req, ILLMHandler handler, int retries) {
        if (retries > this.maxRetries) {
            LOGGER.warn("LLM Request Exceeded Max Retries: {}", (Object)retries);
            handler.onRetriesExceeded();
        } else {
            if (retries > 0) {
                LockSupport.parkNanos(200000L);
            }
            ((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(this.semaphore::acquireUninterruptibly, EXECUTOR).thenCompose(ignore -> this.sendAsync(req, handler::handle))).handle((b, ex) -> {
                if (ex != null) {
                    LOGGER.error("LLM Request Error", ex);
                    b = false;
                }
                this.semaphore.release();
                return b;
            })).thenAccept(res -> {
                if (!res.booleanValue()) {
                    this.sendAsyncWithRetry(req, handler, retries + 1);
                }
            });
        }
    }

    public <T> CompletableFuture<T> sendAsync(LLMRequest req, Function<LLMResponse, T> overrideHandler) {
        return HttpUtils.sendWithRetry(CLIENT, this.createHttpRequest(req), XATConfig.MAX_RETRIES).thenApplyAsync(response -> overrideHandler.apply(LLMResponse.fromString((String)response.body())), EXECUTOR);
    }

    public <T> Either<T, Throwable> sendSync(LLMRequest req, Function<LLMResponse, T> overrideHandler) {
        try {
            Object t = ((CompletableFuture)HttpUtils.sendWithRetry(CLIENT, this.createHttpRequest(req), XATConfig.MAX_RETRIES).thenApplyAsync(response -> overrideHandler.apply(LLMResponse.fromString((String)response.body())), EXECUTOR)).get();
            return Either.left(t);
        }
        catch (InterruptedException | ExecutionException e) {
            return Either.right((Object)e);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class HttpHandler {
        public static HttpClient createClient() {
            HttpClient.Builder builder = HttpClient.newBuilder();
            if (!XATConfig.HTTP_PROXY_HOST.isEmpty()) {
                builder.proxy(ProxySelector.of(new InetSocketAddress(XATConfig.HTTP_PROXY_HOST, XATConfig.HTTP_PROXY_PORT)));
            }
            builder.connectTimeout(Duration.ofSeconds(30L));
            return builder.build();
        }

        @SubscribeEvent
        public static void onUpdateHttpConfig(XATConfigUpdateEvent.Http event) {
            if (event.changed()) {
                CLIENT = HttpHandler.createClient();
            }
        }
    }

    public static class Builder {
        private String url;
        private String apiKey;
        private String model;
        private int maxRetries = 1;

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setApiKey(String key) {
            this.apiKey = key;
            return this;
        }

        public Builder setMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder setModel(String model) {
            this.model = model;
            return this;
        }

        public LLMClientImpl build() {
            return new LLMClientImpl(this.url, this.apiKey, this.model, this.maxRetries);
        }
    }
}

