/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.xkball.auto_translate.api.ITranslatableFinder;
import com.xkball.auto_translate.data.TranslationCacheSlice;
import com.xkball.auto_translate.data.XATDataBase;
import com.xkball.auto_translate.utils.ClientUtils;
import com.xkball.auto_translate.utils.VanillaUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@ParametersAreNonnullByDefault
@Mixin(value={BookViewScreen.class})
public class MixinBookViewScreen
extends Screen
implements ITranslatableFinder {
    @Shadow
    private List<FormattedCharSequence> f_98255_;
    @Unique
    private static final TranslationCacheSlice XAT_CACHE = XATDataBase.INSTANCE.createSlice("books");
    @Unique
    private final AtomicBoolean xat_tr = new AtomicBoolean(false);
    @Unique
    private final List<String> xat_currentPaceCache = new ArrayList<String>();

    protected MixinBookViewScreen(Component title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    public void onInit(CallbackInfo ci) {
        ImageButton xat_btn = new ImageButton(this.f_96543_ / 2 + 100 + 8, 196, 20, 20, 0, 0, 0, VanillaUtils.modRL("icon/xat_icon"), 16, 16, b -> {
            this.xat_tr.set(!this.xat_tr.get());
            if (this.xat_tr.get()) {
                this.submit(false);
            }
        }, (Component)Component.m_237119_());
        xat_btn.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"xat.gui.toggle_translate")));
        this.m_142416_((GuiEventListener)xat_btn);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/network/chat/Component;translatable(Ljava/lang/String;[Ljava/lang/Object;)Lnet/minecraft/network/chat/MutableComponent;")})
    public void onRender(GuiGraphics p_281997_, int p_281262_, int p_283321_, float p_282251_, CallbackInfo ci) {
        this.xat_currentPaceCache.clear();
        this.xat_currentPaceCache.addAll(this.f_98255_.stream().map(ClientUtils::getAsString).toList());
        if (this.xat_tr.get()) {
            this.submit(false);
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/util/FormattedCharSequence;IIIZ)I", shift=At.Shift.AFTER)})
    public void onRenderString(GuiGraphics guiGraphics, int p_281262_, int p_283321_, float p_282251_, CallbackInfo ci, @Local(ordinal=2) int i, @Local(ordinal=6) int l) {
        if (this.xat_tr.get()) {
            String str = XAT_CACHE.get(this.xat_currentPaceCache.get(l));
            if (str == null) {
                str = I18n.m_118938_((String)"xkball.translator.translating", (Object[])new Object[0]);
            }
            guiGraphics.m_280056_(this.f_96547_, str, i + 146 + 36, 32 + l * 9, 0, false);
        }
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        super.m_280273_(guiGraphics);
        if (this.xat_tr.get()) {
            guiGraphics.m_280163_(BookViewScreen.f_98252_, (this.f_96543_ - 192) / 2 + 146, 2, 0.0f, 0.0f, 192, 192, 256, 256);
        }
    }

    @Override
    public List<String> findTranslatable(boolean force) {
        this.xat_tr.set(true);
        if (force) {
            return this.xat_currentPaceCache;
        }
        return this.xat_currentPaceCache.stream().filter(str -> XAT_CACHE.get((String)str) == null).toList();
    }

    @Override
    public void consumeResult(String raw, String value) {
        XAT_CACHE.put(raw, value);
    }
}

