/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.mixin;

import com.mojang.datafixers.util.Pair;
import com.xkball.auto_translate.api.IXATQuestExtension;
import com.xkball.auto_translate.crossmod.CrossModBridge;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Quest.class}, remap=false)
public abstract class MixinFTBQQuest
extends QuestObject
implements IXATQuestExtension {
    @Shadow
    private Component cachedSubtitle;
    @Shadow
    private List<Component> cachedDescription;
    @Unique
    private volatile boolean xkball_sAutoTranslate$invalidedTitleCache = false;
    @Unique
    private volatile boolean xkball_sAutoTranslate$invalidedSubtitleCache = false;
    @Unique
    private volatile boolean xkball_sAutoTranslate$invalidedDescriptionCache = false;

    @Shadow
    public abstract List<String> getRawDescription();

    @Shadow
    public abstract String getRawSubtitle();

    private MixinFTBQQuest(long id) {
        super(id);
    }

    @Inject(method={"buildDescriptionIndex"}, at={@At(value="RETURN")})
    public void onBuildPageIndex(CallbackInfoReturnable<List<Pair<Integer, Integer>>> cir) {
        if (this.cachedDescription == null) {
            return;
        }
        List list = (List)cir.getReturnValue();
        if (list.isEmpty()) {
            return;
        }
        Pair last = (Pair)list.get(list.size() - 1);
        list.set(list.size() - 1, Pair.of((Object)((Integer)last.getFirst()), (Object)(this.cachedDescription.size() - 1)));
    }

    @Inject(method={"getSubtitle"}, at={@At(value="HEAD")})
    public void beforeGetSubtitle(CallbackInfoReturnable<Component> cir) {
        if (this.xkball_sAutoTranslate$isInvalidSubtitleCache()) {
            this.cachedSubtitle = null;
        }
        if (this.cachedSubtitle == null) {
            this.xkball_sAutoTranslate$invalidSubtitleCache();
        }
    }

    @Inject(method={"getSubtitle"}, at={@At(value="RETURN")})
    public void afterGetSubtitle(CallbackInfoReturnable<Component> cir) {
        if (this.xkball_sAutoTranslate$isInvalidSubtitleCache()) {
            this.xkball_sAutoTranslate$setValidSubtitleCache(false);
            String translation = CrossModBridge.FTBQ_CACHE.getOrDefault(this.cachedSubtitle.getString());
            if (translation != null) {
                this.cachedSubtitle = Component.m_237119_().m_7220_(this.cachedSubtitle).m_7220_((Component)Component.m_237113_((String)translation).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }

    @Inject(method={"getDescription"}, at={@At(value="HEAD")})
    public void beforeGetDescription(CallbackInfoReturnable<Component> cir) {
        if (this.xkball_sAutoTranslate$isInvalidDescriptionCache()) {
            this.cachedDescription = null;
        }
        if (this.cachedDescription == null) {
            this.xkball_sAutoTranslate$invalidDescriptionCache();
        }
    }

    @Inject(method={"getDescription"}, at={@At(value="RETURN")})
    public void afterGetDescription(CallbackInfoReturnable<Component> cir) {
        if (this.xkball_sAutoTranslate$isInvalidDescriptionCache()) {
            this.xkball_sAutoTranslate$setValidDescriptionCache(false);
            assert (this.cachedDescription != null);
            ArrayList<Component> list = new ArrayList<Component>(this.cachedDescription);
            list.add((Component)Component.m_237119_());
            for (Component component : this.cachedDescription) {
                String translation = CrossModBridge.FTBQ_CACHE.getOrDefault(component.getString());
                if (translation == null) continue;
                list.add((Component)Component.m_237113_((String)translation).m_130948_(component.m_7383_()));
            }
            this.cachedDescription = Collections.unmodifiableList(list);
        }
    }

    @Override
    @Unique
    public List<Component> xkball_sAutoTranslate$getDescriptionUnmodified() {
        return this.getRawDescription().stream().map(TextUtils::parseRawText).toList();
    }

    @Override
    @Unique
    public Component xkball_sAutoTranslate$getSubtitleUnmodified() {
        return TextUtils.parseRawText((String)this.getRawSubtitle());
    }

    @Override
    @Unique
    public Component xkball_sAutoTranslate$getTitleUnmodified() {
        if (!this.getRawTitle().isEmpty()) {
            return TextUtils.parseRawText((String)this.getRawTitle());
        }
        return this.getAltTitle();
    }

    @Override
    public void xkball_sAutoTranslate$invalidTitleCache() {
        this.xkball_sAutoTranslate$invalidedTitleCache = true;
    }

    @Override
    public boolean xkball_sAutoTranslate$isInvalidTitleCache() {
        return this.xkball_sAutoTranslate$invalidedTitleCache;
    }

    @Override
    public void xkball_sAutoTranslate$invalidSubtitleCache() {
        this.xkball_sAutoTranslate$invalidedSubtitleCache = true;
    }

    @Override
    public boolean xkball_sAutoTranslate$isInvalidSubtitleCache() {
        return this.xkball_sAutoTranslate$invalidedSubtitleCache;
    }

    @Override
    public void xkball_sAutoTranslate$invalidDescriptionCache() {
        this.xkball_sAutoTranslate$invalidedDescriptionCache = true;
    }

    @Override
    public boolean xkball_sAutoTranslate$isInvalidDescriptionCache() {
        return this.xkball_sAutoTranslate$invalidedDescriptionCache;
    }

    @Override
    public void xkball_sAutoTranslate$setValidTitleCache(boolean validCache) {
        this.xkball_sAutoTranslate$invalidedTitleCache = validCache;
    }

    @Override
    public void xkball_sAutoTranslate$setValidSubtitleCache(boolean validCache) {
        this.xkball_sAutoTranslate$invalidedSubtitleCache = validCache;
    }

    @Override
    public void xkball_sAutoTranslate$setValidDescriptionCache(boolean validCache) {
        this.xkball_sAutoTranslate$invalidedDescriptionCache = validCache;
    }
}

