/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.utils.translate;

import com.mojang.logging.LogUtils;
import com.xkball.auto_translate.XATConfig;
import com.xkball.auto_translate.api.ILangKeyTrContext;
import com.xkball.auto_translate.llm.LLMRequest;
import com.xkball.auto_translate.llm.LLMResponse;
import com.xkball.auto_translate.utils.LegacyUtils;
import com.xkball.auto_translate.utils.translate.LangKeyTranslateUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.slf4j.Logger;

public class GroupLangKeyTranslateContext
implements ILangKeyTrContext {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final LangKeyTranslateUnit unit;
    public final List<String> keys = new ArrayList<String>();
    public final List<String> values = new ArrayList<String>();
    public final Map<String, String> raw = new HashMap<String, String>();
    public final Map<String, String> result = new HashMap<String, String>();

    public GroupLangKeyTranslateContext(List<Map.Entry<String, String>> elt, LangKeyTranslateUnit unit) {
        this.unit = unit;
        for (Map.Entry<String, String> entry : elt) {
            if (entry.getValue().isEmpty()) {
                LOGGER.debug("empty key value pair: {},{}", (Object)entry.getKey(), (Object)entry.getValue());
                continue;
            }
            this.keys.add(entry.getKey());
            this.values.add(entry.getValue());
            this.raw.put(entry.getKey(), entry.getValue());
        }
    }

    public String createLLMRequestUserPrompt() {
        ArrayList<Map<String, String>> items = new ArrayList<Map<String, String>>();
        for (int i = 0; i < this.keys.size(); ++i) {
            items.add(Map.of("id", i, "text", this.values.get(i)));
        }
        return LegacyUtils.toYaml(items);
    }

    @Override
    public Map<String, String> getRawMap() {
        return this.raw;
    }

    @Override
    public Map<String, String> getResultMap() {
        return this.result;
    }

    @Override
    public LLMRequest createLLMRequest() {
        String sp = StrSubstitutor.replace((Object)"You will be given a YAML formatted input containing entries with \"id\" and \"text\" fields. Here is the input:\n\n<yaml>\n${yaml}\n</yaml>\n\nFor each entry in the YAML, translate the contents of the \"text\" field into ${targetLanguage}. Write the translation back into the \"text\" field for that entry.\n\nHere is an example of the expected format:\n\n<example>\nInput:\n  - id: 1\n    text: Source\nOutput:\n  - id: 1\n    text: Translation\n</example>\n\nPlease return the translated YAML directly without wrapping <yaml> tag or include any additional information.", Map.of("targetLanguage", XATConfig.TARGET_LANGUAGE));
        return new LLMRequest(sp, this.createLLMRequestUserPrompt());
    }

    @Override
    public boolean handle(LLMResponse response) {
        ArrayList<String> translateResult = new ArrayList<String>();
        try {
            List translatedItems = (List)LegacyUtils.parseYaml(response.getContent());
            for (Map map : translatedItems) {
                translateResult.add((Integer)map.get("id"), (String)map.get("text"));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot parse response to yaml: {}", (Object)response.getContent());
            return false;
        }
        if (translateResult.size() != this.keys.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.size(); ++i) {
            this.result.put(this.keys.get(i), (String)translateResult.get(i));
        }
        this.unit.submitResultFinished(this);
        return true;
    }

    @Override
    public void onRetriesExceeded() {
        this.unit.submitResultError(this);
    }

    public String toString() {
        return "LangKeyTranslateContext{unit=" + this.unit + ", keys=" + this.keys + ", values=" + this.values + ", result=" + this.result + "}";
    }
}

