/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.utils.translate;

import com.mojang.logging.LogUtils;
import com.xkball.auto_translate.XATConfig;
import com.xkball.auto_translate.api.ITranslator;
import com.xkball.auto_translate.event.XATConfigUpdateEvent;
import com.xkball.auto_translate.llm.LLMClientImpl;
import com.xkball.auto_translate.llm.LLMRequest;
import com.xkball.auto_translate.llm.LLMResponse;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.resources.language.I18n;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class LLMTranslate
implements ITranslator {
    public static final LLMTranslate INSTANCE = new LLMTranslate();
    private static final String SYSTEM_PROMPT = "You are a machine translation engine for Minecraft in-game texts. Your task is to accurately translate Minecraft in-game texts to another language while adhering to the following rules and guidelines:\n\n1. **Context-Aware Translation**: Ensure that the translation fits within the Minecraft world, considering gameplay mechanics, items, characters, or other in-game events. Be mindful of Minecraft\u2019s terminology, ensuring consistency with its established lore and gameplay features.\n\n2. **Formatting Codes**:\n   - Minecraft in-game texts include formatting codes that alter text styling, such as `\u00a7` or `&` followed by a letter or number (e.g., `\u00a70`, `&a`).\n   - **Do NOT translate these formatting codes.** You must ignore them during translation.\n   - After translating, reintegrate the formatting codes into their original positions.\n\n   **Example**:\n   - Original Text: Right-click to \u00a7bopen\u00a7r the \u00a76chest\u00a7r.\n   - Step 1: Remove the formatting codes: Right-click to open the chest.\n   - Step 2: Translate the core text: \u53f3\u952e\u70b9\u51fb\u6253\u5f00\u7bb1\u5b50\u3002\n   - Step 3: Reinsert the formatting codes: \u53f3\u952e\u70b9\u51fb\u00a7b\u6253\u5f00\u00a7r\u00a76\u7bb1\u5b50\u00a7r\u3002\n\n3. **Consistency**: Maintain consistency across all translated text. If certain terms or phrases are used repeatedly (e.g., diamond, block), ensure that the same translated text is used each time.\n\n4. **Clarity and Accuracy**: Ensure the translated text is grammatically correct, easy to understand, and appropriate for the game\u2019s context. Avoid translations that sound awkward or unnatural in the target language.\n\n5. **Tone and Style**: Minecraft\u2019s in-game texts are typically casual, friendly, and engaging. Maintain a light and approachable tone that is consistent with the overall feel of the game.\n\n6. **Input and Output Format**: User Content only contains texts need translate.If translation is unnecessary (e.g. proper nouns, codes, etc.), return the original text. You should output the translation **ONLY**.NO explanations. NO notes.\n\n7. **Translate Target**: Translate the user content to Chinese.";
    public static final String CONTENT_TEMPLE = "{\n    \"model\": \"${model}\",\n    ${modelConfig}\n    \"messages\": [\n        {\n            \"role\": \"system\",\n            \"content\": \"${systemPrompt}\"\n        },\n        {\n            \"role\": \"user\",\n            \"content\": \"${content}\"\n        }\n    ]\n}\n";
    private static final String INVALID_CONFIG_KEY = "xkball.translator.invalid_config_key";
    private static final Logger LOGGER = LogUtils.getLogger();
    public volatile LLMClientImpl client = LLMTranslate.createLLMClient();

    private LLMTranslate() {
    }

    public static LLMClientImpl createLLMClient() {
        return new LLMClientImpl.Builder().setUrl(XATConfig.LLM_API_URL).setApiKey(XATConfig.LLM_API_KEY).setModel(XATConfig.LLM_MODEL).setMaxRetries(XATConfig.MAX_RETRIES).build();
    }

    private static LLMRequest createPostRequest(String text, String lang) {
        String systemPrompt = StrSubstitutor.replace((Object)XATConfig.LLM_SYSTEM_PROMPT, Map.of("targetLanguage", lang));
        return new LLMRequest(systemPrompt, text);
    }

    @Override
    public CompletableFuture<String> translate(String text, String lang) {
        LOGGER.debug(text);
        LLMRequest reqPost = LLMTranslate.createPostRequest(text, lang);
        return this.client.sendAsync(reqPost, LLMResponse::getContent).exceptionallyAsync(t -> {
            LOGGER.warn("Network error", t);
            return I18n.m_118938_((String)"xkball.translator.error", (Object[])new Object[0]);
        });
    }

    @SubscribeEvent
    public static void onUpdateHttpConfig(XATConfigUpdateEvent.LLM event) {
        if (event.changed()) {
            LLMTranslate.INSTANCE.client = LLMTranslate.createLLMClient();
        }
    }
}

