/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.auto_translate.utils.translate;

import com.mojang.logging.LogUtils;
import com.xkball.auto_translate.AutoTranslate;
import com.xkball.auto_translate.api.ILangKeyTrContext;
import com.xkball.auto_translate.client.gui.frame.core.IPanel;
import com.xkball.auto_translate.data.TranslationCacheSlice;
import com.xkball.auto_translate.data.XATDataBase;
import com.xkball.auto_translate.llm.LLMClientImpl;
import com.xkball.auto_translate.llm.LLMRequest;
import com.xkball.auto_translate.utils.translate.GroupLangKeyTranslateContext;
import com.xkball.auto_translate.utils.translate.LLMTranslate;
import com.xkball.auto_translate.utils.translate.SingleLangKeyTranslateContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class LangKeyTranslateUnit {
    public static final TranslationCacheSlice I18N_KEYS = XATDataBase.INSTANCE.createSlice("i18n_keys");
    public static final String DEFAULT_OPENAI_MULTIPLE_PROMPT = "You will be given a YAML formatted input containing entries with \"id\" and \"text\" fields. Here is the input:\n\n<yaml>\n${yaml}\n</yaml>\n\nFor each entry in the YAML, translate the contents of the \"text\" field into ${targetLanguage}. Write the translation back into the \"text\" field for that entry.\n\nHere is an example of the expected format:\n\n<example>\nInput:\n  - id: 1\n    text: Source\nOutput:\n  - id: 1\n    text: Translation\n</example>\n\nPlease return the translated YAML directly without wrapping <yaml> tag or include any additional information.";
    private static final Logger LOGGER = LogUtils.getLogger();
    public final List<ILangKeyTrContext> contexts = new ArrayList<ILangKeyTrContext>();
    public final List<ILangKeyTrContext> contextFinished = new ArrayList<ILangKeyTrContext>();
    public final List<ILangKeyTrContext> contextError = new ArrayList<ILangKeyTrContext>();
    public boolean finished = true;

    public void submitRequest(List<Map.Entry<String, String>> elt) {
        this.contexts.add(new GroupLangKeyTranslateContext(elt, this));
    }

    public void submitRequest(String key, String value) {
        this.contexts.add(new SingleLangKeyTranslateContext(this, key, value));
    }

    public synchronized void checkFinish() {
        int contextSize = this.contexts.size();
        LOGGER.debug("Translating: {}/{}", (Object)this.contextFinished.size(), (Object)contextSize);
        IPanel.GLOBAL_UPDATE_MARKER.setNeedUpdate();
        if (this.contextFinished.size() == contextSize && this.resolveFailedRequest()) {
            this.finished = true;
            AutoTranslate.injectLanguage();
        }
    }

    public synchronized boolean resolveFailedRequest() {
        boolean flag = true;
        ArrayList<ILangKeyTrContext> newContext = new ArrayList<ILangKeyTrContext>();
        Iterator<ILangKeyTrContext> iter = this.contextError.iterator();
        while (iter.hasNext()) {
            ILangKeyTrContext failedReq = iter.next();
            if (failedReq.fallback()) continue;
            flag = false;
            iter.remove();
            Map<String, String> map = failedReq.getRawMap();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                SingleLangKeyTranslateContext req = new SingleLangKeyTranslateContext(this, entry.getKey(), entry.getValue(), true);
                this.contexts.add(req);
                newContext.add(req);
            }
        }
        this.sendRequest(newContext);
        return flag;
    }

    private void sendRequest(List<ILangKeyTrContext> lt) {
        if (lt.isEmpty()) {
            return;
        }
        LLMClientImpl llmClient = LLMTranslate.createLLMClient();
        for (ILangKeyTrContext lktc : lt) {
            LLMRequest request = lktc.createLLMRequest();
            llmClient.addRequest(request, lktc);
        }
        llmClient.send();
    }

    public synchronized void start() {
        this.finished = false;
        this.sendRequest(this.contexts);
    }

    public synchronized void cancel() {
        this.finished = true;
    }

    public synchronized void reset() {
        LOGGER.warn("Failed request in last round: {}", this.contextError);
        this.finished = true;
        this.contextFinished.clear();
        this.contextError.clear();
        this.contexts.clear();
    }

    public synchronized void submitResultFinished(ILangKeyTrContext context) {
        if (this.finished) {
            return;
        }
        this.contextFinished.add(context);
        for (Map.Entry<String, String> entry : context.getResultMap().entrySet()) {
            I18N_KEYS.put(entry.getKey(), entry.getValue());
        }
        this.checkFinish();
    }

    public synchronized void submitResultError(ILangKeyTrContext context) {
        LOGGER.warn("Failed request : {}", (Object)context);
        if (this.finished) {
            return;
        }
        this.contextFinished.add(context);
        this.contextError.add(context);
        this.checkFinish();
    }

    public int size() {
        return this.contexts.size();
    }

    public int normalFinishedSize() {
        return this.contextFinished.size() - this.contextError.size();
    }

    public int errorSize() {
        return this.contextError.size();
    }
}

