/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.util.ArchiveUtils;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;
import mc.euphoria_patches.euphoria_patcher.util.ShaderpacksWatcher;
import mc.euphoria_patches.euphoria_patcher.util.UpdateChecker;
import mc.euphoria_patches.shadow.org.apache.commons.compress.archivers.ArchiveException;

public class ArchiveOperations {
    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ArchiveOperations] " + message);
    }

    public static Path extract(Path source, Path targetDir, String operationName) {
        try {
            ArchiveOperations.debugLog("Extracting: " + source.getFileName() + " to " + targetDir);
            if (Files.isDirectory(source, new LinkOption[0])) {
                ArchiveOperations.debugLog("Source is already a directory, no extraction needed");
                return source;
            }
            ArchiveUtils.extract(source, targetDir);
            ArchiveOperations.debugLog("Extraction completed successfully");
            return targetDir;
        }
        catch (IOException | ArchiveException e) {
            ArchiveOperations.debugLog("Error " + operationName + ": " + e.getMessage());
            EuphoriaPatcher.log(2, "Error " + operationName + ": " + e.getMessage());
            return null;
        }
    }

    public static Path archive(Path source, Path targetArchive) {
        try {
            ArchiveOperations.debugLog("Archiving: " + source.getFileName() + " to " + targetArchive);
            ArchiveUtils.archive(source, targetArchive);
            ArchiveOperations.debugLog("Archiving completed successfully");
            return targetArchive;
        }
        catch (IOException e) {
            ArchiveOperations.debugLog("Error creating archive: " + e.getMessage());
            EuphoriaPatcher.log(2, "Error creating archive: " + e.getMessage());
            return null;
        }
    }

    public static boolean verifyBaseArchive(Path baseArchived, String originalFileName) {
        try {
            String fileName = baseArchived.getFileName().toString();
            ArchiveOperations.debugLog("Verifying archive: " + fileName);
            if (EuphoriaPatcher.isDevFunc()) {
                long fileSize = Files.size(baseArchived);
                EuphoriaPatcher.log(0, "Archive Name: " + fileName + " Archive size: " + fileSize + " bytes");
                String hash = ArchiveOperations.calculateSHA256(baseArchived);
                EuphoriaPatcher.log(0, "Archive SHA-256: " + hash);
            } else {
                boolean isValidSize;
                long fileSize = Files.size(baseArchived);
                ArchiveOperations.debugLog("Archive size: " + fileSize + " bytes, expected: " + 1440768 + " bytes");
                boolean bl = isValidSize = fileSize == 1440768L;
                if (!isValidSize) {
                    ArchiveOperations.debugLog("Invalid archive size: verification failed");
                    if (EuphoriaPatcher.isNewerShaderVersion(fileName)) {
                        String detectedVersion = EuphoriaPatcher.getVersionStringFromFileName(fileName);
                        EuphoriaPatcher.log(3, 8, "Newer shader version in shaderpacks folder detected: " + originalFileName);
                        EuphoriaPatcher.log(3, 8, "EuphoriaPatches_1.7.1 only works with ComplementaryShaders_r5.6.1");
                        if (UpdateChecker.isUpdateAvailable() && EuphoriaPatcher.doUpdateChecking) {
                            EuphoriaPatcher.log(3, 8, "Please update EuphoriaPatches to the latest version to support this shader version: " + detectedVersion);
                            EuphoriaPatcher.log(3, 8, "Download it from Modrinth: https://euphoriapatches.com/download");
                        } else {
                            EuphoriaPatcher.log(3, 8, "This version of EuphoriaPatches requires ComplementaryShaders_r5.6.1");
                            EuphoriaPatcher.log(3, 8, "Please download it from https://www.complementary.dev/ or check for an EuphoriaPatches update manually at https://euphoriapatches.com/download");
                        }
                    } else if (fileName.matches("Complementary.*_r5.6.1.*")) {
                        EuphoriaPatcher.log(3, 8, "The shader " + originalFileName + " that was found in your shaderpacks folder can't be used as a base for " + "EuphoriaPatches");
                        EuphoriaPatcher.log(3, 8, "The shader file appears to be incomplete or has been modified.");
                        EuphoriaPatcher.log(3, 8, "Please re-download ComplementaryShaders_r5.6.1 from https://www.complementary.dev/ and place it in the shaderpacks folder.");
                    } else {
                        EuphoriaPatcher.log(3, 8, "The shader " + originalFileName + " that was found in your shaderpacks folder can't be used as a base for " + "EuphoriaPatches");
                        EuphoriaPatcher.log(3, 8, "Please download ComplementaryShaders_r5.6.1 from https://www.complementary.dev/ and place it in the shaderpacks folder.");
                    }
                    EuphoriaPatcher.log(0, "Watching for the correct shader to be added...");
                    EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
                    if (instance != null) {
                        instance.startWatcherAfterByteSizeFailure();
                        ShaderpacksWatcher watcher = instance.getShaderpacksWatcher();
                        if (watcher != null) {
                            watcher.trackInvalidByteSizeFile(fileName);
                        }
                    }
                    return false;
                }
                if (ArchiveOperations.isTestOrDevVersion(fileName)) {
                    ArchiveOperations.debugLog("Test/fix version detected: " + originalFileName);
                    EuphoriaPatcher.log(3, 8, "Test or development version detected: " + originalFileName);
                    EuphoriaPatcher.log(3, 8, "EuphoriaPatches requires the official release of ComplementaryShaders_r5.6.1");
                    EuphoriaPatcher.log(3, 8, "Please download it from https://www.complementary.dev/");
                    EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
                    if (instance != null) {
                        instance.startWatcherAfterByteSizeFailure();
                        ShaderpacksWatcher watcher = instance.getShaderpacksWatcher();
                        if (watcher != null) {
                            watcher.trackInvalidByteSizeFile(fileName);
                        }
                    }
                    return false;
                }
                if (ArchiveOperations.detectIncorrectHash(baseArchived)) {
                    ArchiveOperations.debugLog("Archive hash verification failed - file has been modified");
                    EuphoriaPatcher.log(3, 8, "The shader file that was found in your shaderpacks folder appears to have been modified.");
                    EuphoriaPatcher.log(3, 8, "This can happen if the shader was manually edited or if it's from an unofficial source.");
                    EuphoriaPatcher.log(3, 8, "Name of the potentially modified shader: " + originalFileName);
                    EuphoriaPatcher.log(3, 8, "Please download the original ComplementaryShaders_r5.6.1 from https://www.complementary.dev/ and place it in the shaderpacks folder.");
                    EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
                    if (instance != null) {
                        instance.startWatcherAfterByteSizeFailure();
                        ShaderpacksWatcher watcher = instance.getShaderpacksWatcher();
                        if (watcher != null) {
                            watcher.trackInvalidByteSizeFile(fileName);
                        }
                    }
                    return false;
                }
                ArchiveOperations.debugLog("Archive size and hash verification passed");
            }
        }
        catch (IOException e) {
            ArchiveOperations.debugLog("Error during archive verification: " + e.getMessage());
            EuphoriaPatcher.log(3, "Something went wrong during the file verification: " + e.getMessage());
            return false;
        }
        return true;
    }

    private static String calculateSHA256(Path filePath) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] fileBytes = Files.readAllBytes(filePath);
            byte[] hashBytes = digest.digest(fileBytes);
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            ArchiveOperations.debugLog("Error calculating SHA-256: " + e.getMessage());
            return null;
        }
    }

    private static boolean detectIncorrectHash(Path archivePath) {
        String expectedHash = "85bedae6a1fc8cac5f24cbcca18950f850dc7867c30e7db2bb0e15cb63729fe5";
        String actualHash = ArchiveOperations.calculateSHA256(archivePath);
        if (actualHash == null) {
            return true;
        }
        boolean hashMatches = expectedHash.equals(actualHash);
        ArchiveOperations.debugLog("Hash verification - Expected: " + expectedHash);
        ArchiveOperations.debugLog("Hash verification - Actual:   " + actualHash);
        ArchiveOperations.debugLog("Hash verification - Match: " + hashMatches);
        return !hashMatches;
    }

    private static boolean isTestOrDevVersion(String fileName) {
        String fileNameLower = fileName.toLowerCase();
        return fileNameLower.contains("test") || fileNameLower.contains("fix") || fileNameLower.contains("dev") || fileNameLower.contains("pre");
    }

    public static boolean verifyBaseArchiveQuiet(Path baseArchived) {
        try {
            String fileName = baseArchived.getFileName().toString();
            ArchiveOperations.debugLog("Quietly verifying archive: " + fileName);
            if (EuphoriaPatcher.isDevFunc()) {
                ArchiveOperations.debugLog("Dev mode: bypassing verification (returning true)");
            } else {
                long fileSize = Files.size(baseArchived);
                boolean isValidSize = fileSize == 1440768L;
                ArchiveOperations.debugLog("Archive size: " + fileSize + " bytes, expected: " + 1440768 + " bytes, valid: " + isValidSize);
                if (!isValidSize) {
                    return false;
                }
                if (ArchiveOperations.isTestOrDevVersion(fileName)) {
                    ArchiveOperations.debugLog("Test/fix version detected in quiet check: " + fileName);
                    return false;
                }
            }
            return true;
        }
        catch (IOException e) {
            ArchiveOperations.debugLog("Error during quiet archive verification: " + e.getMessage());
            return false;
        }
    }
}

