/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.util.ErrorShaderGenerator;
import mc.euphoria_patches.euphoria_patcher.util.SodiumConsole;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EuphoriaLogger {
    public static Logger logger = LogManager.getLogger((String)"euphoriaPatches");
    private static final String ERROR_LOG_FILE_NAME = "_0EUPHORIA_PATCHES_ERROR_LOGS.txt";
    private final Path errorLogFilePath = EuphoriaPatcher.shaderpacks.resolve("_0EUPHORIA_PATCHES_ERROR_LOGS.txt");
    private boolean isSodiumInstalled = false;
    private boolean shouldCreateErrorLog = true;
    private List<String> errorMessages = new ArrayList<String>();
    private int lastProcessedErrorCount = 0;
    private boolean hasErrors = false;
    private Timer errorShaderTimer = null;
    private boolean errorShaderScheduled = false;
    private static final int ERROR_COLLECTION_DELAY_MS = 5000;
    private final Object errorCollectionLock = new Object();

    public void checkAndSetupSodiumLogging() {
        this.isSodiumInstalled = SodiumConsole.isSodiumAvailable();
        if (this.isSodiumInstalled) {
            EuphoriaLogger.debugLog("Sodium found, using Sodium logging!");
        }
    }

    public void log(int messageLevel, int messageFadeTimer, String message) {
        String loggingMessage = "EuphoriaPatcher: " + message;
        if (messageLevel == -1) {
            loggingMessage = "\n\n" + loggingMessage + "\n";
        }
        if (this.isSodiumInstalled && messageFadeTimer > 0) {
            SodiumConsole.logMessage(messageLevel, messageFadeTimer, loggingMessage);
        }
        switch (messageLevel) {
            case -1: 
            case 0: 
            case 1: {
                logger.info(loggingMessage);
                break;
            }
            case 2: {
                logger.warn(loggingMessage);
                if (messageFadeTimer <= 0) break;
                this.appendToErrorLogFile("[WARNING] " + loggingMessage);
                this.collectErrorMessage(loggingMessage);
                break;
            }
            case 3: {
                logger.error(loggingMessage);
                if (messageFadeTimer <= 0) break;
                this.appendToErrorLogFile("[ERROR] " + loggingMessage);
                this.collectErrorMessage(loggingMessage);
                break;
            }
            default: {
                System.out.println(loggingMessage);
            }
        }
        if (message.contains("Have fun developing Euphoria Patches!") || message.contains("Thank you for using Euphoria Patches - SpacEagle17")) {
            this.deleteErrorLogFile();
        }
    }

    public void log(int messageLevel, String message) {
        int[] fadeTimers = new int[]{0, 4, 8, 16};
        int messageFadeTimer = messageLevel >= 0 && messageLevel < fadeTimers.length ? fadeTimers[messageLevel] : 0;
        this.log(messageLevel, messageFadeTimer, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectErrorMessage(String message) {
        Object object = this.errorCollectionLock;
        synchronized (object) {
            this.errorMessages.add(message);
            this.hasErrors = true;
            EuphoriaLogger.debugLog("Collected error #" + this.errorMessages.size() + ": " + message);
            EuphoriaLogger.debugLog("lastProcessedErrorCount = " + this.lastProcessedErrorCount);
            if (this.errorMessages.size() == 1) {
                EuphoriaLogger.debugLog("First error, scheduling initial generation");
                this.scheduleErrorShaderGeneration();
            } else if (this.errorMessages.size() >= 10 && this.errorMessages.size() - this.lastProcessedErrorCount >= 5) {
                EuphoriaLogger.debugLog("Many errors collected, generating immediately");
                this.cancelScheduledErrorShader();
                ErrorShaderGenerator.generateErrorShader(this.errorMessages);
                this.lastProcessedErrorCount = this.errorMessages.size();
                this.scheduleErrorShaderGeneration();
            } else if (!this.errorShaderScheduled && this.errorMessages.size() > this.lastProcessedErrorCount) {
                EuphoriaLogger.debugLog("New errors detected and no timer active, scheduling update");
                this.scheduleErrorShaderGeneration();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleErrorShaderGeneration() {
        Object object = this.errorCollectionLock;
        synchronized (object) {
            if (this.errorShaderScheduled) {
                EuphoriaLogger.debugLog("Timer already scheduled, skipping");
                return;
            }
            this.cancelScheduledErrorShader();
            this.errorShaderTimer = new Timer("ErrorShaderTimer", true);
            this.errorShaderTimer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = EuphoriaLogger.this.errorCollectionLock;
                    synchronized (object) {
                        EuphoriaLogger.debugLog("Timer firing: messages=" + EuphoriaLogger.this.errorMessages.size() + ", lastProcessed=" + EuphoriaLogger.this.lastProcessedErrorCount);
                        if (EuphoriaLogger.this.hasErrors && EuphoriaLogger.this.errorMessages.size() > EuphoriaLogger.this.lastProcessedErrorCount) {
                            EuphoriaLogger.debugLog("Generating shader with " + EuphoriaLogger.this.errorMessages.size() + " messages");
                            ErrorShaderGenerator.generateErrorShader(EuphoriaLogger.this.errorMessages);
                            EuphoriaLogger.this.lastProcessedErrorCount = EuphoriaLogger.this.errorMessages.size();
                            EuphoriaLogger.this.errorShaderScheduled = false;
                            if (EuphoriaLogger.this.errorMessages.size() % 5 == 0) {
                                EuphoriaLogger.debugLog("Rescheduling timer for potential future errors");
                                EuphoriaLogger.this.scheduleErrorShaderGeneration();
                            }
                        } else {
                            EuphoriaLogger.debugLog("No new errors detected, rescheduling anyway");
                            EuphoriaLogger.this.errorShaderScheduled = false;
                            EuphoriaLogger.this.scheduleErrorShaderGeneration();
                        }
                    }
                }
            }, 5000L);
            this.errorShaderScheduled = true;
            EuphoriaLogger.debugLog("Scheduled error shader generation in 5 seconds");
        }
    }

    private void cancelScheduledErrorShader() {
        if (this.errorShaderTimer != null) {
            this.errorShaderTimer.cancel();
            this.errorShaderTimer = null;
            this.errorShaderScheduled = false;
        }
    }

    public void checkErrorLogFileAndAddSeparator() {
        if (!this.shouldCreateErrorLog) {
            return;
        }
        try {
            if (Files.exists(this.errorLogFilePath, new LinkOption[0])) {
                String separator = "\n--------------------------------------\nRestart happened\n--------------------------------------\n";
                Files.write(this.errorLogFilePath, separator.getBytes(), StandardOpenOption.APPEND);
                this.log(0, "Added restart separator to error log file");
            }
        }
        catch (IOException e) {
            this.log(0, "Failed to add restart separator to error log file: " + e.getMessage());
        }
    }

    private void appendToErrorLogFile(String message) {
        if (!this.shouldCreateErrorLog) {
            return;
        }
        try {
            if (!Files.exists(this.errorLogFilePath.getParent(), new LinkOption[0])) {
                Files.createDirectories(this.errorLogFilePath.getParent(), new FileAttribute[0]);
            }
            String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            String logEntry = timestamp + " " + message + System.lineSeparator();
            StandardOpenOption option = Files.exists(this.errorLogFilePath, new LinkOption[0]) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE;
            Files.write(this.errorLogFilePath, logEntry.getBytes(), option);
        }
        catch (IOException e) {
            this.log(0, "Failed to write to error log file: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteErrorLogFile() {
        Object object = this.errorCollectionLock;
        synchronized (object) {
            try {
                Path errorShaderPath;
                if (Files.exists(this.errorLogFilePath, new LinkOption[0])) {
                    Files.delete(this.errorLogFilePath);
                    this.log(0, "Deleted error log file as shader was successfully installed");
                    this.shouldCreateErrorLog = false;
                }
                if (Files.exists(errorShaderPath = EuphoriaPatcher.shaderpacks.resolve("_0EuphoriaPatches_ErrorShader"), new LinkOption[0])) {
                    FileUtils.deleteDirectory((File)errorShaderPath.toFile());
                    this.log(0, "Deleted error shader as installation was successful");
                }
                this.errorMessages.clear();
                this.hasErrors = false;
                this.lastProcessedErrorCount = 0;
                this.cancelScheduledErrorShader();
            }
            catch (IOException e) {
                this.log(0, "Failed to delete error log file: " + e.getMessage());
            }
        }
    }

    public static void debugLog(String message) {
        if (EuphoriaPatcher.doDebugLogging) {
            EuphoriaPatcher.log(0, message);
        }
    }
}

