/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import mc.euphoria_patches.euphoria_patcher.features.ModFolderVersionChecker;
import mc.euphoria_patches.euphoria_patcher.features.ModifyOutdatedPatches;
import mc.euphoria_patches.euphoria_patcher.features.ModifyPatchedShaderpacks;
import mc.euphoria_patches.euphoria_patcher.features.UpdateShaderConfig;
import mc.euphoria_patches.euphoria_patcher.features.UpdateShaderLoaderConfig;
import mc.euphoria_patches.euphoria_patcher.util.ArchiveOperations;
import mc.euphoria_patches.euphoria_patcher.util.ArchiveUtils;
import mc.euphoria_patches.euphoria_patcher.util.Config;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;
import mc.euphoria_patches.euphoria_patcher.util.JsonUtilReader;
import mc.euphoria_patches.euphoria_patcher.util.ModLoaderSpecifics;
import mc.euphoria_patches.euphoria_patcher.util.ShaderLoader;
import mc.euphoria_patches.euphoria_patcher.util.ShaderpacksWatcher;
import mc.euphoria_patches.euphoria_patcher.util.UpdateChecker;
import mc.euphoria_patches.euphoria_patcher.util.UsefulFunctions;
import mc.euphoria_patches.shadow.io.sigpipe.jbsdiff.InvalidHeaderException;
import mc.euphoria_patches.shadow.io.sigpipe.jbsdiff.ui.FileUI;
import mc.euphoria_patches.shadow.org.apache.commons.compress.archivers.ArchiveException;
import mc.euphoria_patches.shadow.org.apache.commons.compress.compressors.CompressorException;
import mc.euphoria_patches.shadow.org.apache.commons.io.FileUtils;

public class EuphoriaPatcher {
    private static final boolean IS_DEV = false;
    private static final boolean isDevModLoader = ModLoaderSpecifics.isDevMode;
    public static final String BRAND_NAME = "Complementary";
    public static final String PATCH_NAME = "EuphoriaPatches";
    public static final String VERSION = "_r5.6.1";
    public static final String PATCH_VERSION = "_1.7.5";
    public static final String BASE_TAR_SHA256 = "85bedae6a1fc8cac5f24cbcca18950f850dc7867c30e7db2bb0e15cb63729fe5";
    public static final int BASE_TAR_SIZE = 1440768;
    public static final String DOWNLOAD_URL = "https://www.complementary.dev/";
    public static final String COMMON_LOCATION = "shaders/lib/common.glsl";
    public static final String LANG_LOCATION = "shaders/lang";
    public static final String SHADERS_PROPERTIES_LOCATION = "shaders/shaders.properties";
    public static final String SHADER_MYFILE_LOCATION = "shaders/lib/misc/myFile.glsl";
    public static Path shaderpacks = ModLoaderSpecifics.shaderpacks;
    public static Path configDirectory = ModLoaderSpecifics.configDirectory;
    public static Path mainIntellijDir = shaderpacks.getParent().getParent();
    public static Path modDirectory = shaderpacks.getParent().resolve("mods");
    public static boolean doPopUpLogging = true;
    public static boolean doUpdateChecking = true;
    public static boolean doRenameOldShaderFiles = true;
    public static boolean doDeleteOldShaderFiles = false;
    public static boolean doDisplayShaderInGameMessage = true;
    public static boolean doDebugLogging = false;
    public static String alternativeShaderNames = "";
    private static boolean ALREADY_LAUNCHED = false;
    private static boolean IS_BASE_MESSAGE_SHOWN = false;
    private static EuphoriaPatcher instance;
    private ShaderpacksWatcher shaderpacksWatcher;
    private static EuphoriaLogger loggerInstance;
    private static int filesScannedCounter;
    private static int totalFilesToScan;

    public EuphoriaPatcher() {
        if (ALREADY_LAUNCHED) {
            return;
        }
        ALREADY_LAUNCHED = true;
        instance = this;
        System.out.println("\nEuphoria Patcher:");
        loggerInstance = new EuphoriaLogger();
        loggerInstance.checkErrorLogFileAndAddSeparator();
        this.configStuff();
        modDirectory = EuphoriaPatcher.determineModsDirectory();
        if (ModFolderVersionChecker.existsNewerModInFolder()) {
            return;
        }
        if (doPopUpLogging) {
            loggerInstance.checkAndSetupSodiumLogging();
        }
        UpdateChecker.checkForUpdates();
        ShaderLoader.getShaderLoader();
        EuphoriaPatcher.log(0, JsonUtilReader.getRandomMessage("startupMessages"));
        UpdateShaderConfig.markEuphoriaPatchesSettingsFiles();
        ShaderInfo shaderInfo = this.detectInstalledShaders();
        if (!shaderInfo.isAlreadyInstalled) {
            if (shaderInfo.baseFile == null) {
                this.installBaseMessage();
                if (!EuphoriaPatcher.isDevFunc()) {
                    return;
                }
            }
        } else {
            this.thankYouMessage(shaderInfo.baseFile, shaderInfo.styleUnbound, shaderInfo.styleReimagined, shaderInfo.installedDir, true);
            return;
        }
        Path temp = this.createTempDirectory();
        if (temp == null || shaderInfo.baseFile == null && !EuphoriaPatcher.isDevFunc()) {
            return;
        }
        this.completeShaderPatching(shaderInfo, temp);
    }

    public static EuphoriaPatcher getInstance() {
        return instance;
    }

    private boolean completeShaderPatching(ShaderInfo shaderInfo, Path temp) {
        if (!this.processAndPatchShaders(shaderInfo, temp)) {
            return false;
        }
        UpdateShaderConfig.updateShaderTxtConfigFile(shaderInfo.styleUnbound, shaderInfo.styleReimagined);
        UpdateShaderLoaderConfig.updateShaderLoaderConfig(shaderInfo.styleUnbound, shaderInfo.styleReimagined);
        if (doDeleteOldShaderFiles) {
            ModifyOutdatedPatches.delete();
        }
        if (doRenameOldShaderFiles) {
            ModifyOutdatedPatches.rename();
        }
        this.thankYouMessage(shaderInfo.baseFile, shaderInfo.styleUnbound, shaderInfo.styleReimagined, shaderInfo.installedDir, shaderInfo.isAlreadyInstalled);
        return true;
    }

    public void configStuff() {
        doPopUpLogging = Boolean.parseBoolean(Config.readWriteConfig("doPopUpLogging", "true", "Option for the sodium message popup logging.\nDefault = true"));
        doUpdateChecking = Boolean.parseBoolean(Config.readWriteConfig("doUpdateChecking", "true", "Option that enables or disables the update checker, which verifies if a new version of the mod is available.\nUses the Modrinth API to fetch update information.\nDefault = true"));
        doRenameOldShaderFiles = Boolean.parseBoolean(Config.readWriteConfig("doRenameOldShaderFiles", "true", "Option that automatically renames outdated Euphoria Patches folders and config files to a new name.\nThis makes it easier for users to identify which ones are outdated.\nDefault = true"));
        doDeleteOldShaderFiles = Boolean.parseBoolean(Config.readWriteConfig("doDeleteOldShaderFiles", "false", "Option that automatically deleted outdated Euphoria Patches folders and config files.\nDefault = false"));
        doDisplayShaderInGameMessage = Boolean.parseBoolean(Config.readWriteConfig("doDisplayShaderInGameMessage", "true", "Option that enables or disables the in-game shader messages, for example an update message made by the shader itself. Only works on Iris\nDefault = true"));
        doDebugLogging = Boolean.parseBoolean(Config.readWriteConfig("doDebugLogging", "false", "Option that enables or disables debug logging.\nDefault = false"));
        alternativeShaderNames = Config.readWriteConfig("alternativeShaderNames", "", "Here one can set alternative Shader Names which will also be generated alongside the normal one.\nThis is useful if you want multiple different settings you can quickly switch between\nDefault = Empty String, which means no alternative names will be generated.\nIn case of multiple names, separate them with a comma\nYou can also use {baseVersion} or {patchVersion} in names to insert the base shader or Euphoria Patches version.\nExample: Euphoria Saturated, Comp_{baseVersion} + EP_{patchVersion} Dark Settings, EP High Performance, etc...");
        Config.startConfigWatcher();
    }

    public static void log(int messageLevel, int messageFadeTimer, String message) {
        if (loggerInstance == null) {
            System.out.println("EuphoriaPatcher (early log): " + message);
            return;
        }
        loggerInstance.log(messageLevel, messageFadeTimer, message);
    }

    public static void log(int messageLevel, String message) {
        if (loggerInstance == null) {
            System.out.println("EuphoriaPatcher (early log): " + message);
            return;
        }
        loggerInstance.log(messageLevel, message);
    }

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[EuphoriaPatcher] " + message);
    }

    public static boolean isDevFunc() {
        return false;
    }

    private static Path determineModsDirectory() {
        Path defaultModsDir = shaderpacks.getParent().resolve("mods");
        Path installInfoPath = configDirectory.resolve("installedByCompInstaller.txt");
        if (!Files.exists(installInfoPath, new LinkOption[0])) {
            EuphoriaPatcher.debugLog("Installation info file not found, using default mods directory");
            return defaultModsDir;
        }
        try {
            String line = Files.readAllLines(installInfoPath).get(0);
            String prefix = "in the ";
            String suffix = " folder";
            if (line.contains(prefix) && line.contains(suffix)) {
                int startIndex = line.indexOf(prefix) + prefix.length();
                int endIndex = line.indexOf(suffix);
                if (startIndex >= prefix.length() && endIndex > startIndex) {
                    String customPath = line.substring(startIndex, endIndex);
                    EuphoriaPatcher.debugLog("Found custom path in installation info file: " + customPath);
                    if (customPath.equals("mods")) {
                        EuphoriaPatcher.debugLog("Custom path is the standard mods folder");
                        return defaultModsDir;
                    }
                    Path customModsDir = shaderpacks.getParent().resolve(customPath);
                    if (Files.exists(customModsDir, new LinkOption[0]) && Files.isDirectory(customModsDir, new LinkOption[0])) {
                        EuphoriaPatcher.debugLog("Using custom mods directory: " + customModsDir);
                        return customModsDir;
                    }
                    EuphoriaPatcher.debugLog("Custom mods directory doesn't exist: " + customModsDir + ", falling back to default");
                }
            }
        }
        catch (IOException | IndexOutOfBoundsException e) {
            EuphoriaPatcher.debugLog("Error reading installation info file: " + e.getMessage());
        }
        return defaultModsDir;
    }

    private ShaderInfo detectInstalledShaders() {
        ShaderInfo info = new ShaderInfo();
        try {
            this.checkForExistingPatchedShaders(info);
            if (info.isAlreadyInstalled) {
                return info;
            }
            ArrayList potentialShaderPaths = new ArrayList();
            try (Object stream = Files.newDirectoryStream(shaderpacks, path -> this.isBrandNameShader((Path)path, true));){
                stream.forEach(potentialShaderPaths::add);
            }
            stream = Files.newDirectoryStream(shaderpacks, path -> this.isBrandNameShader((Path)path, false));
            try {
                stream.forEach(potentialShaderPaths::add);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            for (Path path2 : potentialShaderPaths) {
                this.processShaderPath(path2, info);
                if (!info.styleReimagined || !info.styleUnbound) continue;
                break;
            }
            if (info.baseFile == null) {
                EuphoriaPatcher.log(2, 0, "No shaders with expected name pattern found, checking via byte size...");
                EuphoriaPatcher.log(2, 0, "If you have a lot of shaders installed, this may take a while. Please be patient.");
                EuphoriaPatcher.log(2, 0, "Please wait... \n");
                Path shaderByByteSize = this.findShaderByByteSize();
                if (shaderByByteSize != null) {
                    EuphoriaPatcher.log(0, "Found valid shader by byte size: " + shaderByByteSize.getFileName());
                    String name = shaderByByteSize.getFileName().toString();
                    info.styleReimagined = name.contains("Reimagined") || !name.contains("Unbound");
                    info.styleUnbound = name.contains("Unbound");
                    info.baseFile = shaderByByteSize;
                    this.checkIfAlreadyInstalled(shaderByByteSize, info);
                }
            }
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, "Error reading shaderpacks directory: " + e.getMessage());
        }
        return info;
    }

    private void checkForExistingPatchedShaders(ShaderInfo info) {
        try {
            DirectoryStream.Filter<Path> patchedFilter = path -> path.getFileName().toString().contains(BRAND_NAME) && path.getFileName().toString().contains(" + EuphoriaPatches_1.7.5") && (Files.isDirectory(path, new LinkOption[0]) || Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".zip"));
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(shaderpacks, patchedFilter);){
                for (Path path2 : stream) {
                    this.checkIfAlreadyInstalled(path2, info);
                    if (!info.isAlreadyInstalled) continue;
                    return;
                }
            }
            EuphoriaPatcher.debugLog("No existing patched shaders found by standard naming pattern, checking for Euphoria Patches files...");
            stream = Files.newDirectoryStream(shaderpacks, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
            try {
                if (EuphoriaPatcher.isDevFunc() || info.isAlreadyInstalled) {
                    return;
                }
                for (Path directory : stream) {
                    String firstLine;
                    Path myFilePath = directory.resolve(SHADER_MYFILE_LOCATION);
                    EuphoriaPatcher.debugLog("Checking directory: " + directory.getFileName() + " for myFile.glsl");
                    if (!Files.exists(myFilePath, new LinkOption[0])) continue;
                    EuphoriaPatcher.debugLog("Found myFile.glsl in directory: " + directory.getFileName());
                    try (BufferedReader reader = Files.newBufferedReader(myFilePath);){
                        firstLine = reader.readLine();
                    }
                    if (firstLine == null || !firstLine.startsWith("// Euphoria Patches")) continue;
                    String fileVersion = firstLine.replace("// Euphoria Patches ", "").trim();
                    String expectedVersion = PATCH_VERSION.replace("_", "");
                    EuphoriaPatcher.debugLog("Found potential correct Euphoria Patches version in: " + directory.getFileName());
                    EuphoriaPatcher.debugLog("File version: " + fileVersion + ", Expected: " + expectedVersion);
                    if (!fileVersion.equals(expectedVersion)) continue;
                    String dirName = directory.getFileName().toString();
                    if (dirName.equals("Euphoria-Patches") || dirName.matches("dev\\d+") || dirName.contains("earlyDev")) {
                        EuphoriaPatcher.debugLog("Skipping dev Euphoria-Patches versions");
                        continue;
                    }
                    EuphoriaPatcher.debugLog("Version match found - this is a correct Euphoria Patches installation");
                    info.isAlreadyInstalled = true;
                    info.installedDir = directory;
                    if (dirName.contains("Reimagined")) {
                        info.styleReimagined = true;
                    } else if (dirName.contains("Unbound")) {
                        info.styleUnbound = true;
                    } else {
                        String detectedStyle = this.detectStyleFromCommonFile(directory);
                        info.styleReimagined = "Reimagined".equals(detectedStyle);
                        info.styleUnbound = "Unbound".equals(detectedStyle);
                    }
                    EuphoriaPatcher.log(0, "EuphoriaPatches_1.7.5 is already installed as the renamed folder: " + directory.getFileName());
                    return;
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, "Error checking for existing patched shaders: " + e.getMessage());
        }
    }

    private boolean isBrandNameShader(Path path, boolean isFile) {
        boolean matchesPattern;
        String name = path.getFileName().toString();
        boolean hasBrandName = name.startsWith(BRAND_NAME);
        boolean notPatched = !name.contains(PATCH_NAME);
        boolean hasExactVersion = name.contains(VERSION);
        boolean notModifiedByOthers = !name.contains(" + ");
        boolean isNotDevVersion = !name.contains("_dev");
        boolean isNotPreVersion = !name.contains("_pre");
        boolean bl = matchesPattern = hasBrandName && notPatched && hasExactVersion && notModifiedByOthers && isNotDevVersion && isNotPreVersion;
        if (isFile) {
            return matchesPattern && name.endsWith(".zip");
        }
        return matchesPattern && Files.isDirectory(path, new LinkOption[0]);
    }

    private void resetFilesScannedCounter() {
        filesScannedCounter = 0;
        totalFilesToScan = 0;
        EuphoriaPatcher.debugLog("Reset files scanned counter");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path findShaderByByteSize() {
        try {
            this.resetFilesScannedCounter();
            int zipFileCount = 0;
            int dirCount = 0;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(shaderpacks, path -> path.toString().endsWith(".zip") && Files.isRegularFile(path, new LinkOption[0]));){
                for (Path ignored : stream) {
                    ++zipFileCount;
                }
            }
            stream = Files.newDirectoryStream(shaderpacks, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
            try {
                for (Path ignored : stream) {
                    ++dirCount;
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            totalFilesToScan = zipFileCount + dirCount;
            EuphoriaPatcher.debugLog("Total files to scan: " + totalFilesToScan + " (" + zipFileCount + " ZIP files, " + dirCount + " directories)");
            stream = Files.newDirectoryStream(shaderpacks, path -> path.toString().endsWith(".zip") && Files.isRegularFile(path, new LinkOption[0]));
            try {
                for (Path zipFile : stream) {
                    if (!this.isValidShaderByByteSize(zipFile)) continue;
                    Path path2 = this.renameToCorrectShaderName(zipFile);
                    return path2;
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            stream = Files.newDirectoryStream(shaderpacks, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
            try {
                Path dir;
                Iterator<Path> iterator = stream.iterator();
                do {
                    if (!iterator.hasNext()) return null;
                } while (!this.isValidShaderByByteSize(dir = iterator.next()));
                Path path3 = this.renameToCorrectShaderName(dir);
                return path3;
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, "Error searching for shaders by byte size: " + e.getMessage());
        }
        return null;
    }

    public boolean isValidShaderByByteSize(Path path) {
        try {
            if (++filesScannedCounter % 5 == 0) {
                EuphoriaPatcher.log(2, 0, "Please wait... Scanned " + filesScannedCounter + " of " + totalFilesToScan + " files so far");
            }
            EuphoriaPatcher.debugLog("Checking if shader is valid by byte size (" + filesScannedCounter + "/" + totalFilesToScan + "): " + path.getFileName());
            Path tempDir = this.createTempDirectory();
            if (tempDir == null) {
                EuphoriaPatcher.debugLog("Failed to create temp directory for byte size check");
                return false;
            }
            EuphoriaPatcher.debugLog("Created temp directory: " + tempDir);
            String baseName = path.getFileName().toString().replace(".zip", "");
            EuphoriaPatcher.debugLog("Base name for extraction: " + baseName);
            Path baseExtracted = this.extractBase(path, tempDir, baseName);
            if (baseExtracted == null) {
                EuphoriaPatcher.debugLog("Failed to extract base for byte size check");
                return false;
            }
            EuphoriaPatcher.debugLog("Successfully extracted to: " + baseExtracted);
            Path baseArchived = this.archiveBase(baseExtracted, tempDir, baseName);
            if (baseArchived == null) {
                EuphoriaPatcher.debugLog("Failed to archive base for byte size check");
                return false;
            }
            EuphoriaPatcher.debugLog("Successfully archived to: " + baseArchived);
            boolean result = ArchiveOperations.verifyBaseArchiveQuiet(baseArchived);
            EuphoriaPatcher.debugLog("Byte size verification result for " + path.getFileName() + ": " + result);
            try {
                EuphoriaPatcher.debugLog("Cleaning up temp directory: " + tempDir);
                FileUtils.deleteDirectory(tempDir.toFile());
            }
            catch (IOException e) {
                EuphoriaPatcher.debugLog("Failed to clean up temp directory: " + e.getMessage());
            }
            return result;
        }
        catch (Exception e) {
            EuphoriaPatcher.debugLog("Exception during byte size check: " + e.getMessage());
            return false;
        }
    }

    public Path renameToCorrectShaderName(Path path) {
        try {
            String style;
            String fileName = path.getFileName().toString();
            if (fileName.contains("Unbound")) {
                style = "Unbound";
            } else if (fileName.contains("Reimagined")) {
                style = "Reimagined";
            } else {
                style = this.detectStyleFromCommonFile(path);
                EuphoriaPatcher.debugLog("Detected " + style + " style from common.glsl file");
            }
            String correctName = BRAND_NAME + style + VERSION;
            if (fileName.endsWith(".zip")) {
                correctName = correctName + ".zip";
            }
            if (fileName.equals(correctName)) {
                return path;
            }
            Path targetPath = path.resolveSibling(correctName);
            if (Files.exists(targetPath, new LinkOption[0])) {
                EuphoriaPatcher.debugLog("A file with the correct name already exists: " + targetPath.getFileName());
                return path;
            }
            Path renamedPath = Files.move(path, targetPath, new CopyOption[0]);
            EuphoriaPatcher.log(0, "Renamed shader from \"" + fileName + "\" to \"" + correctName + "\"");
            return renamedPath;
        }
        catch (IOException e) {
            EuphoriaPatcher.log(2, "Failed to rename shader: " + e.getMessage());
            return path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String detectStyleFromCommonFile(Path shaderPath) {
        Path tempDir = null;
        try {
            Path commonFile;
            Path extractedPath;
            tempDir = this.createTempDirectory();
            if (tempDir == null) {
                String string = "Reimagined";
                return string;
            }
            String baseName = shaderPath.getFileName().toString().replace(".zip", "");
            if (shaderPath.toString().endsWith(".zip")) {
                extractedPath = this.extractBase(shaderPath, tempDir, baseName);
                if (extractedPath == null) {
                    String string = "Reimagined";
                    return string;
                }
            } else {
                extractedPath = shaderPath;
            }
            if (!Files.exists(commonFile = extractedPath.resolve(COMMON_LOCATION), new LinkOption[0])) return "Reimagined";
            String content = FileUtils.readFileToString(commonFile.toFile(), "UTF-8");
            if (content.contains("SHADER_STYLE 4")) {
                EuphoriaPatcher.debugLog("Detected Unbound style from common.glsl");
                String string = "Unbound";
                return string;
            }
            if (!content.contains("SHADER_STYLE 1")) {
                if (!content.contains("SHADER_STYLE")) return "Reimagined";
            }
            EuphoriaPatcher.debugLog("Detected Reimagined style from common.glsl");
            String string = "Reimagined";
            return string;
        }
        catch (IOException e) {
            EuphoriaPatcher.log(2, "Error reading common.glsl: " + e.getMessage());
            return "Reimagined";
        }
        finally {
            if (tempDir != null) {
                try {
                    FileUtils.deleteDirectory(tempDir.toFile());
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void processShaderPath(Path path, ShaderInfo info) {
        String name = path.getFileName().toString();
        boolean styleFromName = false;
        if (name.contains("Reimagined")) {
            info.styleReimagined = true;
            styleFromName = true;
            if (info.baseFile == null) {
                info.baseFile = path;
            }
        } else if (name.contains("Unbound")) {
            info.styleUnbound = true;
            styleFromName = true;
            if (info.baseFile == null) {
                info.baseFile = path;
            }
        }
        if (!styleFromName) {
            String detectedStyle = this.detectStyleFromCommonFile(path);
            if ("Reimagined".equals(detectedStyle)) {
                info.styleReimagined = true;
                if (info.baseFile == null) {
                    info.baseFile = path;
                }
            } else if ("Unbound".equals(detectedStyle)) {
                info.styleUnbound = true;
                if (info.baseFile == null) {
                    info.baseFile = path;
                }
            }
            EuphoriaPatcher.log(0, "Shader style not in filename, detected " + detectedStyle + " from common.glsl");
        }
        this.checkIfAlreadyInstalled(path, info);
    }

    private void checkIfAlreadyInstalled(Path path, ShaderInfo info) {
        Path potentialInstallPath;
        boolean isDirectPatchedDir = path.getFileName().toString().contains(" + EuphoriaPatches_1.7.5");
        if (isDirectPatchedDir) {
            potentialInstallPath = path;
            String name = path.getFileName().toString();
            String baseName = name.substring(0, name.indexOf(" + EuphoriaPatches_1.7.5"));
            Path potentialBaseZip = shaderpacks.resolve(baseName + ".zip");
            info.styleReimagined = name.contains("Reimagined");
            info.styleUnbound = name.contains("Unbound");
            if (Files.exists(potentialBaseZip, new LinkOption[0])) {
                info.baseFile = potentialBaseZip;
            }
        } else {
            potentialInstallPath = EuphoriaPatcher.getPatchedShaderPath(path);
            if (info.baseFile == null) {
                info.baseFile = path;
            }
        }
        if (EuphoriaPatcher.isDevFunc() || info.isAlreadyInstalled || potentialInstallPath == null) {
            return;
        }
        if (Files.exists(potentialInstallPath, new LinkOption[0])) {
            try {
                boolean containsEuphoriaFile;
                try (Stream<Path> pathStream = Files.walk(potentialInstallPath, new FileVisitOption[0]);){
                    containsEuphoriaFile = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).anyMatch(p -> p.getFileName().toString().contains(PATCH_NAME));
                }
                if (containsEuphoriaFile) {
                    info.isAlreadyInstalled = true;
                    info.installedDir = potentialInstallPath;
                    EuphoriaPatcher.log(0, "EuphoriaPatches_1.7.5 is already installed.");
                } else {
                    EuphoriaPatcher.log(0, "Found incomplete installation. Cleaning up " + potentialInstallPath.getFileName());
                    UsefulFunctions.deleteRecursively(potentialInstallPath);
                    info.isAlreadyInstalled = false;
                }
            }
            catch (IOException e) {
                EuphoriaPatcher.log(3, "Error checking installation status. Cleaning up: " + e.getMessage());
                try {
                    UsefulFunctions.deleteRecursively(potentialInstallPath);
                }
                catch (IOException ex) {
                    EuphoriaPatcher.log(3, "Error deleting directory: " + ex.getMessage());
                }
                info.isAlreadyInstalled = false;
            }
        }
    }

    public static Path getPatchedShaderPath(Path baseFile) {
        if (baseFile == null) {
            EuphoriaPatcher.log(3, "Cannot create patched shader path - base file is null");
            return null;
        }
        try {
            String fileName = baseFile.getFileName().toString();
            String baseName = fileName.endsWith(".zip") ? fileName.replace(".zip", "") : fileName;
            baseName = EuphoriaPatcher.cleanBaseName(baseName);
            return baseFile.resolveSibling(baseName + " + EuphoriaPatches_1.7.5");
        }
        catch (Exception e) {
            EuphoriaPatcher.log(3, "Error creating patched shader path: " + e.getMessage());
            return null;
        }
    }

    public static boolean isSpacEagle() {
        try {
            boolean containsSpacEagle = shaderpacks.toString().contains("SpacEagle");
            EuphoriaPatcher.debugLog("Contains SpacEagle in Path: " + containsSpacEagle);
            Path euphoriaFolder = shaderpacks.resolve("Euphoria-Patches");
            boolean hasEuphoriaFolder = Files.exists(euphoriaFolder, new LinkOption[0]) && Files.isDirectory(euphoriaFolder, new LinkOption[0]);
            EuphoriaPatcher.debugLog("Euphoria-Patches folder exists: " + hasEuphoriaFolder);
            return containsSpacEagle && hasEuphoriaFolder;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private void thankYouMessage(Path baseFile, boolean styleUnbound, boolean styleReimagined, Path installedDir, boolean isAlreadyInstalled) {
        Path shader = null;
        if (installedDir != null) {
            EuphoriaPatcher.debugLog("Using already detected installed directory: " + installedDir);
            shader = installedDir;
        } else if (baseFile != null) {
            shader = EuphoriaPatcher.getPatchedShaderPath(baseFile);
        } else {
            try {
                DirectoryStream.Filter<Path> filter = path -> (Files.isDirectory(path, new LinkOption[0]) || Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".zip")) && path.getFileName().toString().contains(BRAND_NAME) && path.getFileName().toString().contains(" + EuphoriaPatches_1.7.5");
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(shaderpacks, filter);){
                    Iterator<Path> iterator = stream.iterator();
                    if (iterator.hasNext()) {
                        Path path2;
                        shader = path2 = iterator.next();
                    }
                }
            }
            catch (IOException e) {
                EuphoriaPatcher.log(3, "Error finding patched shader directory: " + e.getMessage());
            }
        }
        if (shader != null) {
            boolean isIris = ShaderLoader.getShaderLoader().equals("iris");
            boolean isOculus = ShaderLoader.getShaderLoader().equals("oculus");
            boolean isOptifine = ShaderLoader.getShaderLoader().equals("optifine");
            if (UpdateChecker.isUpdateAvailable() && UpdateChecker.isMajorUpdate()) {
                String newVersionText = "value.info19.0=\u00a7c" + PATCH_VERSION.replace("_", "") + " \u00a7r->\u00a7a " + UpdateChecker.getNewModVersion();
                if (isOculus || isOptifine && !ShaderLoader.isMinecraftVersionAtLeast("1.21.1")) {
                    newVersionText = "value.info19.0=\u00a7c" + PATCH_VERSION.replace("_", "") + " -> " + UpdateChecker.getNewModVersion();
                }
                try {
                    ModifyPatchedShaderpacks.modifyFiles(shader, styleUnbound, styleReimagined, SHADERS_PROPERTIES_LOCATION, null, "screen=<empty> <empty>", "screen=info19 info20");
                    ModifyPatchedShaderpacks.modifyFiles(shader, styleUnbound, styleReimagined, LANG_LOCATION, ".lang", "value\\.info19\\.0=.*", newVersionText);
                }
                catch (IOException e) {
                    EuphoriaPatcher.log(3, 0, "Could not modify the shader to show the user that a new version is available" + e.getMessage());
                }
            }
            try {
                String shaderLoaderVersion = ShaderLoader.getShaderLoaderVersionString();
                ModifyPatchedShaderpacks.modifyFiles(shader, styleUnbound, styleReimagined, SHADER_MYFILE_LOCATION, "null", "\\/\\/ Shader Loader Version Placeholder|#define EUPHORIA_PATCHES_.*_VERSION \\d{1,5}", shaderLoaderVersion);
                ModifyPatchedShaderpacks.modifyFiles(shader, styleUnbound, styleReimagined, "shaders/block.properties", "null", "# Shader Loader Version Placeholder|#define EUPHORIA_PATCHES_.*_VERSION \\d{1,5}", shaderLoaderVersion);
            }
            catch (IOException e) {
                EuphoriaPatcher.log(3, 0, "Could not modify the shader to show the shader loader version" + e.getMessage());
            }
            boolean isMacOS = System.getProperty("os.name").toLowerCase().contains("mac");
            if (isMacOS || !isIris && !isOculus) {
                try {
                    ModifyPatchedShaderpacks.modifyFiles(shader, styleUnbound, styleReimagined, SHADERS_PROPERTIES_LOCATION, null, "(profile\\.POPULAR\\s+=\\s+.*?COLORED_LIGHTING=)192(\\s+.*)", "$10  $2");
                    ModifyPatchedShaderpacks.modifyFiles(shader, styleUnbound, styleReimagined, SHADERS_PROPERTIES_LOCATION, null, "(profile\\.POPULAR\\s+=\\s+.*?END_CRYSTAL_VORTEX=)3(\\s+.*)", "$10$2");
                    ModifyPatchedShaderpacks.modifyFiles(shader, styleUnbound, styleReimagined, SHADERS_PROPERTIES_LOCATION, null, "(profile\\.POPULAR\\s+=\\s+.*?)\\s+DRAGON_DEATH_EFFECT(\\s+.*)", "$1 !DRAGON_DEATH_EFFECT$2");
                    ModifyPatchedShaderpacks.modifyFiles(shader, styleUnbound, styleReimagined, SHADERS_PROPERTIES_LOCATION, null, "(profile\\.POPULAR\\s+=\\s+.*?)\\s+END_PORTAL_BEAM(\\s+.*)", "$1 !END_PORTAL_BEAM$2");
                    EuphoriaPatcher.debugLog("Applied compatibility modifications for macOS/non-iris loader: disabled COLORED_LIGHTING, END_CRYSTAL_VORTEX, DRAGON_DEATH_EFFECT, and END_PORTAL_BEAM in POPULAR profile");
                }
                catch (IOException e) {
                    EuphoriaPatcher.log(3, 0, "Could not apply compatibility shader modifications: " + e.getMessage());
                }
            }
            if (EuphoriaPatcher.isSpacEagle()) {
                try {
                    ModifyPatchedShaderpacks.modifyFiles(shader, styleUnbound, styleReimagined, SHADER_MYFILE_LOCATION, null, "\\/\\/ Developed by SpacEagle17", "#define SPACEAGLE17");
                }
                catch (IOException e) {
                    EuphoriaPatcher.log(3, 0, "Could not modify the shader for SpacEagle17" + e.getMessage());
                }
                this.createAlternativeShaderNames(shader, isAlreadyInstalled);
                EuphoriaPatcher.log(1, "Have fun developing Euphoria Patches!\n");
            } else {
                this.createAlternativeShaderNames(shader, isAlreadyInstalled);
                EuphoriaPatcher.log(-1, "Thank you for using Euphoria Patches - SpacEagle17");
            }
        } else {
            EuphoriaPatcher.debugLog("No valid shader path found for thank you message");
            EuphoriaPatcher.log(-1, "Thank you for using Euphoria Patches - SpacEagle17");
        }
    }

    private void installBaseMessage() {
        if (IS_BASE_MESSAGE_SHOWN) {
            return;
        }
        IS_BASE_MESSAGE_SHOWN = true;
        Path highestOlderVersion = this.findHighestOlderVersion();
        EuphoriaPatcher.log(3, 8, "=== SHADER NOT FOUND ===");
        EuphoriaPatcher.log(3, 8, "Required: ComplementaryShaders " + VERSION.replace("_", ""));
        if (highestOlderVersion != null) {
            EuphoriaPatcher.log(3, 8, "Found: " + highestOlderVersion.getFileName().toString());
            EuphoriaPatcher.log(3, 8, "You have an older version installed.");
            EuphoriaPatcher.log(3, 8, "");
            EuphoriaPatcher.log(3, 8, "SOLUTION: Download and install ComplementaryShaders " + VERSION.replace("_", ""));
        } else {
            EuphoriaPatcher.log(3, 8, "");
            EuphoriaPatcher.log(3, 8, "No Complementary shader found in your shaderpacks folder.");
            EuphoriaPatcher.log(3, 8, "");
            EuphoriaPatcher.log(3, 8, "SOLUTION: Download ComplementaryShaders " + VERSION.replace("_", ""));
        }
        EuphoriaPatcher.log(3, 8, "Download from: https://www.complementary.dev/");
        this.startShaderpacksWatcher();
    }

    private Path findHighestOlderVersion() {
        Path highestVersionPath = null;
        int[] highestVersion = new int[]{0, 0, 0};
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(shaderpacks);){
            for (Path path : stream) {
                int[] version;
                if (!this.isOlderBrandNameShader(path, Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".zip")) || EuphoriaPatcher.compareVersions(version = EuphoriaPatcher.extractVersionNumbers(path.getFileName().toString()), highestVersion) <= 0) continue;
                highestVersion = version;
                highestVersionPath = path;
            }
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, "Error checking for older shader versions: " + e.getMessage());
        }
        return highestVersionPath;
    }

    private boolean isOlderBrandNameShader(Path path, boolean isFile) {
        boolean isComplementary;
        String name = path.getFileName().toString();
        boolean bl = isComplementary = name.contains(BRAND_NAME) && name.matches(".*_r\\d+\\.\\d+(?:\\.\\d+)?.*") && !name.contains(PATCH_NAME);
        if (isComplementary) {
            int[] targetVersion;
            boolean isOlder;
            int[] fileVersion = EuphoriaPatcher.extractVersionNumbers(name);
            boolean bl2 = isOlder = EuphoriaPatcher.compareVersions(fileVersion, targetVersion = EuphoriaPatcher.extractVersionNumbers(VERSION)) < 0;
            return isOlder && (isFile ? name.endsWith(".zip") : Files.isDirectory(path, new LinkOption[0]));
        }
        return false;
    }

    public static boolean isNewerShaderVersion(String fileName) {
        int[] targetVersion;
        if (!fileName.contains(BRAND_NAME)) {
            return false;
        }
        int[] fileVersion = EuphoriaPatcher.extractVersionNumbers(fileName);
        return EuphoriaPatcher.compareVersions(fileVersion, targetVersion = EuphoriaPatcher.extractVersionNumbers(VERSION)) > 0;
    }

    public static String getVersionStringFromFileName(String fileName) {
        int[] versionNumbers = EuphoriaPatcher.extractVersionNumbers(fileName);
        StringBuilder sb = new StringBuilder("r").append(versionNumbers[0]).append(".").append(versionNumbers[1]);
        if (versionNumbers[2] > 0) {
            sb.append(".").append(versionNumbers[2]);
        }
        return sb.toString();
    }

    public static int[] extractVersionNumbers(String filename) {
        int[] version = new int[]{0, 0, 0};
        Pattern pattern = Pattern.compile("_r(\\d+)\\.(\\d+)(?:\\.(\\d+))?");
        Matcher matcher = pattern.matcher(filename);
        if (matcher.find()) {
            version[0] = Integer.parseInt(matcher.group(1));
            version[1] = Integer.parseInt(matcher.group(2));
            version[2] = matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : 0;
        }
        return version;
    }

    private static int compareVersions(int[] v1, int[] v2) {
        for (int i = 0; i < 3; ++i) {
            if (v1[i] == v2[i]) continue;
            return v1[i] - v2[i];
        }
        return 0;
    }

    private Path createTempDirectory() {
        try {
            return Files.createTempDirectory("euphoria-patcher-", new FileAttribute[0]);
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, "Error creating temporary directory: " + e.getMessage());
            return null;
        }
    }

    public static String cleanBaseName(String baseName) {
        if (baseName == null) {
            return null;
        }
        EuphoriaPatcher.debugLog("Before Cleaning base name: " + baseName);
        String cleaned = baseName.replaceAll("(?i)(?:[\\s_-]+(?:\\(copy\\)|copy|\\(\\d+\\)|\\d+))+$", "");
        cleaned = cleaned.replaceAll("\\s+", " ").trim();
        EuphoriaPatcher.debugLog("Cleaned base name: " + cleaned);
        return cleaned;
    }

    private boolean processAndPatchShaders(ShaderInfo info, Path temp) {
        if (info.baseFile == null && !EuphoriaPatcher.isDevFunc()) {
            this.installBaseMessage();
            return false;
        }
        assert (info.baseFile != null);
        String baseName = info.baseFile.getFileName().toString().replace(".zip", "");
        baseName = EuphoriaPatcher.cleanBaseName(baseName);
        String patchedName = baseName + " + EuphoriaPatches_1.7.5";
        Path baseExtracted = this.extractBase(info.baseFile, temp, baseName);
        if (baseExtracted == null) {
            return false;
        }
        this.normalizeShaderStyleInCommon(baseExtracted);
        Path baseArchived = this.archiveBase(baseExtracted, temp, baseName);
        if (!ArchiveOperations.verifyBaseArchive(baseArchived, info.baseFile.getFileName().toString())) {
            return false;
        }
        boolean result = this.applyPatch(baseArchived, temp, patchedName, info.styleUnbound, info.styleReimagined);
        try {
            EuphoriaPatcher.debugLog("Cleaning up the temporary directory...");
            FileUtils.deleteDirectory(temp.toFile());
        }
        catch (IOException e) {
            EuphoriaPatcher.log(2, "Error cleaning up temporary directory: " + e.getMessage());
        }
        return result;
    }

    private Path extractBase(Path baseFile, Path temp, String baseName) {
        Path baseExtracted = temp.resolve(baseName);
        return ArchiveOperations.extract(baseFile, baseExtracted, "extracting archive");
    }

    private Path archiveBase(Path baseExtracted, Path temp, String baseName) {
        Path baseArchived = temp.resolve(baseName + ".tar");
        return ArchiveOperations.archive(baseExtracted, baseArchived);
    }

    private void normalizeShaderStyleInCommon(Path baseExtracted) {
        try {
            Path commons = baseExtracted.resolve(COMMON_LOCATION);
            String config = FileUtils.readFileToString(commons.toFile(), "UTF-8").replaceFirst("SHADER_STYLE [14]", "SHADER_STYLE 1");
            FileUtils.writeStringToFile(commons.toFile(), config, "UTF-8");
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, "Error normalizing shader style in common file: " + e.getMessage());
        }
    }

    private boolean applyPatch(Path baseArchived, Path temp, String patchedName, boolean styleUnbound, boolean styleReimagined) {
        Path patchedArchive = temp.resolve(patchedName + ".tar");
        Path patchedFile = shaderpacks.resolve(patchedName);
        return EuphoriaPatcher.isDevFunc() ? this.applyDevPatch(baseArchived, patchedArchive, patchedFile) : this.applyProductionPatch(baseArchived, patchedArchive, temp.resolve(patchedName + ".patch"), patchedFile, styleUnbound, styleReimagined);
    }

    private boolean applyDevPatch(Path baseArchived, Path patchedArchive, Path patchedFile) {
        Path[] directories = new Path[]{mainIntellijDir.resolve("src/main/resources"), mainIntellijDir.resolve("EuphoriaPatchFiles")};
        boolean success = true;
        for (Path dir : directories) {
            this.checkBuildPath(dir);
            Path patchFile = dir.resolve("EuphoriaPatches_1.7.5.patch");
            success &= this.createDevPatch(baseArchived, patchedFile, patchedArchive, patchFile);
        }
        return success;
    }

    private void checkBuildPath(Path buildDir) {
        if (!Files.exists(buildDir, new LinkOption[0])) {
            try {
                Files.createDirectories(buildDir, new FileAttribute[0]);
                EuphoriaPatcher.log(2, "Build directory created successfully: " + buildDir);
            }
            catch (IOException e) {
                EuphoriaPatcher.log(3, "Failed to create directory: " + e.getMessage());
            }
        }
    }

    private boolean createDevPatch(Path baseArchived, Path patchedFile, Path patchedArchive, Path patchFile) {
        try {
            ArchiveUtils.archive(patchedFile, patchedArchive);
            FileUI.diff(baseArchived.toFile(), patchedArchive.toFile(), patchFile.toFile());
            EuphoriaPatcher.log(0, ".patch file successfully created in " + patchFile + "!");
            return true;
        }
        catch (IOException | InvalidHeaderException | CompressorException e) {
            EuphoriaPatcher.log(3, "Error creating dev patch: " + e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean applyProductionPatch(Path baseArchived, Path patchedArchive, Path patchFile, Path patchedFile, boolean styleUnbound, boolean styleReimagined) {
        try (InputStream patchStream = this.getClass().getClassLoader().getResourceAsStream("EuphoriaPatches_1.7.5.patch");){
            if (patchStream == null) return false;
            FileUtils.copyInputStreamToFile(Objects.requireNonNull(patchStream), patchFile.toFile());
            FileUI.patch(baseArchived.toFile(), patchedArchive.toFile(), patchFile.toFile());
            try {
                ArchiveUtils.extract(patchedArchive, patchedFile);
            }
            catch (IOException | ArchiveException e) {
                EuphoriaPatcher.log(2, "Error extracting archive: " + e.getMessage());
            }
            this.applyStyleSettings(patchedFile, styleUnbound, styleReimagined);
            EuphoriaPatcher.log(1, "EuphoriaPatches was successfully installed. Enjoy! -SpacEagle17");
            boolean bl = true;
            return bl;
        }
        catch (IOException | InvalidHeaderException | CompressorException e) {
            EuphoriaPatcher.log(3, "Error applying patch file: " + e.getMessage());
        }
        return false;
    }

    private void applyStyleSettings(Path patchedFile, boolean styleUnbound, boolean styleReimagined) throws IOException {
        if (!styleUnbound && !styleReimagined) {
            return;
        }
        File commons = new File(patchedFile.toFile(), COMMON_LOCATION);
        String commonContent = FileUtils.readFileToString(commons, "UTF-8");
        String reimaginedConfig = commonContent.replaceFirst("SHADER_STYLE [14]", "SHADER_STYLE 1");
        String unboundConfig = commonContent.replaceFirst("SHADER_STYLE [14]", "SHADER_STYLE 4");
        if (!styleReimagined) {
            FileUtils.writeStringToFile(commons, unboundConfig, "UTF-8");
            return;
        }
        if (!styleUnbound) {
            FileUtils.writeStringToFile(commons, reimaginedConfig, "UTF-8");
            return;
        }
        boolean isReimagined = patchedFile.getFileName().toString().contains("Reimagined");
        String otherStyle = isReimagined ? "Unbound" : "Reimagined";
        String currentStyle = isReimagined ? "Reimagined" : "Unbound";
        File otherStyleFile = new File(patchedFile.getParent().toFile(), patchedFile.getFileName().toString().replace(currentStyle, otherStyle));
        FileUtils.copyDirectory(patchedFile.toFile(), otherStyleFile);
        if (isReimagined) {
            FileUtils.writeStringToFile(commons, reimaginedConfig, "UTF-8");
            FileUtils.writeStringToFile(new File(otherStyleFile, COMMON_LOCATION), unboundConfig, "UTF-8");
        } else {
            FileUtils.writeStringToFile(commons, unboundConfig, "UTF-8");
            FileUtils.writeStringToFile(new File(otherStyleFile, COMMON_LOCATION), reimaginedConfig, "UTF-8");
        }
    }

    private void startShaderpacksWatcher() {
        if (this.shaderpacksWatcher != null && this.shaderpacksWatcher.isRunning()) {
            return;
        }
        this.shaderpacksWatcher = ShaderpacksWatcher.createAndStart(this, true);
        if (this.shaderpacksWatcher != null) {
            EuphoriaPatcher.log(0, "Watching shaderpacks folder for changes...");
        }
    }

    public ShaderpacksWatcher getShaderpacksWatcher() {
        return this.shaderpacksWatcher;
    }

    private void stopShaderpacksWatcher() {
        if (this.shaderpacksWatcher != null) {
            this.shaderpacksWatcher.stopWatching();
        }
    }

    public void startWatcherAfterByteSizeFailure() {
        if (this.shaderpacksWatcher != null) {
            this.shaderpacksWatcher.resetAfterByeSizeFailure();
        } else {
            this.startShaderpacksWatcher();
        }
    }

    public synchronized boolean processNewShaderpack(Path baseFile) {
        try {
            EuphoriaPatcher.log(0, "Processing newly detected shader pack: " + baseFile.getFileName());
            Path temp = this.createTempDirectory();
            if (temp == null) {
                return false;
            }
            ShaderInfo shaderInfo = new ShaderInfo();
            shaderInfo.baseFile = baseFile;
            String name = baseFile.getFileName().toString();
            if (name.contains("Reimagined")) {
                shaderInfo.styleReimagined = true;
            } else if (name.contains("Unbound")) {
                shaderInfo.styleUnbound = true;
            } else {
                String detectedStyle = this.detectStyleFromCommonFile(baseFile);
                shaderInfo.styleReimagined = "Reimagined".equals(detectedStyle);
                shaderInfo.styleUnbound = "Unbound".equals(detectedStyle);
            }
            boolean success = this.completeShaderPatching(shaderInfo, temp);
            if (success) {
                this.stopShaderpacksWatcher();
            } else if (this.shaderpacksWatcher != null) {
                this.shaderpacksWatcher.trackInvalidByteSizeFile(baseFile.getFileName().toString());
            }
            return success;
        }
        catch (Exception e) {
            EuphoriaPatcher.log(3, "Error processing newly detected shader pack: " + e.getMessage());
            return false;
        }
    }

    private void createAlternativeShaderNames(Path patchedShaderPath, boolean isAlreadyInstalled) {
        String[] alternativeNames;
        if (alternativeShaderNames.isEmpty() || isAlreadyInstalled) {
            if (alternativeShaderNames.isEmpty()) {
                EuphoriaPatcher.debugLog("No alternative shader names configured.");
            } else {
                EuphoriaPatcher.debugLog("Skipping alternative shader names creation as Euphoria Patches is already installed.");
            }
            return;
        }
        String baseVersion = VERSION.replace("_", "");
        String patchVersion = PATCH_VERSION.replace("_", "");
        String illegalChars = "[\\\\/:*?\"<>|]";
        for (String name : alternativeNames = alternativeShaderNames.split(",")) {
            String trimmedName = name.trim();
            if (trimmedName.isEmpty()) continue;
            String finalName = trimmedName.replace("{baseVersion}", baseVersion).replace("{patchVersion}", patchVersion);
            if (finalName.matches(".*" + illegalChars + ".*")) {
                EuphoriaPatcher.log(2, "Skipping alternative shader name with illegal characters: \"" + finalName + "\"");
                continue;
            }
            this.createShaderCopy(patchedShaderPath, finalName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createShaderCopy(Path sourceShaderPath, String newName) {
        try {
            Path shaderpacks = sourceShaderPath.getParent();
            Path targetPath = shaderpacks.resolve(newName);
            if (Files.exists(targetPath, new LinkOption[0])) {
                Path myFilePath = targetPath.resolve(SHADER_MYFILE_LOCATION);
                if (Files.exists(myFilePath, new LinkOption[0])) {
                    String firstLine;
                    try (BufferedReader reader = Files.newBufferedReader(myFilePath);){
                        firstLine = reader.readLine();
                    }
                    if (firstLine != null && firstLine.startsWith("// Euphoria Patches")) {
                        String expectedVersion;
                        String fileVersion = firstLine.replace("// Euphoria Patches ", "").trim();
                        if (fileVersion.equals(expectedVersion = PATCH_VERSION.replace("_", ""))) {
                            EuphoriaPatcher.debugLog("Skipping creation of alternative shader name \"" + newName + "\" as it already exists with current version.");
                            return;
                        }
                        EuphoriaPatcher.debugLog("Found outdated alternative shader \"" + newName + "\" (version " + fileVersion + "), updating to " + expectedVersion);
                        UsefulFunctions.deleteRecursively(targetPath);
                    } else {
                        EuphoriaPatcher.debugLog("Found existing shader with name \"" + newName + "\" but couldn't verify version, replacing it.");
                        UsefulFunctions.deleteRecursively(targetPath);
                    }
                } else {
                    EuphoriaPatcher.debugLog("Found existing shader with name \"" + newName + "\" but it doesn't appear to be a valid Euphoria shader, replacing it.");
                    UsefulFunctions.deleteRecursively(targetPath);
                }
            }
            EuphoriaPatcher.log(0, "Creating alternative shader names from: " + sourceShaderPath.getFileName());
            EuphoriaPatcher.debugLog("Creating alternative shader with name: \"" + newName + "\"");
            FileUtils.copyDirectory(sourceShaderPath.toFile(), targetPath.toFile());
            EuphoriaPatcher.log(0, "Successfully created alternative shader: \"" + newName + "\"");
            return;
        }
        catch (IOException e) {
            EuphoriaPatcher.log(2, "Error creating alternative shader \"" + newName + "\": " + e.getMessage());
        }
    }

    static {
        filesScannedCounter = 0;
        totalFilesToScan = 0;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                UpdateShaderConfig.shutdownFileWriter();
                Config.stopConfigWatcher();
                EuphoriaPatcher.instance.shaderpacksWatcher.stopWatching();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }

    private static class ShaderInfo {
        Path baseFile = null;
        Path installedDir = null;
        boolean styleReimagined = false;
        boolean styleUnbound = false;
        boolean isAlreadyInstalled = false;

        private ShaderInfo() {
        }
    }
}

