/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.features;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;
import mc.euphoria_patches.euphoria_patcher.util.UsefulFunctions;

public class ModifyOutdatedPatches {
    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ModifyOutdatedPatches] " + message);
    }

    public static void rename() {
        ModifyOutdatedPatches.debugLog("Starting rename process for outdated patches");
        int renamedCount = 0;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(EuphoriaPatcher.shaderpacks, path -> ModifyOutdatedPatches.isOutdatedPatch(path, true));){
            for (Path potentialFile : stream) {
                String name = potentialFile.getFileName().toString();
                ModifyOutdatedPatches.debugLog("Found outdated pack to rename: " + name);
                String newName = name.replaceFirst("(.*) \\+", "Outdated $1 +").replace("EuphoriaPatches_", "EP_");
                ModifyOutdatedPatches.debugLog("Renaming to: " + newName);
                Files.move(potentialFile, potentialFile.resolveSibling(newName), new CopyOption[0]);
                EuphoriaPatcher.log(0, "Successfully renamed outdated " + name + " shaderpack file!");
                ++renamedCount;
            }
            if (renamedCount == 0) {
                ModifyOutdatedPatches.debugLog("No outdated patches found to rename");
            } else {
                ModifyOutdatedPatches.debugLog("Renamed " + renamedCount + " outdated patch files");
            }
        }
        catch (IOException e) {
            ModifyOutdatedPatches.debugLog("Error reading shaderpacks directory: " + e.getMessage());
            EuphoriaPatcher.log(3, 0, "Error reading shaderpacks directory: " + e.getMessage());
        }
    }

    public static void delete() {
        ModifyOutdatedPatches.debugLog("Starting delete process for outdated patches");
        AtomicInteger deletedCount = new AtomicInteger();
        try (Stream<Path> stream = Files.list(EuphoriaPatcher.shaderpacks);){
            stream.forEach(path -> {
                try {
                    if (ModifyOutdatedPatches.isOutdatedPatch(path, false)) {
                        ModifyOutdatedPatches.debugLog("Found outdated pack to delete: " + path.getFileName());
                        UsefulFunctions.deleteRecursively(path);
                        EuphoriaPatcher.log(0, "Successfully deleted outdated " + path.getFileName() + " shaderpack file!");
                        deletedCount.getAndIncrement();
                    }
                }
                catch (IOException e) {
                    ModifyOutdatedPatches.debugLog("Error processing path: " + path + " - " + e.getMessage());
                    EuphoriaPatcher.log(2, 0, "Error processing path: " + path + " - " + e.getMessage());
                }
            });
            if (deletedCount.get() == 0) {
                ModifyOutdatedPatches.debugLog("No outdated patches found to delete");
            } else {
                ModifyOutdatedPatches.debugLog("Deleted " + deletedCount + " outdated patch files");
            }
        }
        catch (IOException e) {
            ModifyOutdatedPatches.debugLog("Error reading shaderpacks directory: " + e.getMessage());
            EuphoriaPatcher.log(3, 0, "Error reading shaderpacks directory: " + e.getMessage());
        }
    }

    private static boolean isOutdatedPatch(Path path, boolean renameFile) {
        String name = path.getFileName().toString();
        ModifyOutdatedPatches.debugLog("Checking if patch is outdated: " + name + " (for " + (renameFile ? "rename" : "delete") + ")");
        boolean result = renameFile ? name.contains("EuphoriaPatches") && !name.contains("_1.7.5") : (name.contains("EuphoriaPatches") || name.matches(".*Outdated.*Complementary.* \\+ EP.*")) && !name.contains("_1.7.5");
        ModifyOutdatedPatches.debugLog("Patch " + name + " is " + (result ? "outdated" : "current"));
        return result;
    }
}

