/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;

public class IrisReloadManager {
    private static volatile boolean pendingReload = false;
    private static volatile Class<?> pendingIrisClass = null;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[IrisReloadManager] " + message);
    }

    public static Class<?> findIrisClass() {
        try {
            Class<?> irisClass = Class.forName("net.irisshaders.iris.Iris");
            IrisReloadManager.debugLog("Found Iris class at net.irisshaders.iris.Iris");
            return irisClass;
        }
        catch (ClassNotFoundException e1) {
            IrisReloadManager.debugLog("Iris class not found at net.irisshaders.iris.Iris, trying alternative location");
            try {
                Class<?> irisClass = Class.forName("net.coderbot.iris.Iris");
                IrisReloadManager.debugLog("Found Iris class at net.coderbot.iris.Iris");
                return irisClass;
            }
            catch (ClassNotFoundException e2) {
                IrisReloadManager.debugLog("Iris not found - this is normal if Iris isn't installed");
                return null;
            }
        }
    }

    public static void scheduleReload(Class<?> irisClass) {
        if (irisClass != null) {
            IrisReloadManager.debugLog("Scheduling shader reload");
            pendingIrisClass = irisClass;
            pendingReload = true;
        } else {
            IrisReloadManager.debugLog("Cannot schedule reload - Iris class is null");
        }
    }

    public static void findAndScheduleReload() {
        Class<?> irisClass = IrisReloadManager.findIrisClass();
        if (irisClass != null) {
            IrisReloadManager.scheduleReload(irisClass);
        }
    }

    public static void checkPendingReload() {
        if (pendingReload && pendingIrisClass != null) {
            try {
                IrisReloadManager.debugLog("Processing pending shader reload on main thread");
                pendingIrisClass.getMethod("reload", new Class[0]).invoke(null, new Object[0]);
                IrisReloadManager.debugLog("Successfully reloaded shaders");
            }
            catch (Exception e) {
                EuphoriaPatcher.log(2, 0, "Error reloading Iris shaders: " + e.getMessage());
            }
            finally {
                pendingReload = false;
                pendingIrisClass = null;
            }
        }
    }

    public static boolean isIrisInstalled() {
        return IrisReloadManager.findIrisClass() != null;
    }
}

