/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;
import mc.euphoria_patches.shadow.com.google.gson.JsonArray;
import mc.euphoria_patches.shadow.com.google.gson.JsonElement;
import mc.euphoria_patches.shadow.com.google.gson.JsonObject;
import mc.euphoria_patches.shadow.com.google.gson.JsonParser;

public class UpdateChecker {
    private static final String PROJECT_ID = "4H6sumDB";
    private static final String UPDATE_URL = "https://api.modrinth.com/v2/project/4H6sumDB/version";
    private static final String MOD_VERSION = "_1.7.6".replace("_", "");
    private static String NEW_MOD_VERSION = null;
    private static String LATEST_CHANGELOG = null;
    private static boolean NEW_VERSION_AVAILABLE = false;
    private static boolean UPDATE_CHECK_PERFORMED = false;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[UpdateChecker] " + message);
    }

    public static boolean isUpdateAvailable() {
        try {
            UpdateChecker.checkForUpdates();
            return NEW_VERSION_AVAILABLE;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getNewModVersion() {
        UpdateChecker.checkForUpdates();
        return NEW_MOD_VERSION;
    }

    public static String getLatestChangelog() {
        UpdateChecker.checkForUpdates();
        return LATEST_CHANGELOG;
    }

    public static boolean isMajorUpdate() {
        String[] lines;
        UpdateChecker.checkForUpdates();
        UpdateChecker.debugLog("Checking if update is major...");
        if (LATEST_CHANGELOG == null || LATEST_CHANGELOG.isEmpty()) {
            UpdateChecker.debugLog("No changelog available, assuming minor update");
            return false;
        }
        for (String line : lines = LATEST_CHANGELOG.split("\n")) {
            UpdateChecker.debugLog("Checking line: " + line.trim());
            if (!line.toLowerCase().contains("updated to complementary shaders") || !line.toLowerCase().contains("euphoria patches") || !line.toLowerCase().contains("this is a minor update")) continue;
            UpdateChecker.debugLog("Found minor update indicator in changelog - this is NOT a major update");
            return false;
        }
        UpdateChecker.debugLog("No minor update indicator found in changelog - this is a major update");
        return true;
    }

    public static void checkForUpdates() {
        if (UPDATE_CHECK_PERFORMED || !EuphoriaPatcher.doUpdateChecking) {
            UpdateChecker.debugLog("Update check skipped. Already performed: " + UPDATE_CHECK_PERFORMED + ", Update checking enabled: " + EuphoriaPatcher.doUpdateChecking);
            return;
        }
        UPDATE_CHECK_PERFORMED = true;
        UpdateChecker.debugLog("Starting update check...");
        UpdateChecker.debugLog("Current version: " + MOD_VERSION);
        try {
            NEW_MOD_VERSION = UpdateChecker.fetchLatestVersion();
            if (NEW_MOD_VERSION == null) {
                EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] Failed to fetch the latest version.");
                UpdateChecker.debugLog("Failed to fetch latest version from Modrinth API");
                return;
            }
            UpdateChecker.debugLog("Latest version from Modrinth: " + NEW_MOD_VERSION);
            if (UpdateChecker.isNewerVersion(NEW_MOD_VERSION)) {
                NEW_VERSION_AVAILABLE = true;
                UpdateChecker.debugLog("New version available!");
                EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] A new version of the EuphoriaPatcher Mod is available: " + NEW_MOD_VERSION);
                EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] Download it from Modrinth: https://euphoriapatches.com/download");
                EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] Current Version: " + MOD_VERSION);
            } else {
                UpdateChecker.debugLog("Mod is up to date");
                EuphoriaPatcher.log(0, "[UPDATE CHECKER] The EuphoriaPatcher Mod is up to date");
            }
        }
        catch (Exception e) {
            String errorType = e.getClass().getSimpleName();
            String errorMessage = e.getMessage() != null ? e.getMessage() : "Unknown error";
            EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] Update check failed: " + errorType + " - " + errorMessage);
            UpdateChecker.debugLog("Update check failed with " + errorType + ": " + errorMessage);
            UpdateChecker.debugLog("Full exception: " + e);
        }
    }

    private static String extractMainVersion(String versionString) {
        return versionString.split("-")[0];
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private static String fetchLatestVersion() throws Exception {
        UpdateChecker.debugLog("Fetching latest version from Modrinth API: https://api.modrinth.com/v2/project/4H6sumDB/version");
        try {
            URL url = new URL(UPDATE_URL);
            UpdateChecker.debugLog("URL created successfully");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/json");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            UpdateChecker.debugLog("Connection configured, attempting to connect...");
            int responseCode = connection.getResponseCode();
            UpdateChecker.debugLog("Modrinth API response code: " + responseCode);
            if (responseCode != 200) {
                EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] Failed to connect to Modrinth API. Response code: " + responseCode);
                UpdateChecker.debugLog("Connection failed with response code: " + responseCode);
                return null;
            }
            try {
                String string;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    UpdateChecker.debugLog("Reading response from API...");
                    JsonElement jsonElement = new JsonParser().parse(reader);
                    JsonArray versions = jsonElement.getAsJsonArray();
                    UpdateChecker.debugLog("Fetched " + versions.size() + " versions from Modrinth");
                    if (versions.isEmpty()) {
                        EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] No versions found on Modrinth.");
                        UpdateChecker.debugLog("No versions found in API response");
                        String string2 = MOD_VERSION;
                        return string2;
                    }
                    JsonObject latestVersion = versions.get(0).getAsJsonObject();
                    String fullVersionNumber = latestVersion.get("version_number").getAsString();
                    UpdateChecker.debugLog("Full version number from Modrinth: " + fullVersionNumber);
                    if (latestVersion.has("changelog")) {
                        LATEST_CHANGELOG = latestVersion.get("changelog").getAsString();
                        UpdateChecker.debugLog("Changelog fetched successfully!");
                        UpdateChecker.debugLog("Fetched Changelog is:\n" + LATEST_CHANGELOG);
                    } else {
                        UpdateChecker.debugLog("No changelog available for latest version");
                    }
                    String mainVersion = UpdateChecker.extractMainVersion(fullVersionNumber);
                    UpdateChecker.debugLog("Extracted main version: " + mainVersion);
                    string = mainVersion;
                }
                return string;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                connection.disconnect();
                UpdateChecker.debugLog("Connection closed");
            }
        }
        catch (UnknownHostException e) {
            UpdateChecker.debugLog("Network error: Unable to resolve Modrinth API host (no internet connection or DNS issue)");
            throw new Exception("Unable to reach Modrinth API - No internet connection or DNS issue: " + e.getMessage(), e);
        }
        catch (ConnectException e) {
            UpdateChecker.debugLog("Network error: Connection refused or timeout");
            throw new Exception("Unable to connect to Modrinth API - Connection refused or timeout: " + e.getMessage(), e);
        }
        catch (SocketTimeoutException e) {
            UpdateChecker.debugLog("Network error: Request timed out");
            throw new Exception("Modrinth API request timed out - Please check your internet connection: " + e.getMessage(), e);
        }
        catch (IOException e) {
            UpdateChecker.debugLog("IO error while fetching version: " + e.getMessage());
            throw new Exception("IO error while accessing Modrinth API: " + e.getMessage(), e);
        }
        catch (Exception e) {
            UpdateChecker.debugLog("Unexpected error: " + e.getClass().getSimpleName() + " - " + e.getMessage());
            throw new Exception("Unexpected error while fetching version: " + e.getMessage(), e);
        }
    }

    private static boolean isNewerVersion(String latestVersion) {
        String[] latest = latestVersion.split("\\.");
        String[] current = MOD_VERSION.split("\\.");
        for (int i = 0; i < Math.min(latest.length, current.length); ++i) {
            int currentPart;
            int latestPart = Integer.parseInt(latest[i]);
            if (latestPart == (currentPart = Integer.parseInt(current[i]))) continue;
            return latestPart > currentPart;
        }
        return latest.length > current.length;
    }
}

