/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;

public class SodiumConsole {
    private static boolean initialized = false;
    private static boolean sodiumAvailable = false;
    private static Object consoleSink = null;
    private static Method logMessageMethod = null;
    private static Class<?> messageLevelClass = null;
    private static Object infoLevel = null;
    private static Object warnLevel = null;
    private static Object severeLevel = null;
    private static boolean useDoubleForFadeTimer = false;
    private static boolean newSignature = false;
    private static Class<?> textClass = null;
    private static Method textOfMethod = null;
    private static Constructor<?> textConstructor = null;
    private static boolean debugLogging = EuphoriaPatcher.doDebugLogging;
    private static final List<String[]> KNOWN_SODIUM_PATHS = Arrays.asList({"me.jellysquid.mods.sodium.client.gui.console.Console", "me.jellysquid.mods.sodium.client.gui.console.ConsoleSink", "me.jellysquid.mods.sodium.client.gui.console.message.MessageLevel"}, {"net.caffeinemc.mods.sodium.client.console.Console", "net.caffeinemc.mods.sodium.client.console.ConsoleSink", "net.caffeinemc.mods.sodium.client.console.message.MessageLevel"});

    private static void log(String message) {
        EuphoriaLogger.debugLog("[SodiumConsole] " + message);
    }

    private static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        SodiumConsole.log("Initializing...");
        SodiumConsole.initializeTextClass();
        for (String[] paths : KNOWN_SODIUM_PATHS) {
            SodiumConsole.log("Trying path: " + paths[0]);
            if (!SodiumConsole.tryInitialize(paths[0], paths[1], paths[2])) continue;
            SodiumConsole.log("Successfully initialized with path: " + paths[0]);
            return;
        }
        SodiumConsole.log("All regular initialization attempts failed");
        if (SodiumConsole.trySpecificVersionFallbacks()) {
            SodiumConsole.log("Fallback initialization succeeded");
            return;
        }
        SodiumConsole.log("Failed to initialize Sodium console");
    }

    private static boolean trySpecificVersionFallbacks() {
        try {
            Class<?> consoleClass = Class.forName("me.jellysquid.mods.sodium.client.gui.console.Console");
            SodiumConsole.log("Found Console class in fallback");
            Method instanceMethod = consoleClass.getMethod("instance", new Class[0]);
            consoleSink = instanceMethod.invoke(null, new Object[0]);
            SodiumConsole.log("Got Console instance in fallback");
            messageLevelClass = Class.forName("me.jellysquid.mods.sodium.client.gui.console.message.MessageLevel");
            infoLevel = messageLevelClass.getField("INFO").get(null);
            warnLevel = messageLevelClass.getField("WARN").get(null);
            severeLevel = messageLevelClass.getField("SEVERE").get(null);
            SodiumConsole.log("Got MessageLevel constants in fallback");
            if (textClass == null) {
                try {
                    textClass = Class.forName("net.minecraft.class_2561");
                    SodiumConsole.log("Found obfuscated Text class during fallback");
                    for (Method m : textClass.getMethods()) {
                        if (!Modifier.isStatic(m.getModifiers()) || !m.getReturnType().equals(textClass) || m.getParameterCount() != 1 || !m.getParameterTypes()[0].equals(String.class)) continue;
                        textOfMethod = m;
                        SodiumConsole.log("Found potential text method in fallback: " + m.getName());
                        break;
                    }
                }
                catch (Exception e) {
                    SodiumConsole.log("Could not find obfuscated text class during fallback");
                }
            }
            Class<?> consoleSinkClass = consoleSink.getClass();
            SodiumConsole.log("ConsoleSink class: " + consoleSinkClass.getName());
            for (Method method : consoleSinkClass.getMethods()) {
                Class<?>[] paramTypes;
                if (!method.getName().equals("logMessage") || method.getParameterCount() != 3 || !messageLevelClass.isAssignableFrom((paramTypes = method.getParameterTypes())[0]) || !paramTypes[2].equals(Integer.TYPE) && !paramTypes[2].equals(Double.TYPE)) continue;
                logMessageMethod = method;
                useDoubleForFadeTimer = paramTypes[2].equals(Double.TYPE);
                newSignature = false;
                sodiumAvailable = true;
                SodiumConsole.log("Found method with direct reflection: " + method);
                return true;
            }
        }
        catch (Exception e) {
            SodiumConsole.log("Fallback attempt failed: " + e.getMessage());
        }
        return false;
    }

    private static void initializeTextClass() {
        SodiumConsole.log("Initializing text class");
        if (SodiumConsole.tryLoadTextClass("net.minecraft.text.Text", "of", "Fabric Text")) {
            return;
        }
        if (SodiumConsole.tryLoadTextClass("net.minecraft.network.chat.Component", "literal", "Forge Component")) {
            return;
        }
        if (SodiumConsole.tryLoadObfuscatedTextClass()) {
            return;
        }
        try {
            textClass = Class.forName("net.minecraft.util.text.StringTextComponent");
            textOfMethod = null;
            textConstructor = textClass.getConstructor(String.class);
            SodiumConsole.log("Found legacy StringTextComponent class");
        }
        catch (Exception e) {
            SodiumConsole.log("Failed to find legacy StringTextComponent class: " + e.getMessage());
            textClass = null;
            textOfMethod = null;
            textConstructor = null;
            SodiumConsole.log("Could not find any text class");
        }
    }

    private static boolean tryLoadTextClass(String className, String methodName, String description) {
        try {
            textClass = Class.forName(className);
            textOfMethod = textClass.getMethod(methodName, String.class);
            textConstructor = null;
            SodiumConsole.log("Found " + description + " class");
            return true;
        }
        catch (Exception e) {
            SodiumConsole.log("Failed to find " + description + " class: " + e.getMessage());
            return false;
        }
    }

    private static boolean tryLoadObfuscatedTextClass() {
        try {
            textClass = Class.forName("net.minecraft.class_2561");
            SodiumConsole.log("Found obfuscated Text class");
            String[] methodNames = new String[]{"of", "method_10851", "literal"};
            for (String string : methodNames) {
                try {
                    textOfMethod = textClass.getMethod(string, String.class);
                    SodiumConsole.log("Found obfuscated Text." + string + " method");
                    return true;
                }
                catch (NoSuchMethodException e) {
                    SodiumConsole.log("No '" + string + "' method");
                }
            }
            SodiumConsole.log("Searching all methods in Text class");
            if (debugLogging) {
                for (Method method : textClass.getMethods()) {
                    SodiumConsole.log(" - " + method.getName() + ": " + (Method)method);
                }
            }
            for (Method method : textClass.getMethods()) {
                if (!Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(textClass) || method.getParameterCount() != 1 || !method.getParameterTypes()[0].equals(String.class)) continue;
                textOfMethod = method;
                SodiumConsole.log("Found potential text method: " + method.getName());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            SodiumConsole.log("Failed to find obfuscated Text class: " + e.getMessage());
            return false;
        }
    }

    private static Object getTextComponentViaReflection(String message) {
        try {
            Class<?> staticTextContentClass = Class.forName("net.minecraft.class_2585");
            Constructor<?> constructor = staticTextContentClass.getConstructor(String.class);
            return constructor.newInstance(message);
        }
        catch (Exception e) {
            try {
                try {
                    Class<?> obfTextClass = Class.forName("net.minecraft.class_2561");
                    for (Method method : obfTextClass.getMethods()) {
                        if (!Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(obfTextClass) || method.getParameterCount() != 1 || !method.getParameterTypes()[0].equals(String.class)) continue;
                        return method.invoke(null, message);
                    }
                }
                catch (Exception e2) {
                    return message;
                }
            }
            catch (Exception e2) {
                SodiumConsole.log("Error creating text component: " + e2.getMessage());
            }
            return message;
        }
    }

    private static Object createTextComponent(String message) {
        try {
            if (textClass == null) {
                return SodiumConsole.getTextComponentViaReflection(message);
            }
            if (textOfMethod != null) {
                return textOfMethod.invoke(null, message);
            }
            if (textConstructor != null) {
                return textConstructor.newInstance(message);
            }
            return SodiumConsole.getTextComponentViaReflection(message);
        }
        catch (Exception e) {
            SodiumConsole.log("Error creating text component: " + e.getMessage());
            return SodiumConsole.getTextComponentViaReflection(message);
        }
    }

    private static boolean tryInitialize(String consolePath, String consoleSinkPath, String messageLevelPath) {
        try {
            Class<?> consoleClass = Class.forName(consolePath);
            SodiumConsole.log("Found Console class: " + consolePath);
            Method instanceMethod = consoleClass.getMethod("instance", new Class[0]);
            SodiumConsole.log("Found instance method");
            consoleSink = instanceMethod.invoke(null, new Object[0]);
            SodiumConsole.log("Got Console instance");
            messageLevelClass = Class.forName(messageLevelPath);
            SodiumConsole.log("Found MessageLevel class: " + messageLevelPath);
            infoLevel = messageLevelClass.getField("INFO").get(null);
            warnLevel = messageLevelClass.getField("WARN").get(null);
            severeLevel = messageLevelClass.getField("SEVERE").get(null);
            SodiumConsole.log("Got message level constants");
            Class<?> consoleSinkClass = Class.forName(consoleSinkPath);
            SodiumConsole.log("Found ConsoleSink class: " + consoleSinkPath);
            if (debugLogging) {
                SodiumConsole.log("Available methods in " + consoleSinkPath + ":");
                for (Method method : consoleSinkClass.getMethods()) {
                    if (!method.getName().equals("logMessage") && !method.getName().equals("add")) continue;
                    SodiumConsole.log("  " + method.getName() + ": " + method);
                }
            }
            if (textClass != null && SodiumConsole.tryMethodSignature(consoleSinkClass, "logMessage", textClass, Integer.TYPE)) {
                useDoubleForFadeTimer = false;
                newSignature = false;
                SodiumConsole.log("Found int-based logMessage method");
                return true;
            }
            if (textClass != null && SodiumConsole.tryMethodSignature(consoleSinkClass, "logMessage", textClass, Double.TYPE)) {
                useDoubleForFadeTimer = true;
                newSignature = false;
                SodiumConsole.log("Found double-based logMessage method");
                return true;
            }
            if (SodiumConsole.tryMethodSignature(consoleSinkClass, "logMessage", String.class, Boolean.TYPE, Double.TYPE)) {
                useDoubleForFadeTimer = true;
                newSignature = true;
                SodiumConsole.log("Found newest logMessage method format");
                return true;
            }
            if (textClass != null && SodiumConsole.tryMethodSignature(consoleSinkClass, "add", textClass, Integer.TYPE)) {
                useDoubleForFadeTimer = false;
                newSignature = false;
                SodiumConsole.log("Found add method");
                return true;
            }
            SodiumConsole.log("No compatible methods found");
            return false;
        }
        catch (Exception e) {
            SodiumConsole.log("Error in tryInitialize: " + e.getMessage());
            return false;
        }
    }

    private static boolean tryMethodSignature(Class<?> consoleSinkClass, String methodName, Class<?> ... paramTypes) {
        try {
            Class[] fullParamTypes = new Class[paramTypes.length + 1];
            fullParamTypes[0] = messageLevelClass;
            System.arraycopy(paramTypes, 0, fullParamTypes, 1, paramTypes.length);
            logMessageMethod = consoleSinkClass.getMethod(methodName, fullParamTypes);
            sodiumAvailable = true;
            SodiumConsole.log("Found method: " + methodName + " with signature: " + Arrays.toString(paramTypes));
            return true;
        }
        catch (NoSuchMethodException e) {
            SodiumConsole.log("Method not found: " + methodName + " with signature: " + Arrays.toString(paramTypes));
            return false;
        }
    }

    public static boolean isSodiumAvailable() {
        if (!initialized) {
            SodiumConsole.initialize();
        }
        return sodiumAvailable;
    }

    public static void logMessage(int level, int messageFadeTimer, String message) {
        if (!initialized) {
            SodiumConsole.initialize();
        }
        if (!sodiumAvailable) {
            return;
        }
        try {
            Object messageLevel = SodiumConsole.getMessageLevel(level);
            if (newSignature) {
                double fadeTimerDouble = messageFadeTimer;
                boolean isPersistent = messageFadeTimer <= 0;
                logMessageMethod.invoke(consoleSink, messageLevel, message, isPersistent, fadeTimerDouble);
            } else if (useDoubleForFadeTimer) {
                double fadeTimerDouble = messageFadeTimer;
                logMessageMethod.invoke(consoleSink, messageLevel, SodiumConsole.createTextComponent(message), fadeTimerDouble);
            } else {
                logMessageMethod.invoke(consoleSink, messageLevel, SodiumConsole.createTextComponent(message), messageFadeTimer);
            }
        }
        catch (Exception e) {
            sodiumAvailable = false;
            SodiumConsole.log("Error logging message: " + e.getMessage());
        }
    }

    private static Object getMessageLevel(int level) {
        if (level == 1) {
            return infoLevel;
        }
        if (level == 2) {
            return warnLevel;
        }
        return severeLevel;
    }

    public static void enableDebugLogging() {
        debugLogging = true;
    }
}

