/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.parts;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.parts.EMFModelPart;
import traben.entity_model_features.utils.EMFUtils;

public abstract class EMFModelPartWithState
extends EMFModelPart {
    public final Int2ObjectOpenHashMap<EMFModelState> allKnownStateVariants = new Int2ObjectOpenHashMap<EMFModelState>(){

        public EMFModelState get(int k) {
            if (!this.containsKey(k)) {
                EMFUtils.logWarn("EMFModelState variant with key " + k + " does not exist in part [" + EMFModelPartWithState.this.toStringShort() + "], returning copy of 0");
                this.put(k, EMFModelState.copy(this.get(0)));
            }
            return (EMFModelState)super.get(k);
        }
    };
    public int currentModelVariant = 0;
    Map<String, ModelPart> vanillaChildren = new HashMap<String, ModelPart>();
    Runnable startOfRenderRunnable = null;
    @NotNull
    EMFModelPart.Animator animationHolder = new EMFModelPart.Animator();

    public EMFModelPartWithState(List<ModelPart.Cube> cuboids, Map<String, ModelPart> children) {
        super(cuboids, children);
    }

    void receiveOneTimeRunnable(Runnable run) {
        this.startOfRenderRunnable = run;
        this.children.values().forEach(child -> {
            if (child instanceof EMFModelPartWithState) {
                EMFModelPartWithState emf = (EMFModelPartWithState)((Object)child);
                emf.receiveOneTimeRunnable(run);
            }
        });
    }

    @Override
    public void render(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (this.startOfRenderRunnable != null) {
            this.startOfRenderRunnable.run();
        }
        if (this.animationHolder != null && !EMFAnimationEntityContext.isEntityAnimPausedWrapped()) {
            this.animationHolder.run();
        }
        super.render(matrices, vertices, light, overlay, red, green, blue, alpha);
    }

    EMFModelState getCurrentState() {
        return new EMFModelState(this.getInitialPose(), this.cubes, this.children, this.xScale, this.yScale, this.zScale, this.visible, this.skipDraw, this.textureOverride, this.animationHolder);
    }

    EMFModelState getStateOf(ModelPart modelPart) {
        if (modelPart instanceof EMFModelPartWithState) {
            EMFModelPartWithState emf = (EMFModelPartWithState)modelPart;
            return new EMFModelState(modelPart.getInitialPose(), modelPart.cubes, modelPart.children, modelPart.xScale, modelPart.yScale, modelPart.zScale, modelPart.visible, modelPart.skipDraw, emf.textureOverride, emf.animationHolder);
        }
        return new EMFModelState(modelPart.getInitialPose(), modelPart.cubes, new HashMap<String, ModelPart>(), modelPart.xScale, modelPart.yScale, modelPart.zScale, modelPart.visible, modelPart.skipDraw, null, new EMFModelPart.Animator());
    }

    void setFromState(EMFModelState newState) {
        this.setInitialPose(newState.defaultTransform());
        this.loadPose(this.getInitialPose());
        this.cubes = newState.cuboids();
        this.children = newState.variantChildren();
        this.xScale = newState.xScale();
        this.yScale = newState.yScale();
        this.zScale = newState.zScale();
        this.visible = newState.visible();
        this.skipDraw = newState.hidden();
        this.textureOverride = newState.texture();
        this.animationHolder = newState.animation();
    }

    protected void resetState() {
        this.setFromState((EMFModelState)this.allKnownStateVariants.get(this.currentModelVariant));
    }

    public void setVariantStateTo(int newVariant) {
        if (this.currentModelVariant != newVariant) {
            this.setFromState((EMFModelState)this.allKnownStateVariants.get(newVariant));
            this.currentModelVariant = newVariant;
            for (ModelPart part : this.children.values()) {
                if (!(part instanceof EMFModelPartWithState)) continue;
                EMFModelPartWithState p3 = (EMFModelPartWithState)part;
                p3.setVariantStateTo(newVariant);
            }
        }
    }

    public record EMFModelState(PartPose defaultTransform, List<ModelPart.Cube> cuboids, Map<String, ModelPart> variantChildren, float xScale, float yScale, float zScale, boolean visible, boolean hidden, ResourceLocation texture, EMFModelPart.Animator animation) {
        public static EMFModelState copy(EMFModelState copyFrom) {
            PartPose trans = copyFrom.defaultTransform();
            EMFModelPart.Animator animator = new EMFModelPart.Animator();
            animator.setAnimation(copyFrom.animation().getAnimation());
            return new EMFModelState(PartPose.offsetAndRotation((float)trans.x, (float)trans.y, (float)trans.z, (float)trans.xRot, (float)trans.yRot, (float)trans.zRot), new ArrayList<ModelPart.Cube>(copyFrom.cuboids()), new HashMap<String, ModelPart>(copyFrom.variantChildren()), copyFrom.xScale(), copyFrom.yScale(), copyFrom.zScale(), copyFrom.visible(), copyFrom.hidden(), copyFrom.texture(), animator);
        }
    }
}

