/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math;

import java.util.function.BooleanSupplier;
import traben.entity_model_features.models.animation.math.MathComponent;

public abstract class MathValue
implements MathComponent {
    public static final float TRUE = Float.POSITIVE_INFINITY;
    public static final float FALSE = Float.NEGATIVE_INFINITY;
    boolean isNegative;

    MathValue(boolean isNegative) {
        this.isNegative = isNegative;
    }

    MathValue() {
        this.isNegative = false;
    }

    public static float fromBoolean(boolean value) {
        return value ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
    }

    public static boolean toBoolean(float value) {
        if (value == Float.NEGATIVE_INFINITY) {
            return false;
        }
        if (value == Float.POSITIVE_INFINITY) {
            return true;
        }
        throw new IllegalArgumentException("Value [" + value + "] is not a boolean");
    }

    public static float validateBoolean(float value) {
        MathValue.toBoolean(value);
        return value;
    }

    public static float invertBoolean(boolean value) {
        return MathValue.fromBoolean(!value);
    }

    public static float invertBoolean(float value) {
        return MathValue.fromBoolean(!MathValue.toBoolean(value));
    }

    public static float invertBoolean(ResultSupplier value) {
        return MathValue.fromBoolean(!MathValue.toBoolean(value.get()));
    }

    public static float fromBoolean(BooleanSupplier value) {
        return MathValue.fromBoolean(value.getAsBoolean());
    }

    public static float invertBoolean(BooleanSupplier value) {
        return MathValue.invertBoolean(value.getAsBoolean());
    }

    public static boolean isBoolean(float value) {
        return value == Float.POSITIVE_INFINITY || value == Float.NEGATIVE_INFINITY;
    }

    abstract ResultSupplier getResultSupplier();

    @Override
    public float getResult() {
        return this.isNegative ? -this.getResultSupplier().get() : this.getResultSupplier().get();
    }

    public MathValue makeNegative() {
        this.isNegative = !this.isNegative;
        return this;
    }

    public static interface ResultSupplier {
        public float get();
    }
}

