/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.parts;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_630;
import net.minecraft.class_761;
import traben.entity_model_features.EMF;
import traben.entity_model_features.EMFManager;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mod_compat.IrisShadowPassDetection;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.parts.EMFModelPartCustom;
import traben.entity_model_features.models.parts.EMFModelPartRoot;
import traben.entity_model_features.models.parts.EMFModelPartVanilla;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFUtils2;
import traben.entity_texture_features.utils.ETFVertexConsumer;

public abstract class EMFModelPart
extends class_630 {
    public class_2960 textureOverride;
    protected long lastTextureOverride = -1L;
    public boolean isSetByAnimation = false;

    public EMFModelPart(List<class_630.class_628> cuboids, Map<String, class_630> children) {
        super(cuboids, children);
        this.field_3663 = new ObjectArrayList(cuboids);
        this.field_3661 = new Object2ObjectOpenHashMap(children);
    }

    public void method_22699(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        try {
            EMFConfig.RenderModeChoice choice = ((EMFConfig)EMF.config().getConfig()).getRenderModeFor(EMFAnimationEntityContext.getEMFEntity());
            if (choice == EMFConfig.RenderModeChoice.NORMAL) {
                this.renderWithTextureOverride(matrices, vertices, light, overlay, red, green, blue, alpha);
                return;
            }
            if (((EMFConfig)EMF.config().getConfig()).onlyDebugRenderOnHover && !EMFAnimationEntityContext.isClientHovered()) {
                this.renderWithTextureOverride(matrices, vertices, light, overlay, red, green, blue, alpha);
                return;
            }
            switch (choice) {
                case GREEN: {
                    this.renderDebugTinted(matrices, vertices, light, overlay, red, green, blue, alpha);
                    break;
                }
                case LINES: {
                    this.renderBoxes(matrices, class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23594()));
                    break;
                }
                case LINES_AND_TEXTURE: {
                    this.renderWithTextureOverride(matrices, vertices, light, overlay, red, green, blue, alpha);
                    this.renderBoxesNoChildren(matrices, class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23594()), 1.0f);
                    break;
                }
                case LINES_AND_TEXTURE_FLASH: {
                    this.renderWithTextureOverride(matrices, vertices, light, overlay, red, green, blue, alpha);
                    float flash = (class_3532.method_15374((float)((float)System.currentTimeMillis() / 1000.0f)) + 1.0f) / 2.0f;
                    this.renderBoxesNoChildren(matrices, class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23594()), flash);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderDebugTinted(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        float flash = Math.abs(class_3532.method_15374((float)((float)System.currentTimeMillis() / 1000.0f)));
        this.renderWithTextureOverride(matrices, vertices, light, overlay, flash, green, flash, alpha);
    }

    void renderWithTextureOverride(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (this.textureOverride == null || this.lastTextureOverride == EMFManager.getInstance().entityRenderCount) {
            this.renderLikeETF(matrices, vertices, light, overlay, red, green, blue, alpha);
        } else if (light != 0xF000F1 && !ETFRenderContext.isIsInSpecialRenderOverlayPhase()) {
            if (EMFAnimationEntityContext.getEMFEntity() != null && EMFAnimationEntityContext.getEMFEntity().etf$isBlockEntity() && ETF.IRIS_DETECTED && IrisShadowPassDetection.getInstance().inShadowPass()) {
                this.renderLikeETF(matrices, vertices, light, overlay, red, green, blue, alpha);
                return;
            }
            if (vertices instanceof ETFVertexConsumer) {
                ETFVertexConsumer etfVertexConsumer = (ETFVertexConsumer)vertices;
                ETFTexture etfTextureTest = etfVertexConsumer.etf$getETFTexture();
                if (etfTextureTest != null && etfTextureTest.thisIdentifier.equals((Object)this.textureOverride)) {
                    this.renderLikeETF(matrices, vertices, light, overlay, red, green, blue, alpha);
                    return;
                }
                class_1921 originalLayer = etfVertexConsumer.etf$getRenderLayer();
                if (originalLayer == null) {
                    return;
                }
                class_4597 provider = etfVertexConsumer.etf$getProvider();
                if (provider == null) {
                    return;
                }
                this.renderTextureOverrideWithoutReset(provider, matrices, light, overlay, red, green, blue, alpha);
                provider.getBuffer(originalLayer);
            } else {
                class_4597.class_4598 provider = class_310.method_1551().method_22940().method_23000();
                this.renderTextureOverrideWithoutReset((class_4597)provider, matrices, light, overlay, red, green, blue, alpha);
            }
        }
    }

    private void renderTextureOverrideWithoutReset(class_4597 provider, class_4587 matrices, int light, int overlay, float red, float green, float blue, float alpha) {
        this.lastTextureOverride = EMFManager.getInstance().entityRenderCount;
        class_1921 layerModified = EMFAnimationEntityContext.getLayerFromRecentFactoryOrETFOverrideOrTranslucent(this.textureOverride);
        class_4588 newConsumer = provider.getBuffer(layerModified);
        this.renderLikeVanilla(matrices, newConsumer, light, overlay, red, green, blue, alpha);
        if (newConsumer instanceof ETFVertexConsumer) {
            ETFVertexConsumer newETFConsumer = (ETFVertexConsumer)newConsumer;
            ETFTexture etfTexture = newETFConsumer.etf$getETFTexture();
            if (etfTexture == null) {
                return;
            }
            ETFUtils2.RenderMethodForOverlay renderMethodForOverlay = (prov, ligh) -> this.renderLikeVanilla(matrices, prov, ligh, overlay, red, green, blue, alpha);
            ETFUtils2.renderEmissive((ETFTexture)etfTexture, (class_4597)provider, (ETFUtils2.RenderMethodForOverlay)renderMethodForOverlay);
            ETFUtils2.renderEnchanted((ETFTexture)etfTexture, (class_4597)provider, (int)light, (ETFUtils2.RenderMethodForOverlay)renderMethodForOverlay);
        }
    }

    void renderLikeVanilla(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (!(!this.field_3665 || this.field_3663.isEmpty() && this.field_3661.isEmpty())) {
            matrices.method_22903();
            this.method_22703(matrices);
            if (!this.field_38456) {
                this.method_22702(matrices.method_23760(), vertices, light, overlay, red, green, blue, alpha);
            }
            for (class_630 modelPart : this.field_3661.values()) {
                modelPart.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha);
            }
            matrices.method_22909();
        }
    }

    void renderLikeETF(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        ETFRenderContext.incrementCurrentModelPartDepth();
        this.renderLikeVanilla(matrices, vertices, light, overlay, red, green, blue, alpha);
        if (ETFRenderContext.getCurrentModelPartDepth() != 1) {
            ETFRenderContext.decrementCurrentModelPartDepth();
        } else {
            ETFVertexConsumer etfVertexConsumer;
            ETFTexture texture;
            if (ETFRenderContext.isCurrentlyRenderingEntity() && vertices instanceof ETFVertexConsumer && (texture = (etfVertexConsumer = (ETFVertexConsumer)vertices).etf$getETFTexture()) != null && (texture.isEmissive() || texture.isEnchanted())) {
                ETFUtils2.RenderMethodForOverlay renderMethodForOverlay;
                class_4597 provider = etfVertexConsumer.etf$getProvider();
                class_1921 layer = etfVertexConsumer.etf$getRenderLayer();
                if (provider != null && layer != null && ETFUtils2.renderEmissive((ETFTexture)texture, (class_4597)provider, (ETFUtils2.RenderMethodForOverlay)(renderMethodForOverlay = (prov, ligh) -> this.renderLikeVanilla(matrices, prov, ligh, overlay, red, green, blue, alpha))) | ETFUtils2.renderEnchanted((ETFTexture)texture, (class_4597)provider, (int)light, (ETFUtils2.RenderMethodForOverlay)renderMethodForOverlay)) {
                    provider.getBuffer(layer);
                }
            }
            ETFRenderContext.resetCurrentModelPartDepth();
        }
    }

    public void renderBoxes(class_4587 matrices, class_4588 vertices) {
        if (!(!this.field_3665 || this.field_3663.isEmpty() && this.field_3661.isEmpty())) {
            matrices.method_22903();
            this.method_22703(matrices);
            if (!this.field_38456) {
                for (class_630.class_628 cuboid : this.field_3663) {
                    class_238 box = new class_238((double)(cuboid.field_3645 / 16.0f), (double)(cuboid.field_3644 / 16.0f), (double)(cuboid.field_3643 / 16.0f), (double)(cuboid.field_3648 / 16.0f), (double)(cuboid.field_3647 / 16.0f), (double)(cuboid.field_3646 / 16.0f));
                    float[] col = this.debugBoxColor();
                    class_761.method_22982((class_4587)matrices, (class_4588)vertices, (class_238)box.method_1014(1.0E-4), (float)col[0], (float)col[1], (float)col[2], (float)1.0f);
                }
            }
            for (class_630 modelPart : this.field_3661.values()) {
                if (!(modelPart instanceof EMFModelPart)) continue;
                EMFModelPart emf = (EMFModelPart)modelPart;
                emf.renderBoxes(matrices, vertices);
            }
            matrices.method_22909();
        }
    }

    protected abstract float[] debugBoxColor();

    public void renderBoxesNoChildren(class_4587 matrices, class_4588 vertices, float alpha) {
        if (!(!this.field_3665 || this.field_3663.isEmpty() && this.field_3661.isEmpty())) {
            matrices.method_22903();
            this.method_22703(matrices);
            if (!this.field_38456) {
                for (class_630.class_628 cuboid : this.field_3663) {
                    class_238 box = new class_238((double)(cuboid.field_3645 / 16.0f), (double)(cuboid.field_3644 / 16.0f), (double)(cuboid.field_3643 / 16.0f), (double)(cuboid.field_3648 / 16.0f), (double)(cuboid.field_3647 / 16.0f), (double)(cuboid.field_3646 / 16.0f));
                    float[] col = this.debugBoxColor();
                    class_761.method_22982((class_4587)matrices, (class_4588)vertices, (class_238)box.method_1014(1.0E-4), (float)col[0], (float)col[1], (float)col[2], (float)alpha);
                }
            }
            matrices.method_22909();
        }
    }

    public void method_22702(class_4587.class_4665 pose, class_4588 vertexConsumer, int i, int j, float red, float green, float blue, float alpha) {
        for (class_630.class_628 cuboid : this.field_3663) {
            cuboid.method_32089(pose, vertexConsumer, i, j, red, green, blue, alpha);
        }
    }

    public String simplePrintChildren(int depth) {
        StringBuilder mapper = new StringBuilder();
        mapper.append("\n  | ");
        mapper.append("- ".repeat(Math.max(0, depth)));
        mapper.append(this.toStringShort());
        for (class_630 child : this.field_3661.values()) {
            if (!(child instanceof EMFModelPart)) continue;
            EMFModelPart emf = (EMFModelPart)child;
            mapper.append(emf.simplePrintChildren(depth + 1));
        }
        return mapper.toString();
    }

    public String toStringShort() {
        return this.toString();
    }

    public String toString() {
        return "generic emf part";
    }

    public class_630 getVanillaModelPartsOfCurrentState() {
        HashMap<String, class_630> children = new HashMap<String, class_630>();
        for (Map.Entry child : this.field_3661.entrySet()) {
            Object v = child.getValue();
            if (!(v instanceof EMFModelPart)) continue;
            EMFModelPart emf = (EMFModelPart)((Object)v);
            children.put((String)child.getKey(), emf.getVanillaModelPartsOfCurrentState());
        }
        List<class_630.class_628> finalCubes = this.field_3663.isEmpty() ? List.of(new class_630.class_628(0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, 0.0f, 0.0f, Set.of())) : this.field_3663;
        class_630 part = new class_630((List)finalCubes, children);
        part.method_41918(this.method_41921());
        part.field_3654 = this.field_3654;
        part.field_3674 = this.field_3674;
        part.field_3675 = this.field_3675;
        part.field_3655 = this.field_3655;
        part.field_3656 = this.field_3656;
        part.field_3657 = this.field_3657;
        part.field_37938 = this.field_37938;
        part.field_37939 = this.field_37939;
        part.field_37940 = this.field_37940;
        return part;
    }

    public Object2ReferenceOpenHashMap<String, EMFModelPart> getAllChildPartsAsAnimationMap(String prefixableParents, int variantNum, Map<String, String> optifinePartNameMap) {
        Object object = this;
        if (object instanceof EMFModelPartRoot) {
            EMFModelPartRoot root = (EMFModelPartRoot)((Object)object);
            root.setVariantStateTo(variantNum);
        }
        Object2ReferenceOpenHashMap mapOfAll = new Object2ReferenceOpenHashMap();
        for (class_630 part : this.field_3661.values()) {
            if (!(part instanceof EMFModelPart)) continue;
            EMFModelPart emfPart = (EMFModelPart)part;
            String thisKey = "NULL_KEY_NAME";
            boolean addThis = false;
            if (part instanceof EMFModelPartCustom) {
                EMFModelPartCustom partCustom = (EMFModelPartCustom)part;
                thisKey = partCustom.id;
                addThis = true;
            } else if (part instanceof EMFModelPartVanilla) {
                EMFModelPartVanilla partVanilla = (EMFModelPartVanilla)part;
                thisKey = partVanilla.name;
                addThis = partVanilla.isOptiFinePartSpecified;
            }
            for (Map.Entry<String, String> entry : optifinePartNameMap.entrySet()) {
                if (!entry.getValue().equals(thisKey)) continue;
                thisKey = entry.getKey();
                break;
            }
            if (addThis) {
                mapOfAll.putIfAbsent((Object)thisKey, (Object)emfPart);
                if (prefixableParents.isBlank()) {
                    mapOfAll.putAll(emfPart.getAllChildPartsAsAnimationMap(thisKey, variantNum, optifinePartNameMap));
                    continue;
                }
                mapOfAll.putIfAbsent((Object)(prefixableParents + ":" + thisKey), (Object)emfPart);
                mapOfAll.putAll(emfPart.getAllChildPartsAsAnimationMap(prefixableParents + ":" + thisKey, variantNum, optifinePartNameMap));
                continue;
            }
            mapOfAll.putAll(emfPart.getAllChildPartsAsAnimationMap(prefixableParents, variantNum, optifinePartNameMap));
        }
        return mapOfAll;
    }

    public static class Animator
    implements Runnable {
        private Runnable animation = null;

        Animator() {
        }

        public boolean hasAnimation() {
            return this.animation != null;
        }

        public Runnable getAnimation() {
            return this.animation;
        }

        public void setAnimation(Runnable animation) {
            this.animation = animation;
        }

        @Override
        public void run() {
            if (this.animation != null) {
                this.animation.run();
            }
        }
    }
}

