/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.parts;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.model.geom.ModelPart;
import traben.entity_model_features.EMF;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.parts.EMFModelPartCustom;
import traben.entity_model_features.models.parts.EMFModelPartWithState;
import traben.entity_model_features.utils.EMFUtils;

public class EMFModelPartVanilla
extends EMFModelPartWithState {
    final String name;
    final boolean isOptiFinePartSpecified;
    final Set<Integer> hideInTheseStates = new HashSet<Integer>();

    public EMFModelPartVanilla(String name, ModelPart vanillaPart, Collection<String> optifinePartNames, Map<String, EMFModelPartVanilla> allVanillaParts) {
        super(new ArrayList<ModelPart.Cube>(), new HashMap<String, ModelPart>());
        this.name = name;
        if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
            EMFUtils.log(" > EMF vanilla part made: " + name);
        }
        this.isOptiFinePartSpecified = optifinePartNames.contains(name);
        this.setFromState(this.getStateOf(vanillaPart));
        for (Map.Entry child : vanillaPart.children.entrySet()) {
            EMFModelPartVanilla vanilla = new EMFModelPartVanilla((String)child.getKey(), (ModelPart)child.getValue(), optifinePartNames, allVanillaParts);
            this.children.put((String)child.getKey(), vanilla);
            allVanillaParts.put((String)child.getKey(), vanilla);
        }
        this.vanillaChildren = this.children;
        this.allKnownStateVariants.put(0, (Object)this.getCurrentState());
    }

    public ModelPart[] getAllEMFCustomChildren() {
        return (ModelPart[])this.children.values().stream().filter(part -> part instanceof EMFModelPartCustom).toArray(ModelPart[]::new);
    }

    @Override
    protected float[] debugBoxColor() {
        return new float[]{0.0f, 1.0f, 0.0f};
    }

    @Override
    public void render(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (!this.hideInTheseStates.contains(this.currentModelVariant)) {
            super.render(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }

    public void setHideInTheseStates(int variant) {
        this.hideInTheseStates.add(variant);
        this.children.values().forEach(part -> {
            if (part instanceof EMFModelPartVanilla) {
                EMFModelPartVanilla vanilla = (EMFModelPartVanilla)((Object)part);
                if (!vanilla.isOptiFinePartSpecified) {
                    vanilla.setHideInTheseStates(variant);
                }
            }
        });
    }

    public void receiveRootAnimationRunnable(int variant, Runnable run) {
        ((EMFModelPartWithState.EMFModelState)this.allKnownStateVariants.get(variant)).animation().setAnimation(run);
    }

    @Override
    public String toString() {
        return "[vanilla part " + this.name + "], cubes =" + this.cubes.size() + ", children = " + this.children.size();
    }

    @Override
    public String toStringShort() {
        return "[vanilla part " + this.name + "]";
    }
}

