/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_310;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_630;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.EMF;
import traben.entity_model_features.EMFManager;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.EMFModel_ID;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_model_features.utils.IEMFCuboidDataSupplier;
import traben.entity_model_features.utils.IEMFTextureSizeSupplier;
import traben.entity_model_features.utils.IEMFUnmodifiedLayerRootGetter;
import traben.entity_texture_features.ETF;

public class EMFModelMappings {
    public static final Map<String, Map<String, String>> UNKNOWN_MODEL_MAP_CACHE = new HashMap<String, Map<String, String>>();
    public static final Map<String, Map<String, String>> OPTIFINE_MODEL_MAP_CACHE = new HashMap<String, Map<String, String>>();
    public static final Map<String, String> genericNonPlayerBiped = Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("headwear", "hat"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("left_arm"), EMFModelMappings.partMapping("right_arm"), EMFModelMappings.partMapping("left_leg"), EMFModelMappings.partMapping("right_leg"));

    private static void initOptifineMappings() {
        Map<String, String> genericHorse = Map.ofEntries(EMFModelMappings.partMapping("body", "body"), EMFModelMappings.partMapping("head", "head"), EMFModelMappings.partMapping("tail"), EMFModelMappings.partMapping("mane"), EMFModelMappings.partMapping("mouth", "upper_mouth"), EMFModelMappings.partMapping("left_ear"), EMFModelMappings.partMapping("right_ear"), EMFModelMappings.partMapping("neck", "head_parts"), EMFModelMappings.partMapping("back_left_leg", "left_hind_leg"), EMFModelMappings.partMapping("back_right_leg", "right_hind_leg"), EMFModelMappings.partMapping("front_left_leg", "left_front_leg"), EMFModelMappings.partMapping("front_right_leg", "right_front_leg"));
        Map genericHorseSaddle = Map.ofEntries(EMFModelMappings.partMapping("body", "body"), EMFModelMappings.partMapping("head", "head"), EMFModelMappings.partMapping("tail"), EMFModelMappings.partMapping("saddle"), EMFModelMappings.partMapping("mane"), EMFModelMappings.partMapping("mouth", "upper_mouth"), EMFModelMappings.partMapping("left_ear"), EMFModelMappings.partMapping("right_ear"), EMFModelMappings.partMapping("neck", "head_parts"), EMFModelMappings.partMapping("noseband", "mouth_saddle_wrap"), EMFModelMappings.partMapping("headpiece", "head_saddle"), EMFModelMappings.partMapping("right_rein", "right_saddle_line"), EMFModelMappings.partMapping("left_rein", "left_saddle_line"), EMFModelMappings.partMapping("right_bit", "right_saddle_mouth"), EMFModelMappings.partMapping("left_bit", "left_saddle_mouth"), EMFModelMappings.partMapping("back_left_leg", "left_hind_leg"), EMFModelMappings.partMapping("back_right_leg", "right_hind_leg"), EMFModelMappings.partMapping("front_left_leg", "left_front_leg"), EMFModelMappings.partMapping("front_right_leg", "right_front_leg"));
        Map<String, String> genericPlayerBiped = Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("headwear", "hat"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("left_arm"), EMFModelMappings.partMapping("right_arm"), EMFModelMappings.partMapping("left_leg"), EMFModelMappings.partMapping("right_leg"), EMFModelMappings.partMapping("ear"), EMFModelMappings.partMapping("left_sleeve"), EMFModelMappings.partMapping("right_sleeve"), EMFModelMappings.partMapping("left_pants"), EMFModelMappings.partMapping("right_pants"), EMFModelMappings.partMapping("jacket"), EMFModelMappings.partMapping("cloak"));
        Map<String, String> genericPiglinBiped = Map.ofEntries(EMFModelMappings.partMapping("head", "head"), EMFModelMappings.partMapping("headwear", "hat"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("left_arm"), EMFModelMappings.partMapping("right_arm"), EMFModelMappings.partMapping("left_leg"), EMFModelMappings.partMapping("ear"), EMFModelMappings.partMapping("right_leg"), EMFModelMappings.partMapping("left_ear"), EMFModelMappings.partMapping("right_ear"), EMFModelMappings.partMapping("left_sleeve"), EMFModelMappings.partMapping("right_sleeve"), EMFModelMappings.partMapping("left_pants"), EMFModelMappings.partMapping("right_pants"), EMFModelMappings.partMapping("jacket"), EMFModelMappings.partMapping("cloak"));
        Map<String, String> genericQuadraped = Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("leg1", "right_hind_leg"), EMFModelMappings.partMapping("leg2", "left_hind_leg"), EMFModelMappings.partMapping("leg3", "right_front_leg"), EMFModelMappings.partMapping("leg4", "left_front_leg"));
        HashMap<String, String> genericLlama = new HashMap<String, String>(genericQuadraped){
            {
                this.putAll(Map.ofEntries(EMFModelMappings.partMapping("chest_left", "left_chest"), EMFModelMappings.partMapping("chest_right", "right_chest")));
            }
        };
        OptifineMapper.models("villager", "wandering_trader").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("headwear", "hat"), EMFModelMappings.partMapping("headwear2", "hat_rim"), EMFModelMappings.partMapping("bodywear", "jacket"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("arms"), EMFModelMappings.partMapping("right_leg"), EMFModelMappings.partMapping("left_leg"), EMFModelMappings.partMapping("nose")));
        OptifineMapper.models("iron_golem").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("left_arm"), EMFModelMappings.partMapping("right_arm"), EMFModelMappings.partMapping("left_leg"), EMFModelMappings.partMapping("right_leg")));
        OptifineMapper.models("spider", "cave_spider").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("neck", "body0"), EMFModelMappings.partMapping("body", "body1"), EMFModelMappings.partMapping("leg1", "right_hind_leg"), EMFModelMappings.partMapping("leg2", "left_hind_leg"), EMFModelMappings.partMapping("leg3", "right_middle_hind_leg"), EMFModelMappings.partMapping("leg4", "left_middle_hind_leg"), EMFModelMappings.partMapping("leg5", "right_middle_front_leg"), EMFModelMappings.partMapping("leg6", "left_middle_front_leg"), EMFModelMappings.partMapping("leg7", "right_front_leg"), EMFModelMappings.partMapping("leg8", "left_front_leg")));
        OptifineMapper.models("sheep", "cow", "warm_cow", "mooshroom", "panda", "pig", "cold_pig", "warm_pig", "pig_saddle", "polar_bear", "sheep_wool", "sheep_wool_undercoat", "sheep_baby_wool_undercoat").parts(genericQuadraped);
        OptifineMapper.models("cold_cow").parts((Map<String, String>)new HashMap<String, String>(genericQuadraped){
            {
                this.putAll(Map.ofEntries(EMFModelMappings.partMapping("right_horn"), EMFModelMappings.partMapping("left_horn")));
            }
        });
        OptifineMapper.models("creeper", "creeper_charge").parts(genericQuadraped);
        OptifineMapper.models("inner_armor", "outer_armor", "zombie", "husk", "drowned", "drowned_outer", "enderman", "giant", "skeleton", "stray", "stray_outer", "wither_skeleton", "zombie_pigman", "bogged_outer", "helmet", "helmet_baby", "chestplate", "chestplate_baby", "leggings", "leggings_baby", "boots", "boots_baby").parts(genericNonPlayerBiped);
        OptifineMapper.models("piglin", "piglin_brute", "zombified_piglin").parts(genericPiglinBiped);
        OptifineMapper.models("allay", "vex").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("left_arm"), EMFModelMappings.partMapping("right_arm"), EMFModelMappings.partMapping("left_wing"), EMFModelMappings.partMapping("right_wing")));
        OptifineMapper.models("squid", "glow_squid").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("tentacle1", "tentacle0"), EMFModelMappings.partMapping("tentacle2", "tentacle1"), EMFModelMappings.partMapping("tentacle3", "tentacle2"), EMFModelMappings.partMapping("tentacle4", "tentacle3"), EMFModelMappings.partMapping("tentacle5", "tentacle4"), EMFModelMappings.partMapping("tentacle6", "tentacle5"), EMFModelMappings.partMapping("tentacle7", "tentacle6"), EMFModelMappings.partMapping("tentacle8", "tentacle7")));
        OptifineMapper.models("ghast").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("tentacle1", "tentacle0"), EMFModelMappings.partMapping("tentacle2", "tentacle1"), EMFModelMappings.partMapping("tentacle3", "tentacle2"), EMFModelMappings.partMapping("tentacle4", "tentacle3"), EMFModelMappings.partMapping("tentacle5", "tentacle4"), EMFModelMappings.partMapping("tentacle6", "tentacle5"), EMFModelMappings.partMapping("tentacle7", "tentacle6"), EMFModelMappings.partMapping("tentacle8", "tentacle7"), EMFModelMappings.partMapping("tentacle9", "tentacle8")));
        OptifineMapper.models("happy_ghast", "happy_ghast_ropes").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("tentacle1", "tentacle0"), EMFModelMappings.partMapping("tentacle2", "tentacle1"), EMFModelMappings.partMapping("tentacle3", "tentacle2"), EMFModelMappings.partMapping("tentacle4", "tentacle3"), EMFModelMappings.partMapping("tentacle5", "tentacle4"), EMFModelMappings.partMapping("tentacle6", "tentacle5"), EMFModelMappings.partMapping("tentacle7", "tentacle6"), EMFModelMappings.partMapping("tentacle8", "tentacle7"), EMFModelMappings.partMapping("tentacle9", "tentacle8")));
        OptifineMapper.models("happy_ghast_baby", "happy_ghast_baby_ropes").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("inner_body"), EMFModelMappings.partMapping("tentacle1", "tentacle0"), EMFModelMappings.partMapping("tentacle2", "tentacle1"), EMFModelMappings.partMapping("tentacle3", "tentacle2"), EMFModelMappings.partMapping("tentacle4", "tentacle3"), EMFModelMappings.partMapping("tentacle5", "tentacle4"), EMFModelMappings.partMapping("tentacle6", "tentacle5"), EMFModelMappings.partMapping("tentacle7", "tentacle6"), EMFModelMappings.partMapping("tentacle8", "tentacle7"), EMFModelMappings.partMapping("tentacle9", "tentacle8")));
        OptifineMapper.models("happy_ghast_harness", "happy_ghast_baby_harness").parts(Map.ofEntries(EMFModelMappings.partMapping("harness"), EMFModelMappings.partMapping("goggles")));
        OptifineMapper.models("wolf", "wolf_collar", "wolf_armor").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("tail"), EMFModelMappings.partMapping("mane", "upper_body"), EMFModelMappings.partMapping("leg1", "right_hind_leg"), EMFModelMappings.partMapping("leg2", "left_hind_leg"), EMFModelMappings.partMapping("leg3", "right_front_leg"), EMFModelMappings.partMapping("leg4", "left_front_leg")));
        OptifineMapper.models("shulker_bullet").parts(Map.ofEntries(EMFModelMappings.partMapping("bullet", "main")));
        OptifineMapper.models("llama_spit").parts(Map.ofEntries(EMFModelMappings.partMapping("body", "main")));
        OptifineMapper.models("wither_skull", "head_zombie", "head_wither_skeleton", "head_skeleton", "head_player", "head_creeper").parts(Map.ofEntries(EMFModelMappings.partMapping("head")));
        OptifineMapper.models("head_piglin").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("left_ear"), EMFModelMappings.partMapping("right_ear")));
        OptifineMapper.models("head_dragon").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("jaw")));
        OptifineMapper.models("camel").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("hump"), EMFModelMappings.partMapping("tail"), EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("left_ear"), EMFModelMappings.partMapping("right_ear"), EMFModelMappings.partMapping("back_left_leg", "left_hind_leg"), EMFModelMappings.partMapping("back_right_leg", "right_hind_leg"), EMFModelMappings.partMapping("front_left_leg", "left_front_leg"), EMFModelMappings.partMapping("front_right_leg", "right_front_leg"), EMFModelMappings.partMapping("saddle"), EMFModelMappings.partMapping("reins"), EMFModelMappings.partMapping("bridle")));
        OptifineMapper.models("sniffer").parts(Map.ofEntries(EMFModelMappings.partMapping("bone"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("front_right_leg", "right_front_leg"), EMFModelMappings.partMapping("middle_right_leg", "right_mid_leg"), EMFModelMappings.partMapping("back_right_leg", "right_hind_leg"), EMFModelMappings.partMapping("front_left_leg", "left_front_leg"), EMFModelMappings.partMapping("middle_left_leg", "left_mid_leg"), EMFModelMappings.partMapping("back_left_leg", "left_hind_leg"), EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("left_ear"), EMFModelMappings.partMapping("right_ear"), EMFModelMappings.partMapping("nose"), EMFModelMappings.partMapping("lower_beak")));
        OptifineMapper.models("chest", "ender_chest", "trapped_chest", "chest_left", "trapped_chest_left", "chest_right", "trapped_chest_right").parts(Map.ofEntries(EMFModelMappings.partMapping("lid"), EMFModelMappings.partMapping("base", "bottom"), EMFModelMappings.partMapping("knob", "lock")));
        OptifineMapper.models("double_chest_right", "trapped_double_chest_right", "ender_double_chest_right").parts(Map.ofEntries(EMFModelMappings.partMapping("lid"), EMFModelMappings.partMapping("base", "bottom"), EMFModelMappings.partMapping("knob", "lock")));
        OptifineMapper.models("double_chest_left", "trapped_double_chest_left", "ender_double_chest_left").parts(Map.ofEntries(EMFModelMappings.partMapping("lid"), EMFModelMappings.partMapping("base", "bottom"), EMFModelMappings.partMapping("knob", "lock")));
        OptifineMapper.models("horse", "horse_armor", "skeleton_horse", "zombie_horse").parts(genericHorse);
        OptifineMapper.models("donkey", "mule").parts((Map<String, String>)new HashMap<String, String>(genericHorse){
            {
                this.putAll(Map.ofEntries(EMFModelMappings.partMapping("right_chest"), EMFModelMappings.partMapping("left_chest"), EMFModelMappings.partMapping("body")));
            }
        });
        OptifineMapper.models("horse_saddle", "mule_saddle", "donkey_saddle", "skeleton_horse_saddle", "zombie_horse_saddle").parts(new HashMap<String, String>(genericHorseSaddle));
        OptifineMapper.models("zombie_villager").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("headwear", "hat"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("left_arm"), EMFModelMappings.partMapping("right_arm"), EMFModelMappings.partMapping("left_leg"), EMFModelMappings.partMapping("right_leg")));
        OptifineMapper.models("evoker", "illusioner", "pillager", "vindicator").parts(Map.ofEntries(EMFModelMappings.partMapping("head", "head"), EMFModelMappings.partMapping("headwear", "hat"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("nose"), EMFModelMappings.partMapping("arms"), EMFModelMappings.partMapping("left_arm"), EMFModelMappings.partMapping("right_arm"), EMFModelMappings.partMapping("left_leg"), EMFModelMappings.partMapping("right_leg")));
        OptifineMapper.models("llama", "llama_decor", "trader_llama", "trader_llama_decor").parts((Map<String, String>)genericLlama);
        OptifineMapper.models("armor_stand", "armor_stand_small").parts((Map<String, String>)new HashMap<String, String>(genericNonPlayerBiped){
            {
                this.putAll(Map.ofEntries(EMFModelMappings.partMapping("right", "right_body_stick"), EMFModelMappings.partMapping("left", "left_body_stick"), EMFModelMappings.partMapping("waist", "shoulder_stick"), EMFModelMappings.partMapping("base", "base_plate")));
            }
        });
        OptifineMapper.models("axolotl").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("leg1", "right_hind_leg"), EMFModelMappings.partMapping("leg2", "left_hind_leg"), EMFModelMappings.partMapping("leg3", "right_front_leg"), EMFModelMappings.partMapping("leg4", "left_front_leg"), EMFModelMappings.partMapping("right_gills"), EMFModelMappings.partMapping("top_gills"), EMFModelMappings.partMapping("left_gills"), EMFModelMappings.partMapping("tail")));
        OptifineMapper.models("bat").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("right_wing"), EMFModelMappings.partMapping("left_wing"), EMFModelMappings.partMapping("outer_right_wing", "right_wing_tip"), EMFModelMappings.partMapping("outer_left_wing", "left_wing_tip"), EMFModelMappings.partMapping("feet")));
        OptifineMapper.models("bee").parts(Map.ofEntries(EMFModelMappings.partMapping("body", "bone"), EMFModelMappings.partMapping("torso", "body"), EMFModelMappings.partMapping("right_wing"), EMFModelMappings.partMapping("left_wing"), EMFModelMappings.partMapping("front_legs"), EMFModelMappings.partMapping("middle_legs"), EMFModelMappings.partMapping("back_legs"), EMFModelMappings.partMapping("stinger"), EMFModelMappings.partMapping("left_antenna"), EMFModelMappings.partMapping("right_antenna")));
        OptifineMapper.models("blaze").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("stick1", "part0"), EMFModelMappings.partMapping("stick2", "part1"), EMFModelMappings.partMapping("stick3", "part2"), EMFModelMappings.partMapping("stick4", "part3"), EMFModelMappings.partMapping("stick5", "part4"), EMFModelMappings.partMapping("stick6", "part5"), EMFModelMappings.partMapping("stick7", "part6"), EMFModelMappings.partMapping("stick8", "part7"), EMFModelMappings.partMapping("stick9", "part8"), EMFModelMappings.partMapping("stick10", "part9"), EMFModelMappings.partMapping("stick11", "part10"), EMFModelMappings.partMapping("stick12", "part11")));
        OptifineMapper.models("cat", "cat_collar", "ocelot").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("tail", "tail1"), EMFModelMappings.partMapping("tail2"), EMFModelMappings.partMapping("back_left_leg", "left_hind_leg"), EMFModelMappings.partMapping("back_right_leg", "right_hind_leg"), EMFModelMappings.partMapping("front_left_leg", "left_front_leg"), EMFModelMappings.partMapping("front_right_leg", "right_front_leg")));
        OptifineMapper.models("chicken", "warm_chicken", "cold_chicken").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("right_leg"), EMFModelMappings.partMapping("left_leg"), EMFModelMappings.partMapping("right_wing"), EMFModelMappings.partMapping("left_wing"), EMFModelMappings.partMapping("bill", "beak"), EMFModelMappings.partMapping("chin", "red_thing")));
        OptifineMapper.models("cod").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("nose"), EMFModelMappings.partMapping("tail", "tail_fin"), EMFModelMappings.partMapping("fin_right", "right_fin"), EMFModelMappings.partMapping("fin_left", "left_fin"), EMFModelMappings.partMapping("fin_back", "top_fin")));
        OptifineMapper.models("dolphin").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("tail"), EMFModelMappings.partMapping("tail_fin"), EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("right_fin"), EMFModelMappings.partMapping("left_fin"), EMFModelMappings.partMapping("back_fin")));
        OptifineMapper.models("elder_guardian", "guardian").parts(Map.ofEntries(EMFModelMappings.partMapping("tail1", "tail0"), EMFModelMappings.partMapping("tail2", "tail1"), EMFModelMappings.partMapping("tail3", "tail2"), EMFModelMappings.partMapping("body", "head"), EMFModelMappings.partMapping("eye"), EMFModelMappings.partMapping("spine1", "spike0"), EMFModelMappings.partMapping("spine2", "spike1"), EMFModelMappings.partMapping("spine3", "spike2"), EMFModelMappings.partMapping("spine4", "spike3"), EMFModelMappings.partMapping("spine5", "spike4"), EMFModelMappings.partMapping("spine6", "spike5"), EMFModelMappings.partMapping("spine7", "spike6"), EMFModelMappings.partMapping("spine8", "spike7"), EMFModelMappings.partMapping("spine9", "spike8"), EMFModelMappings.partMapping("spine10", "spike9"), EMFModelMappings.partMapping("spine11", "spike10"), EMFModelMappings.partMapping("spine12", "spike11")));
        OptifineMapper.models("endermite").parts(Map.ofEntries(EMFModelMappings.partMapping("body1", "segment0"), EMFModelMappings.partMapping("body2", "segment1"), EMFModelMappings.partMapping("body3", "segment2"), EMFModelMappings.partMapping("body4", "segment3")));
        OptifineMapper.models("evoker_fangs").parts(Map.ofEntries(EMFModelMappings.partMapping("base"), EMFModelMappings.partMapping("upper_jaw"), EMFModelMappings.partMapping("lower_jaw")));
        OptifineMapper.models("fox").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("leg1", "right_hind_leg"), EMFModelMappings.partMapping("leg2", "left_hind_leg"), EMFModelMappings.partMapping("leg3", "right_front_leg"), EMFModelMappings.partMapping("leg4", "left_front_leg"), EMFModelMappings.partMapping("tail")));
        OptifineMapper.models("frog").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("left_leg"), EMFModelMappings.partMapping("right_leg"), EMFModelMappings.partMapping("croaking_body"), EMFModelMappings.partMapping("left_arm"), EMFModelMappings.partMapping("right_arm"), EMFModelMappings.partMapping("tongue"), EMFModelMappings.partMapping("eyes")));
        OptifineMapper.models("goat").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("leg1", "right_hind_leg"), EMFModelMappings.partMapping("leg2", "left_hind_leg"), EMFModelMappings.partMapping("leg3", "right_front_leg"), EMFModelMappings.partMapping("leg4", "left_front_leg"), EMFModelMappings.partMapping("left_horn"), EMFModelMappings.partMapping("right_horn"), EMFModelMappings.partMapping("nose")));
        OptifineMapper.models("hoglin", "zoglin").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("back_right_leg", "right_hind_leg"), EMFModelMappings.partMapping("back_left_leg", "left_hind_leg"), EMFModelMappings.partMapping("front_right_leg", "right_front_leg"), EMFModelMappings.partMapping("front_left_leg", "left_front_leg"), EMFModelMappings.partMapping("mane"), EMFModelMappings.partMapping("left_ear"), EMFModelMappings.partMapping("right_ear")));
        OptifineMapper.models("magma_cube").parts(Map.ofEntries(EMFModelMappings.partMapping("core", "inside_cube"), EMFModelMappings.partMapping("segment1", "cube0"), EMFModelMappings.partMapping("segment2", "cube1"), EMFModelMappings.partMapping("segment3", "cube2"), EMFModelMappings.partMapping("segment4", "cube3"), EMFModelMappings.partMapping("segment5", "cube4"), EMFModelMappings.partMapping("segment6", "cube5"), EMFModelMappings.partMapping("segment7", "cube6"), EMFModelMappings.partMapping("segment8", "cube7")));
        OptifineMapper.models("phantom").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("tail", "tail_base"), EMFModelMappings.partMapping("tail2", "tail_tip"), EMFModelMappings.partMapping("left_wing", "left_wing_base"), EMFModelMappings.partMapping("right_wing", "right_wing_base"), EMFModelMappings.partMapping("left_wing_tip"), EMFModelMappings.partMapping("right_wing_tip")));
        OptifineMapper.models("parrot").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("tail"), EMFModelMappings.partMapping("left_wing"), EMFModelMappings.partMapping("right_wing"), EMFModelMappings.partMapping("left_leg"), EMFModelMappings.partMapping("right_leg")));
        OptifineMapper.models("puffer_fish_big").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("fin_right", "right_blue_fin"), EMFModelMappings.partMapping("fin_left", "left_blue_fin"), EMFModelMappings.partMapping("spikes_front_top", "top_front_fin"), EMFModelMappings.partMapping("spikes_middle_top", "top_middle_fin"), EMFModelMappings.partMapping("spikes_back_top", "top_back_fin"), EMFModelMappings.partMapping("spikes_front_right", "right_front_fin"), EMFModelMappings.partMapping("spikes_front_left", "left_front_fin"), EMFModelMappings.partMapping("spikes_front_bottom", "bottom_front_fin"), EMFModelMappings.partMapping("spikes_middle_bottom", "bottom_middle_fin"), EMFModelMappings.partMapping("spikes_back_bottom", "bottom_back_fin"), EMFModelMappings.partMapping("spikes_back_right", "right_back_fin"), EMFModelMappings.partMapping("spikes_back_left", "left_back_fin")));
        OptifineMapper.models("puffer_fish_medium").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("fin_right", "right_blue_fin"), EMFModelMappings.partMapping("fin_left", "left_blue_fin"), EMFModelMappings.partMapping("spikes_front_top", "top_front_fin"), EMFModelMappings.partMapping("spikes_back_top", "top_back_fin"), EMFModelMappings.partMapping("spikes_front_right", "right_front_fin"), EMFModelMappings.partMapping("spikes_front_left", "left_front_fin"), EMFModelMappings.partMapping("spikes_front_bottom", "bottom_front_fin"), EMFModelMappings.partMapping("spikes_back_bottom", "bottom_back_fin"), EMFModelMappings.partMapping("spikes_back_right", "right_back_fin"), EMFModelMappings.partMapping("spikes_back_left", "left_back_fin")));
        OptifineMapper.models("puffer_fish_small").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("fin_right", "right_fin"), EMFModelMappings.partMapping("fin_left", "left_fin"), EMFModelMappings.partMapping("eye_right", "right_eye"), EMFModelMappings.partMapping("eye_left", "left_eye"), EMFModelMappings.partMapping("tail", "back_fin")));
        OptifineMapper.models("rabbit").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("left_foot", "left_hind_foot"), EMFModelMappings.partMapping("right_foot", "right_hind_foot"), EMFModelMappings.partMapping("left_thigh", "left_haunch"), EMFModelMappings.partMapping("right_thigh", "right_haunch"), EMFModelMappings.partMapping("left_arm", "left_front_leg"), EMFModelMappings.partMapping("right_arm", "right_front_leg"), EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("right_ear"), EMFModelMappings.partMapping("left_ear"), EMFModelMappings.partMapping("tail"), EMFModelMappings.partMapping("nose")));
        OptifineMapper.models("ravager").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("leg1", "right_hind_leg"), EMFModelMappings.partMapping("leg2", "left_hind_leg"), EMFModelMappings.partMapping("leg3", "right_front_leg"), EMFModelMappings.partMapping("leg4", "left_front_leg"), EMFModelMappings.partMapping("jaw", "mouth"), EMFModelMappings.partMapping("neck")));
        OptifineMapper.models("salmon", "salmon_large", "salmon_small").parts(Map.ofEntries(EMFModelMappings.partMapping("body_front"), EMFModelMappings.partMapping("body_back"), EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("fin_back_1", "top_front_fin"), EMFModelMappings.partMapping("fin_back_2", "top_back_fin"), EMFModelMappings.partMapping("tail", "back_fin"), EMFModelMappings.partMapping("fin_right", "right_fin"), EMFModelMappings.partMapping("fin_left", "left_fin")));
        OptifineMapper.models("shulker").parts(Map.ofEntries(EMFModelMappings.partMapping("lid"), EMFModelMappings.partMapping("base"), EMFModelMappings.partMapping("head")));
        OptifineMapper.models("shulker_box").parts(Map.ofEntries(EMFModelMappings.partMapping("lid"), EMFModelMappings.partMapping("base")));
        OptifineMapper.models("silverfish").parts(Map.ofEntries(EMFModelMappings.partMapping("body1", "segment0"), EMFModelMappings.partMapping("body2", "segment1"), EMFModelMappings.partMapping("body3", "segment2"), EMFModelMappings.partMapping("body4", "segment3"), EMFModelMappings.partMapping("body5", "segment4"), EMFModelMappings.partMapping("body6", "segment5"), EMFModelMappings.partMapping("body7", "segment6"), EMFModelMappings.partMapping("wing1", "layer0"), EMFModelMappings.partMapping("wing2", "layer1"), EMFModelMappings.partMapping("wing3", "layer2")));
        OptifineMapper.models("slime").parts(Map.ofEntries(EMFModelMappings.partMapping("body", "cube"), EMFModelMappings.partMapping("left_eye"), EMFModelMappings.partMapping("right_eye"), EMFModelMappings.partMapping("mouth")));
        OptifineMapper.models("slime_outer").parts(Map.ofEntries(EMFModelMappings.partMapping("body", "cube")));
        OptifineMapper.models("snow_golem").parts(Map.ofEntries(EMFModelMappings.partMapping("body", "upper_body"), EMFModelMappings.partMapping("body_bottom", "lower_body"), EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("left_hand", "left_arm"), EMFModelMappings.partMapping("right_hand", "right_arm")));
        OptifineMapper.models("strider", "strider_saddle").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("right_leg"), EMFModelMappings.partMapping("left_leg"), EMFModelMappings.partMapping("hair_right_top", "right_top_bristle"), EMFModelMappings.partMapping("hair_right_middle", "right_middle_bristle"), EMFModelMappings.partMapping("hair_right_bottom", "right_bottom_bristle"), EMFModelMappings.partMapping("hair_left_top", "left_top_bristle"), EMFModelMappings.partMapping("hair_left_middle", "left_middle_bristle"), EMFModelMappings.partMapping("hair_left_bottom", "left_bottom_bristle")));
        OptifineMapper.models("tadpole").parts(Map.ofEntries(EMFModelMappings.partMapping("body", "root"), EMFModelMappings.partMapping("EMPTY", "body"), EMFModelMappings.partMapping("tail")));
        OptifineMapper.models("tropical_fish_a", "tropical_fish_pattern_a").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("tail"), EMFModelMappings.partMapping("fin_right", "right_fin"), EMFModelMappings.partMapping("fin_left", "left_fin"), EMFModelMappings.partMapping("fin_top", "top_fin")));
        OptifineMapper.models("tropical_fish_b", "tropical_fish_pattern_b").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("tail"), EMFModelMappings.partMapping("fin_right", "right_fin"), EMFModelMappings.partMapping("fin_left", "left_fin"), EMFModelMappings.partMapping("fin_top", "top_fin"), EMFModelMappings.partMapping("fin_bottom", "bottom_fin")));
        OptifineMapper.models("turtle").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("body2", "egg_belly"), EMFModelMappings.partMapping("leg1", "right_hind_leg"), EMFModelMappings.partMapping("leg2", "left_hind_leg"), EMFModelMappings.partMapping("leg3", "right_front_leg"), EMFModelMappings.partMapping("leg4", "left_front_leg")));
        OptifineMapper.models("warden").parts(Map.ofEntries(EMFModelMappings.partMapping("body", "bone"), EMFModelMappings.partMapping("torso", "body"), EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("left_leg"), EMFModelMappings.partMapping("right_leg"), EMFModelMappings.partMapping("left_arm"), EMFModelMappings.partMapping("right_arm"), EMFModelMappings.partMapping("left_tendril"), EMFModelMappings.partMapping("right_tendril"), EMFModelMappings.partMapping("left_ribcage"), EMFModelMappings.partMapping("right_ribcage")));
        OptifineMapper.models("witch").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("headwear", "hat"), EMFModelMappings.partMapping("headwear2", "hat_rim"), EMFModelMappings.partMapping("bodywear", "jacket"), EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("arms"), EMFModelMappings.partMapping("right_leg"), EMFModelMappings.partMapping("left_leg"), EMFModelMappings.partMapping("nose"), EMFModelMappings.partMapping("mole")));
        OptifineMapper.models("wither", "wither_armor").parts(Map.ofEntries(EMFModelMappings.partMapping("body1", "shoulders"), EMFModelMappings.partMapping("body2", "ribcage"), EMFModelMappings.partMapping("body3", "tail"), EMFModelMappings.partMapping("head1", "center_head"), EMFModelMappings.partMapping("head2", "right_head"), EMFModelMappings.partMapping("head3", "left_head")));
        OptifineMapper.models("player", "player_slim").parts(genericPlayerBiped);
        OptifineMapper.models("boat").parts(Map.ofEntries(EMFModelMappings.partMapping("bottom"), EMFModelMappings.partMapping("back"), EMFModelMappings.partMapping("front"), EMFModelMappings.partMapping("right"), EMFModelMappings.partMapping("left"), EMFModelMappings.partMapping("paddle_left", "left_paddle"), EMFModelMappings.partMapping("paddle_right", "right_paddle")));
        OptifineMapper.models("banner").parts(Map.ofEntries(EMFModelMappings.partMapping("slate", "flag"), EMFModelMappings.partMapping("stand", "pole"), EMFModelMappings.partMapping("top", "bar")));
        OptifineMapper.models("bed_head").parts(Map.ofEntries(EMFModelMappings.partMapping("head", "main"), EMFModelMappings.partMapping("leg1", "left_leg"), EMFModelMappings.partMapping("leg2", "right_leg")));
        OptifineMapper.models("bed_foot").parts(Map.ofEntries(EMFModelMappings.partMapping("foot", "main"), EMFModelMappings.partMapping("leg3", "left_leg"), EMFModelMappings.partMapping("leg4", "right_leg")));
        OptifineMapper.models("bell").parts(Map.ofEntries(EMFModelMappings.partMapping("body", "bell_body")));
        OptifineMapper.models("chest_boat").parts(Map.ofEntries(EMFModelMappings.partMapping("bottom"), EMFModelMappings.partMapping("back"), EMFModelMappings.partMapping("front"), EMFModelMappings.partMapping("right"), EMFModelMappings.partMapping("left"), EMFModelMappings.partMapping("paddle_left", "left_paddle"), EMFModelMappings.partMapping("paddle_right", "right_paddle"), EMFModelMappings.partMapping("chest_base", "chest_bottom"), EMFModelMappings.partMapping("chest_lid"), EMFModelMappings.partMapping("chest_knob", "chest_lock")));
        OptifineMapper.models("raft").parts(Map.ofEntries(EMFModelMappings.partMapping("bottom"), EMFModelMappings.partMapping("paddle_left", "left_paddle"), EMFModelMappings.partMapping("paddle_right", "right_paddle")));
        OptifineMapper.models("chest_raft").parts(Map.ofEntries(EMFModelMappings.partMapping("bottom"), EMFModelMappings.partMapping("paddle_left", "left_paddle"), EMFModelMappings.partMapping("paddle_right", "right_paddle"), EMFModelMappings.partMapping("chest_base", "chest_bottom"), EMFModelMappings.partMapping("chest_lid"), EMFModelMappings.partMapping("chest_knob", "chest_lock")));
        OptifineMapper.models("minecart", "chest_minecart", "command_block_minecart", "spawner_minecart", "tnt_minecart", "furnace_minecart", "hopper_minecart").parts(Map.ofEntries(EMFModelMappings.partMapping("bottom"), EMFModelMappings.partMapping("back"), EMFModelMappings.partMapping("front"), EMFModelMappings.partMapping("right"), EMFModelMappings.partMapping("left")));
        OptifineMapper.models("conduit_cage").parts(Map.ofEntries(EMFModelMappings.partMapping("cage", "shell")));
        OptifineMapper.models("conduit_eye").parts(Map.ofEntries(EMFModelMappings.partMapping("eye")));
        OptifineMapper.models("conduit_shell").parts(Map.ofEntries(EMFModelMappings.partMapping("base", "shell")));
        OptifineMapper.models("conduit_wind").parts(Map.ofEntries(EMFModelMappings.partMapping("wind")));
        OptifineMapper.models("decorated_pot_base").parts(Map.ofEntries(EMFModelMappings.partMapping("neck"), EMFModelMappings.partMapping("top"), EMFModelMappings.partMapping("bottom")));
        OptifineMapper.models("decorated_pot_sides").parts(Map.ofEntries(EMFModelMappings.partMapping("front"), EMFModelMappings.partMapping("back"), EMFModelMappings.partMapping("left"), EMFModelMappings.partMapping("right")));
        OptifineMapper.models("book").parts(Map.ofEntries(EMFModelMappings.partMapping("cover_left", "right_lid"), EMFModelMappings.partMapping("cover_right", "left_lid"), EMFModelMappings.partMapping("pages_left", "right_pages"), EMFModelMappings.partMapping("pages_right", "left_pages"), EMFModelMappings.partMapping("flipping_page_right", "flip_page1"), EMFModelMappings.partMapping("flipping_page_left", "flip_page2"), EMFModelMappings.partMapping("book_spine", "seam")));
        OptifineMapper.models("hanging_sign").parts(Map.ofEntries(EMFModelMappings.partMapping("board"), EMFModelMappings.partMapping("plank"), EMFModelMappings.partMapping("chains", "normalChains"), EMFModelMappings.partMapping("chain_left1", "chainL1"), EMFModelMappings.partMapping("chain_left2", "chainL2"), EMFModelMappings.partMapping("chain_right1", "chainR1"), EMFModelMappings.partMapping("chain_right2", "chainR2"), EMFModelMappings.partMapping("chains_v", "vChains")));
        OptifineMapper.models("lead_knot").parts(Map.ofEntries(EMFModelMappings.partMapping("knot")));
        OptifineMapper.models("spin_attack").parts(Map.ofEntries(EMFModelMappings.partMapping("box1", "box0"), EMFModelMappings.partMapping("box2", "box1")));
        OptifineMapper.models("sign").parts(Map.ofEntries(EMFModelMappings.partMapping("board", "root"), EMFModelMappings.partMapping("stick")));
        OptifineMapper.models("wall_sign").parts(Map.ofEntries(EMFModelMappings.partMapping("board", "root")));
        OptifineMapper.models("trident").parts(Map.ofEntries(EMFModelMappings.partMapping("body", "pole"), EMFModelMappings.partMapping("base"), EMFModelMappings.partMapping("left_spike"), EMFModelMappings.partMapping("middle_spike"), EMFModelMappings.partMapping("right_spike")));
        OptifineMapper.models("shield").parts(Map.ofEntries(EMFModelMappings.partMapping("plate"), EMFModelMappings.partMapping("handle")));
        OptifineMapper.models("breeze", "breeze_eyes", "breeze_wind").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("rods"), EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("wind_body"), EMFModelMappings.partMapping("wind_middle", "wind_mid"), EMFModelMappings.partMapping("wind_bottom"), EMFModelMappings.partMapping("wind_top")));
        OptifineMapper.models("wind_charge", "breeze_wind_charge").parts(Map.ofEntries(EMFModelMappings.partMapping("wind"), EMFModelMappings.partMapping("charge", "wind_charge")));
        OptifineMapper.models("bogged").parts((Map<String, String>)new HashMap<String, String>(genericNonPlayerBiped){
            {
                this.put("mushrooms", "mushrooms");
            }
        });
        OptifineMapper.models("player_cape").parts(Map.ofEntries(EMFModelMappings.partMapping("cape")));
        OptifineMapper.models("player_ears").parts(Map.ofEntries(EMFModelMappings.partMapping("left_ear"), EMFModelMappings.partMapping("right_ear")));
        OptifineMapper.models("dragon").parts(Map.ofEntries(EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("jaw", "jaw"), EMFModelMappings.partMapping("body", "body"), EMFModelMappings.partMapping("neck1", "neck0"), EMFModelMappings.partMapping("neck2", "neck1"), EMFModelMappings.partMapping("neck3", "neck2"), EMFModelMappings.partMapping("neck4", "neck3"), EMFModelMappings.partMapping("neck5", "neck4"), EMFModelMappings.partMapping("tail1", "tail0"), EMFModelMappings.partMapping("tail2", "tail1"), EMFModelMappings.partMapping("tail3", "tail2"), EMFModelMappings.partMapping("tail4", "tail3"), EMFModelMappings.partMapping("tail5", "tail4"), EMFModelMappings.partMapping("tail6", "tail5"), EMFModelMappings.partMapping("tail7", "tail6"), EMFModelMappings.partMapping("tail8", "tail7"), EMFModelMappings.partMapping("tail9", "tail8"), EMFModelMappings.partMapping("tail10", "tail9"), EMFModelMappings.partMapping("tail11", "tail10"), EMFModelMappings.partMapping("tail12", "tail11"), EMFModelMappings.partMapping("left_wing"), EMFModelMappings.partMapping("left_wing_tip", "left_wing_tip"), EMFModelMappings.partMapping("right_wing"), EMFModelMappings.partMapping("right_wing_tip", "right_wing_tip"), EMFModelMappings.partMapping("front_left_leg", "left_front_leg"), EMFModelMappings.partMapping("front_left_shin", "left_front_leg_tip"), EMFModelMappings.partMapping("front_left_foot", "left_front_foot"), EMFModelMappings.partMapping("back_left_leg", "left_hind_leg"), EMFModelMappings.partMapping("back_left_shin", "left_hind_leg_tip"), EMFModelMappings.partMapping("back_left_foot", "left_hind_foot"), EMFModelMappings.partMapping("front_right_leg", "right_front_leg"), EMFModelMappings.partMapping("front_right_shin", "right_front_leg_tip"), EMFModelMappings.partMapping("front_right_foot", "right_front_foot"), EMFModelMappings.partMapping("back_right_leg", "right_hind_leg"), EMFModelMappings.partMapping("back_right_shin", "right_hind_leg_tip"), EMFModelMappings.partMapping("back_right_foot", "right_hind_foot")));
        OptifineMapper.models("end_crystal").parts(Map.ofEntries(EMFModelMappings.partMapping("cube"), EMFModelMappings.partMapping("inner_glass"), EMFModelMappings.partMapping("outer_glass"), EMFModelMappings.partMapping("base")));
        OptifineMapper.models("armadillo").parts(Map.ofEntries(EMFModelMappings.partMapping("body"), EMFModelMappings.partMapping("head"), EMFModelMappings.partMapping("left_ear"), EMFModelMappings.partMapping("right_ear"), EMFModelMappings.partMapping("left_ear_cube"), EMFModelMappings.partMapping("right_ear_cube"), EMFModelMappings.partMapping("back_left_leg", "left_hind_leg"), EMFModelMappings.partMapping("back_right_leg", "right_hind_leg"), EMFModelMappings.partMapping("front_left_leg", "left_front_leg"), EMFModelMappings.partMapping("front_right_leg", "right_front_leg"), EMFModelMappings.partMapping("cube"), EMFModelMappings.partMapping("tail")));
        OptifineMapper.models("spectral_arrow", "arrow").parts(Map.ofEntries(EMFModelMappings.partMapping("back"), EMFModelMappings.partMapping("cross_1"), EMFModelMappings.partMapping("cross_2")));
        OptifineMapper.models("bee_stinger").parts(Map.ofEntries(EMFModelMappings.partMapping("cross_1"), EMFModelMappings.partMapping("cross_2")));
        OptifineMapper.models("boat_water_patch").parts(Map.ofEntries(EMFModelMappings.partMapping("water_patch", "water_patch")));
    }

    @Contract(value="_ -> new", pure=true)
    public static @NotNull Map.Entry<String, String> partMapping(String optifineName) {
        return new MutablePair((Object)optifineName, (Object)optifineName);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NotNull Map.Entry<String, String> partMapping(String optifineName, String vanillaName) {
        return new MutablePair((Object)optifineName, (Object)vanillaName);
    }

    public static Map<String, String> getMapOf(EMFModel_ID mobId, @Nullable class_630 root) {
        return EMFModelMappings.getMapOf(mobId, root, true);
    }

    public static Map<String, String> getMapOf(@NotNull EMFModel_ID mobId, @Nullable class_630 root, boolean exportOnlyFirstTime) {
        Map<String, String> knownMap;
        String mobName = mobId.getMapId();
        if (mobName.matches(".*_baby($|_.*)") && !mobName.contains(":")) {
            mobName = mobName.replaceFirst("_baby", "");
        }
        if ((knownMap = mobName.endsWith("_inner_armor") || mobName.endsWith("_outer_armor") ? genericNonPlayerBiped : EMFModelMappings.getKnownMap(mobName)) == null) {
            return root == null ? Map.of() : EMFModelMappings.exploreProvidedEntityModelAndExportIfNeeded(root, mobId, null, exportOnlyFirstTime);
        }
        if (((EMFConfig)EMF.config().getConfig()).modelExportMode.doesAll()) {
            EMFModelMappings.exportKnown(mobId, root, knownMap, exportOnlyFirstTime);
        }
        return knownMap;
    }

    private static void exportKnown(EMFModel_ID mobId, @Nullable class_630 root, Map<String, String> knownMap, boolean exportOnlyFirstTime) {
        String mobName = mobId.getfileName();
        EMFUtils.log("Exporting/logging  model for " + mobName + " that has known OptiFine part names:");
        EMFModelMappings.exploreProvidedEntityModelAndExportIfNeeded(root, mobId, knownMap, exportOnlyFirstTime);
        EMFUtils.log("Additionally exporting/logging model for " + mobName + " again as though it did not have known OptiFine part names:\nThis might highlight some vanilla, or mod added, parts that are not usually exposed by OptiFine");
        EMFConfig.ModelPrintMode old = ((EMFConfig)EMF.config().getConfig()).modelExportMode;
        ((EMFConfig)EMF.config().getConfig()).modelExportMode = EMFConfig.ModelPrintMode.ALL_LOG_ONLY;
        try {
            EMFModelMappings.exploreProvidedEntityModelAndExportIfNeeded(root, mobId, null, exportOnlyFirstTime);
        }
        catch (Exception e) {
            EMFUtils.logError("Error while exporting model for " + mobName + " again as though it did not have known OptiFine part names:");
            e.printStackTrace();
        }
        ((EMFConfig)EMF.config().getConfig()).modelExportMode = old;
    }

    @Nullable
    private static Map<String, String> getKnownMap(String mobName) {
        return OPTIFINE_MODEL_MAP_CACHE.get(mobName);
    }

    public static Map<String, String> exploreProvidedEntityModelAndExportIfNeeded(class_630 originalModel, EMFModel_ID mobId, @Nullable Map<String, String> mobMap, boolean exportOnlyFirstTime) {
        boolean known;
        class_5607 unModifiedModel;
        String id = mobId.getDisplayFileName();
        if (UNKNOWN_MODEL_MAP_CACHE.containsKey(id) && exportOnlyFirstTime) {
            return UNKNOWN_MODEL_MAP_CACHE.get(id);
        }
        class_5601 layer = (class_5601)EMFManager.getInstance().cache_LayersByModelName.get((Object)mobId);
        if (layer != null && (unModifiedModel = ((IEMFUnmodifiedLayerRootGetter)class_310.method_1551().method_31974()).emf$getUnmodifiedRoots().get(layer)) != null) {
            originalModel = unModifiedModel.method_32109();
        }
        if (originalModel == null) {
            EMFUtils.logError("model part was null and not already mapped in exploreProvidedEntityModel() EMF");
            return Map.of();
        }
        HashMap<String, String> detailsMap = new HashMap<String, String>();
        boolean bl = known = mobMap != null;
        if (!known) {
            mobMap = new HashMap<String, String>();
            EMFModelMappings.mapThisAndChildren("root", originalModel, mobMap, detailsMap);
        }
        UNKNOWN_MODEL_MAP_CACHE.put(id, mobMap);
        if (((EMFConfig)EMF.config().getConfig()).modelExportMode != EMFConfig.ModelPrintMode.NONE) {
            StringBuilder mapString = new StringBuilder();
            String namespace = mobId.namespace;
            String fileName = mobId.getfileName();
            mapString.append(" |-[assets/").append(namespace).append("/optifine/cem/").append(fileName).append(".jem]\n");
            mobMap.forEach((key, entry) -> {
                mapString.append(" | |-[").append("root".equals(key) ? "(optional) " : "").append("part=").append((String)key).append("]\n");
                mapString.append((String)detailsMap.get(key));
            });
            mapString.append("  \\-\\{{end of model}}");
            if (known) {
                EMFUtils.log("Known model detected, Mapping now...\n" + String.valueOf(mapString));
            } else {
                EMFUtils.log("Unknown (possibly modded) model detected, Mapping now...\n" + String.valueOf(mapString));
            }
            if (((EMFConfig)EMF.config().getConfig()).modelExportMode.doesJems()) {
                EMFUtils.log("creating example .jem file for " + fileName);
                JsonObject jemPrinter = new JsonObject();
                int[] textureSize = null;
                JsonArray models = new JsonArray();
                for (Map.Entry<String, String> entry2 : mobMap.entrySet()) {
                    JsonObject partPrinter = new JsonObject();
                    partPrinter.addProperty("invertAxis", "xy");
                    partPrinter.addProperty("part", entry2.getKey());
                    partPrinter.addProperty("id", entry2.getKey());
                    partPrinter.addProperty("attach", Boolean.valueOf(false));
                    PartAndOffsets searchPart = EMFModelMappings.getChildByName(entry2.getValue(), originalModel, 0.0f, 0.0f, 0.0f);
                    PartAndOffsets vanillaModelPart = searchPart == null && "root".equals(entry2.getKey()) ? new PartAndOffsets(originalModel, 0.0f, 0.0f, 0.0f) : searchPart;
                    textureSize = EMFModelMappings.initPartPrinterAndCaptureTextureSizeIfNeeded(vanillaModelPart, partPrinter, textureSize);
                    models.add((JsonElement)partPrinter);
                }
                if (!models.isEmpty()) {
                    jemPrinter.add("models", (JsonElement)models);
                }
                if (textureSize == null) {
                    textureSize = new int[]{64, 32};
                }
                JsonArray textureSize2 = new JsonArray();
                textureSize2.add((Number)((int)textureSize[0]));
                textureSize2.add((Number)textureSize[1]);
                jemPrinter.add("textureSize", (JsonElement)textureSize2);
                EMFModelMappings.printModel(namespace, fileName, jemPrinter);
                mobId.forEachFallback(fallback -> EMFModelMappings.printModel(fallback.namespace, fallback.getfileName(), jemPrinter));
            }
        }
        return mobMap;
    }

    private static void printModel(String namespace, String fileName, JsonObject jemPrinter) {
        String path = ETF.getConfigDirectory().toFile().getParent() + "/emf/export/assets/" + namespace + "/optifine/cem/" + fileName + ".jem";
        File outFile = new File(path);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!outFile.getParentFile().exists()) {
            outFile.getParentFile().mkdirs();
        }
        try {
            FileWriter fileWriter = new FileWriter(outFile);
            fileWriter.write(gson.toJson((JsonElement)jemPrinter));
            fileWriter.close();
            EMFUtils.log(".jem file creation succeeded for [" + path + "]");
        }
        catch (IOException e) {
            EMFUtils.log(".jem file creation failed for [" + path + "]");
        }
    }

    private static void addArrayProperty(JsonObject obj, String name, Number ... values) {
        JsonArray arr = new JsonArray(values.length);
        for (Number value : values) {
            arr.add(value);
        }
        obj.add(name, (JsonElement)arr);
    }

    private static void addArrayProperty(JsonObject obj, String name, JsonObject ... values) {
        JsonArray arr = new JsonArray(values.length);
        for (JsonObject value : values) {
            arr.add((JsonElement)value);
        }
        obj.add(name, (JsonElement)arr);
    }

    private static int[] initPartPrinterAndCaptureTextureSizeIfNeeded(PartAndOffsets partAndOffsets, JsonObject partPrinter, int[] textureSize) {
        int[] thisTextureSize = null;
        if (partAndOffsets != null && partAndOffsets.part != null) {
            class_630 vanillaModelPart = partAndOffsets.part;
            float x = -partAndOffsets.x + vanillaModelPart.field_3657;
            float y = -24.0f - partAndOffsets.y + vanillaModelPart.field_3656;
            float z = partAndOffsets.z - vanillaModelPart.field_3655;
            if (x != 0.0f || y != 0.0f || z != 0.0f) {
                EMFModelMappings.addArrayProperty(partPrinter, "translate", Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
            }
            float rx = partAndOffsets.part.method_41921().comp_3000() * -57.295776f;
            float ry = partAndOffsets.part.method_41921().comp_3001() * -57.295776f;
            float rz = partAndOffsets.part.method_41921().comp_3002() * 57.295776f;
            if (rx != 0.0f || ry != 0.0f || rz != 0.0f) {
                EMFModelMappings.addArrayProperty(partPrinter, "rotate", Float.valueOf(rx), Float.valueOf(ry), Float.valueOf(rz));
            }
            if (vanillaModelPart.field_37938 != 1.0f) {
                partPrinter.addProperty("scale", (Number)Float.valueOf(vanillaModelPart.field_37938));
            }
            thisTextureSize = ((IEMFTextureSizeSupplier)vanillaModelPart).emf$getTextureSize();
            ArrayList<JsonObject> list = new ArrayList<JsonObject>(vanillaModelPart.field_3663.size());
            for (class_630.class_628 cube : vanillaModelPart.field_3663) {
                JsonObject boxPrinter = new JsonObject();
                Number[] coordinates = new Float[]{Float.valueOf(cube.field_3645), Float.valueOf(cube.field_3644), Float.valueOf(cube.field_3643), Float.valueOf(cube.field_3648 - cube.field_3645), Float.valueOf(cube.field_3647 - cube.field_3644), Float.valueOf(cube.field_3646 - cube.field_3643)};
                thisTextureSize = thisTextureSize == null ? ((IEMFCuboidDataSupplier)cube).emf$getTextureXY() : thisTextureSize;
                int[] uv = ((IEMFCuboidDataSupplier)cube).emf$getTextureUV();
                EMFModelMappings.addArrayProperty(boxPrinter, "textureOffset", uv[0], uv[1]);
                float[] adds = ((IEMFCuboidDataSupplier)cube).emf$getSizeAdd();
                if (adds != null) {
                    if (adds[0] == adds[1] && adds[0] == adds[2]) {
                        if (adds[0] != 0.0f) {
                            boxPrinter.addProperty("sizeAdd", (Number)Float.valueOf(adds[0]));
                        }
                    } else {
                        if (adds[0] != 0.0f) {
                            boxPrinter.addProperty("sizeAddX", (Number)Float.valueOf(adds[0]));
                        }
                        if (adds[1] != 0.0f) {
                            boxPrinter.addProperty("sizeAddY", (Number)Float.valueOf(adds[1]));
                        }
                        if (adds[2] != 0.0f) {
                            boxPrinter.addProperty("sizeAddZ", (Number)Float.valueOf(adds[2]));
                        }
                    }
                }
                coordinates[0] = Float.valueOf(-coordinates[0].floatValue() - coordinates[3].floatValue() - x);
                coordinates[1] = Float.valueOf(-coordinates[1].floatValue() - coordinates[4].floatValue() - y);
                coordinates[2] = Float.valueOf(coordinates[2].floatValue() - z);
                EMFModelMappings.addArrayProperty(boxPrinter, "coordinates", coordinates);
                list.add(boxPrinter);
            }
            if (textureSize != null && !Arrays.equals(textureSize, thisTextureSize)) {
                EMFModelMappings.addArrayProperty(partPrinter, "textureSize", textureSize[0], textureSize[1]);
            }
            if (!list.isEmpty()) {
                EMFModelMappings.addArrayProperty(partPrinter, "boxes", list.toArray(new JsonObject[0]));
            }
        }
        return textureSize == null ? thisTextureSize : textureSize;
    }

    @Nullable
    private static PartAndOffsets getChildByName(String name, @NotNull class_630 part, float x, float y, float z) {
        if (part.method_41919(name)) {
            return new PartAndOffsets(part.method_32086(name), x - part.field_3657, y - part.field_3656, z - part.field_3655);
        }
        for (class_630 childPart : part.field_3661.values()) {
            PartAndOffsets possibleReturn = EMFModelMappings.getChildByName(name, childPart, x - part.field_3657, y - part.field_3656, z - part.field_3655);
            if (possibleReturn == null) continue;
            return possibleReturn;
        }
        return null;
    }

    private static void mapThisAndChildren(String partName, @NotNull class_630 originalModel, Map<String, String> newMap, Map<String, String> detailsMap) {
        for (Map.Entry entry : originalModel.field_3661.entrySet()) {
            EMFModelMappings.mapThisAndChildren((String)entry.getKey(), (class_630)entry.getValue(), newMap, detailsMap);
        }
        newMap.put(partName, partName);
        if (((EMFConfig)EMF.config().getConfig()).modelExportMode != EMFConfig.ModelPrintMode.NONE) {
            StringBuilder cubes = new StringBuilder(originalModel.field_3663.isEmpty() ? "[No boxes]" : "[boxes]");
            int i = 0;
            for (class_630.class_628 cube : originalModel.field_3663) {
                ++i;
                float[] coordinates = new float[]{cube.field_3645, cube.field_3644, cube.field_3643, cube.field_3648 - cube.field_3645, cube.field_3647 - cube.field_3644, cube.field_3646 - cube.field_3643};
                int[] textureOffset = ((IEMFCuboidDataSupplier)cube).emf$getTextureUV();
                float[] adds = ((IEMFCuboidDataSupplier)cube).emf$getSizeAdd();
                float sizeAdd = Float.NaN;
                float sizeAddX = Float.NaN;
                float sizeAddY = Float.NaN;
                float sizeAddZ = Float.NaN;
                if (adds != null) {
                    if (adds[0] == adds[1] && adds[0] == adds[2]) {
                        sizeAdd = adds[0];
                    } else {
                        sizeAddX = adds[0];
                        sizeAddY = adds[1];
                        sizeAddZ = adds[2];
                    }
                }
                coordinates[0] = -coordinates[0] - coordinates[3] - originalModel.field_3657;
                coordinates[1] = -coordinates[1] - coordinates[4] - originalModel.field_3656;
                coordinates[2] = coordinates[2] - originalModel.field_3655;
                cubes.append("\n | |   |-[#").append(i).append("]").append("\n | |   |-coordinates=").append(Arrays.toString(coordinates)).append("\n | |   |-textureOffset=").append(Arrays.toString(textureOffset));
                if (!Float.isNaN(sizeAdd)) {
                    cubes.append("\n | |    \\-sizeAdd=").append(sizeAdd);
                    continue;
                }
                cubes.append("\n | |   |-sizeAddX=").append(sizeAddX).append("\n | |   |-sizeAddY=").append(sizeAddY).append("\n | |    \\-sizeAddZ=").append(sizeAddZ);
            }
            detailsMap.put(partName, " | | |-pivots=" + originalModel.field_3657 + ", " + originalModel.field_3656 + ", " + originalModel.field_3655 + "\n | | |-rotations=" + originalModel.field_3654 * 57.295776f + ", " + originalModel.field_3675 * 57.295776f + ", " + originalModel.field_3674 * 57.295776f + "\n | | |-scales=" + originalModel.field_37938 + ", " + originalModel.field_37939 + ", " + originalModel.field_37940 + "\n | | |visible=" + originalModel.field_3665 + ", _boxes=" + !originalModel.field_38456 + "\n | |  \\" + String.valueOf(cubes) + "\n");
        }
    }

    static {
        EMFModelMappings.initOptifineMappings();
    }

    private static class OptifineMapper {
        String[] modelNames;

        OptifineMapper(String ... modelNames) {
            this.modelNames = modelNames;
        }

        @Contract(value="_ -> new", pure=true)
        @NotNull
        static OptifineMapper models(String ... modelNames) {
            return new OptifineMapper(modelNames);
        }

        void parts(Map<String, String> stringStringMap) {
            for (String key : this.modelNames) {
                if (OPTIFINE_MODEL_MAP_CACHE.put(key, stringStringMap) == null) continue;
                EMFUtils.logError("OptiFine model map for " + key + " already exists, overwriting");
            }
        }
    }

    private record PartAndOffsets(class_630 part, float x, float y, float z) {
    }
}

