/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math;

import traben.entity_model_features.EMFManager;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_model_features.utils.EMFUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MathOperator implements MathComponent
{
    ADD{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return first.getResult() + second.getResult();
        }
    }
    ,
    SUBTRACT{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return first.getResult() - second.getResult();
        }
    }
    ,
    MULTIPLY{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return first.getResult() * second.getResult();
        }
    }
    ,
    DIVIDE{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            float sec = second.getResult();
            if (sec == 0.0f && !second.isConstant() && EMFManager.getInstance().isAnimationValidationPhase) {
                return first.getResult();
            }
            return first.getResult() / sec;
        }
    }
    ,
    DIVISION_REMAINDER{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            float sec = second.getResult();
            if (sec == 0.0f && !second.isConstant() && EMFManager.getInstance().isAnimationValidationPhase) {
                return first.getResult();
            }
            return first.getResult() % sec;
        }
    }
    ,
    COMMA,
    OPEN_BRACKET,
    CLOSED_BRACKET,
    NONE,
    AND{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return MathValue.fromBoolean(MathValue.toBoolean(first.getResult()) && MathValue.toBoolean(second.getResult()));
        }
    }
    ,
    OR{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return MathValue.fromBoolean(MathValue.toBoolean(first.getResult()) || MathValue.toBoolean(second.getResult()));
        }
    }
    ,
    LARGER_THAN{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return MathValue.fromBoolean(first.getResult() > second.getResult());
        }
    }
    ,
    SMALLER_THAN{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return MathValue.fromBoolean(first.getResult() < second.getResult());
        }
    }
    ,
    LARGER_THAN_OR_EQUALS{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return MathValue.fromBoolean(first.getResult() >= second.getResult());
        }
    }
    ,
    SMALLER_THAN_OR_EQUALS{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return MathValue.fromBoolean(first.getResult() <= second.getResult());
        }
    }
    ,
    EQUALS{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return MathValue.fromBoolean(first.getResult() == second.getResult());
        }
    }
    ,
    NOT_EQUALS{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return MathValue.fromBoolean(first.getResult() != second.getResult());
        }
    }
    ,
    BOOLEAN_CHAR;


    public static MathOperator getAction(char ch) {
        return switch (ch) {
            case '+' -> ADD;
            case '-' -> SUBTRACT;
            case '*' -> MULTIPLY;
            case '/' -> DIVIDE;
            case ',' -> COMMA;
            case '(' -> OPEN_BRACKET;
            case ')' -> CLOSED_BRACKET;
            case '%' -> DIVISION_REMAINDER;
            case '!', '&', '<', '=', '>', '|' -> BOOLEAN_CHAR;
            default -> NONE;
        };
    }

    public float execute(MathComponent first, MathComponent second) {
        EMFUtils.logError("math action execute() incorrectly called [" + String.valueOf(this) + "].");
        return Float.NaN;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public float getResult() {
        EMFUtils.logError("math action incorrectly called [" + String.valueOf(this) + "].");
        return Float.NaN;
    }
}

