/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1451;
import net.minecraft.class_1453;
import net.minecraft.class_1493;
import net.minecraft.class_1545;
import net.minecraft.class_1560;
import net.minecraft.class_1577;
import net.minecraft.class_1617;
import net.minecraft.class_1632;
import net.minecraft.class_1634;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1676;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4019;
import net.minecraft.class_5321;
import net.minecraft.class_5354;
import net.minecraft.class_630;
import net.minecraft.class_7134;
import net.minecraft.class_746;
import net.minecraft.class_7689;
import net.minecraft.class_8152;
import net.minecraft.class_922;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.EMF;
import traben.entity_model_features.EMFManager;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mixin.mixins.accessor.MinecraftClientAccessor;
import traben.entity_model_features.mixin.mixins.accessor.Mixin_GuiEntityTester;
import traben.entity_model_features.mod_compat.IrisShadowPassDetection;
import traben.entity_model_features.models.EMFModelMappings;
import traben.entity_model_features.models.EMFModel_ID;
import traben.entity_model_features.models.animation.EMFAttachments;
import traben.entity_model_features.models.animation.state.EMFEntityRenderState;
import traben.entity_model_features.models.parts.EMFModelPartRoot;
import traben.entity_model_features.utils.EMFEntity;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.config.ETFConfig;

@Deprecated
public final class EMFAnimationEntityContext {
    private static final Object2IntOpenHashMap<UUID> knownHighestAngerTimeByUUID = new Object2IntOpenHashMap<UUID>(){
        {
            this.defaultReturnValue(0);
        }
    };
    private static final Object2IntOpenHashMap<UUID> lodEntityTimers = new Object2IntOpenHashMap();
    public static boolean setInHand = false;
    public static boolean isFirstPersonHand = false;
    public static boolean setInItemFrame = false;
    public static boolean setIsOnHead = false;
    public static boolean setIsInGui = false;
    public static double lastFOV = 70.0;
    public static boolean is_in_ground_override = false;
    public static ObjectSet<UUID> entitiesToForceVanillaModel = new ObjectOpenHashSet();
    private static float shadowSize = Float.NaN;
    private static float shadowOpacity = Float.NaN;
    private static float leashX = Float.NaN;
    private static float leashY = Float.NaN;
    private static float leashZ = Float.NaN;
    private static float shadowX = Float.NaN;
    private static float shadowZ = Float.NaN;
    private static float limbAngle = Float.NaN;
    private static float limbDistance = Float.NaN;
    private static float headYaw = Float.NaN;
    private static float headPitch = Float.NaN;
    private static boolean onShoulder = false;
    private static Function<class_2960, class_1921> layerFactory = null;
    private static Boolean lodFrameSkipping = null;
    private static boolean announceModels = false;
    private static float frameCounter = 0.0f;
    public static Object2ObjectOpenHashMap<UUID, class_630[]> entitiesPausedParts = new Object2ObjectOpenHashMap();
    public static ObjectSet<UUID> entitiesPaused = new ObjectOpenHashSet();
    private static EMFEntityRenderState emfState = null;

    public static boolean isEntityAnimPaused() {
        if (emfState == null) {
            return false;
        }
        return entitiesPaused.contains((Object)emfState.uuid());
    }

    @Nullable
    public static class_630[] getEntityPartsAnimPaused() {
        if (emfState == null) {
            return null;
        }
        class_630[] parts = (class_630[])entitiesPausedParts.get((Object)emfState.uuid());
        return parts == null || parts.length == 0 ? null : parts;
    }

    private EMFAnimationEntityContext() {
    }

    public static void incFrameCount() {
        if (IrisShadowPassDetection.getInstance().inShadowPass()) {
            return;
        }
        float inc = frameCounter + 1.0f;
        frameCounter = inc > 27719.0f ? 0.0f : inc;
    }

    public static float getFrameCounter() {
        return frameCounter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isJumping() {
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (!(eMFEntity instanceof class_1309)) return false;
        class_1309 alive = (class_1309)eMFEntity;
        if (!alive.field_6282) return false;
        return true;
    }

    public static void setEntityVariable(String variable, float value) {
        if (emfState != null) {
            emfState.variableMap().put((Object)variable, value);
        }
    }

    public static float getEntityVariable(String variable, float defaultValue) {
        if (emfState == null) {
            return defaultValue;
        }
        return emfState.variableMap().getOrDefault((Object)variable, defaultValue);
    }

    public static void setLayerFactory(Function<class_2960, class_1921> layerFactory) {
        if (EMFAnimationEntityContext.emfEntity() instanceof class_1667) {
            return;
        }
        EMFEntityRenderState state = EMFAnimationEntityContext.getEmfState();
        if (state != null && state.layerFactory() == null) {
            state.setLayerFactory(layerFactory);
        }
        EMFAnimationEntityContext.layerFactory = layerFactory;
    }

    private static int distanceOfEntityFrom(class_2338 pos) {
        if (emfState == null) {
            return 0;
        }
        class_2338 blockPos = emfState.blockPos();
        float f = blockPos.method_10263() - pos.method_10263();
        float g = blockPos.method_10264() - pos.method_10264();
        float h = blockPos.method_10260() - pos.method_10260();
        return (int)class_3532.method_15355((float)(f * f + g * g + h * h));
    }

    private static int getLODFactorOfEntity() {
        class_1297 entity;
        float entitySize;
        EMFEntity eMFEntity;
        int lodFactor;
        if (((EMFConfig)EMF.config().getConfig()).animationLODDistance == 0) {
            return 0;
        }
        if (class_310.method_1551().field_1724 == null || class_310.method_1551().field_1724.method_31550()) {
            return 0;
        }
        int distance = EMFAnimationEntityContext.distanceOfEntityFrom(class_310.method_1551().field_1724.method_24515());
        if (distance < 1) {
            return 0;
        }
        int factor = distance / ((EMFConfig)EMF.config().getConfig()).animationLODDistance;
        int factorByFOV = (int)((double)factor * lastFOV / 70.0);
        if (((EMFConfig)EMF.config().getConfig()).retainDetailOnLowFps && class_310.method_1551().method_47599() < 59) {
            float fpsPercentageOf60 = (float)class_310.method_1551().method_47599() / 60.0f;
            lodFactor = (int)((float)factorByFOV * fpsPercentageOf60);
        } else {
            lodFactor = factorByFOV;
        }
        if (((EMFConfig)EMF.config().getConfig()).retainDetailOnLargerMobs && (eMFEntity = EMFAnimationEntityContext.emfEntity()) instanceof class_1297 && (entitySize = Math.max((entity = (class_1297)eMFEntity).method_17681(), entity.method_17682())) > 2.0f) {
            lodFactor = (int)((float)lodFactor / (entitySize / 2.0f));
        }
        return lodFactor;
    }

    public static boolean isLODSkippingThisFrame() {
        class_1657 player;
        EMFEntity eMFEntity;
        if (lodFrameSkipping != null) {
            return lodFrameSkipping;
        }
        if (ETF.IRIS_DETECTED && IrisShadowPassDetection.getInstance().inShadowPass() && ((EMFConfig)EMF.config().getConfig()).animationFrameSkipDuringIrisShadowPass && (!((eMFEntity = EMFAnimationEntityContext.getEMFEntity()) instanceof class_1657) || !(player = (class_1657)eMFEntity).method_7340() || !class_310.method_1551().field_1690.method_31044().method_31034())) {
            return true;
        }
        if (((EMFConfig)EMF.config().getConfig()).animationLODDistance == 0 || emfState == null) {
            return false;
        }
        int lodTimer = lodEntityTimers.getInt((Object)emfState.uuid());
        int lodResult = lodTimer < 1 ? EMFAnimationEntityContext.getLODFactorOfEntity() : lodTimer - 1;
        lodEntityTimers.put((Object)emfState.uuid(), lodResult);
        lodFrameSkipping = lodResult > 0;
        return lodFrameSkipping;
    }

    public static EMFEntityRenderState getEmfState() {
        return emfState;
    }

    @Deprecated
    private static EMFEntity emfEntity() {
        return emfState == null ? null : emfState.emfEntity();
    }

    public static void setCurrentEntityIteration(@Nullable EMFEntityRenderState state) {
        EMFAttachments.closeBoth();
        isFirstPersonHand = false;
        ++EMFManager.getInstance().entityRenderCount;
        layerFactory = null;
        shadowSize = Float.NaN;
        shadowOpacity = Float.NaN;
        leashX = 0.0f;
        leashY = 0.0f;
        leashZ = 0.0f;
        shadowX = 0.0f;
        shadowZ = 0.0f;
        EMFAnimationEntityContext.newEntity(state);
        if (state != null) {
            Set roots = (Set)EMFManager.getInstance().rootPartsPerEntityTypeForVariation.get((Object)state.typeString());
            if (roots != null) {
                if (EMFAnimationEntityContext.isEntityForcedToVanillaModel()) {
                    roots.forEach(root -> root.setVariantStateTo(0));
                } else {
                    roots.forEach(EMFModelPartRoot::doVariantCheck);
                }
                EMFEntity eMFEntity = state.emfEntity();
                if (eMFEntity instanceof class_1657) {
                    class_1657 player = (class_1657)eMFEntity;
                    if (((EMFConfig)EMF.config().getConfig()).resetPlayerModelEachRender_v2) {
                        roots.forEach(EMFModelPartRoot::resetVanillaPartsToDefaults);
                    }
                }
            }
            if (((EMFConfig)EMF.config().getConfig()).debugOnRightClick && state.uuid().equals(EMFManager.getInstance().entityForDebugPrint)) {
                announceModels = true;
                EMFManager.getInstance().entityForDebugPrint = null;
            }
        }
        lodFrameSkipping = null;
    }

    public static void anounceModels(EMFEntityRenderState assertEntity) {
        StringBuilder model;
        int count;
        String type = assertEntity.typeString();
        Set debugRoots = (Set)EMFManager.getInstance().rootPartsPerEntityTypeForDebug.get((Object)type);
        EMFUtils.chat("\u00a7e-----------EMF Debug Printout-------------\u00a7r");
        if (debugRoots == null) {
            EMFUtils.chat("\n\u00a7c\u00a7oThe EMF debug printout did not find any custom models registered to the following entity:\n \u00a73\u00a7l\u00a7u" + type);
        } else {
            String message = "\n\u00a72\u00a7oThe EMF debug printout found the following custom models for the entity:\n \u00a73\u00a7l\u00a7u" + type + "\u00a7r\n\u00a72\u00a7oThis first model is usually the primary model for the entity.";
            EMFUtils.chat(message);
            count = 1;
            for (EMFModelPartRoot debugRoot : debugRoots) {
                model = new StringBuilder();
                model.append("\u00a7eModel #").append(count).append("\u00a7r").append(EMFAnimationEntityContext.entryAndValue("name", debugRoot.modelName.getfileName() + ".jem"));
                if (debugRoot.modelName.hasFallbackModels()) {
                    model.append("\n\u00a7eFallback Models:\u00a7r");
                    debugRoot.modelName.forEachFallback(modelId -> model.append("\n\u00a76 - \u00a7r").append(modelId.getfileName()));
                }
                if (debugRoot.directoryContext != null) {
                    model.append(EMFAnimationEntityContext.entryAndValue("directory", debugRoot.directoryContext.getRelativeDirectoryLocationNoValidation(debugRoot.modelName.getfileName())));
                }
                if (debugRoot.textureOverride != null) {
                    model.append(EMFAnimationEntityContext.entryAndValue("texture_override", debugRoot.textureOverride.toString()));
                }
                if (debugRoot.variantTester != null) {
                    IntArraySet set = new IntArraySet(debugRoot.allKnownStateVariants.keySet());
                    set.remove(0);
                    model.append(EMFAnimationEntityContext.entryAndValue("model_variants", set.toString())).append(EMFAnimationEntityContext.entryAndValue("current_variant", String.valueOf(debugRoot.currentModelVariant)));
                }
                EMFUtils.chat(String.valueOf(model) + "\n\u00a76 - parts:\u00a7r printed in game log only.");
                EMFUtils.log("\n - parts: " + debugRoot.simplePrintChildren(0));
                ++count;
            }
        }
        EMFUtils.chat("\n\u00a7e----------------------------------------\u00a7r");
        if (!EMFManager.getInstance().modelsAnnounced.isEmpty()) {
            String vanillaMessage = "\n\u00a72\u00a7oThe EMF debug printout found the following non-custom models for the entity:\n \u00a73\u00a7l\u00a7u" + type + "\u00a7r\n\u00a72\u00a7oThis first model is usually the primary model for the entity.";
            EMFUtils.chat(vanillaMessage);
            count = 1;
            for (EMFModel_ID data : EMFManager.getInstance().modelsAnnounced) {
                Map<String, String> map;
                model = new StringBuilder();
                model.append("\n\u00a7eNon-Custom Model #").append(count).append("\u00a7r").append(EMFAnimationEntityContext.entryAndValue("possible .jem name", data.getDisplayFileName()));
                if (data.hasFallbackModels()) {
                    model.append("\u00a7eFallback Models:\u00a7r");
                    data.forEachFallback(modelId -> model.append("\n\u00a76 - \u00a7r").append(modelId.getfileName()));
                }
                if (!(map = EMFModelMappings.getMapOf(data, null)).isEmpty()) {
                    EMFUtils.chat(String.valueOf(model) + "\n\u00a76 - part names:\u00a7r printed in game log only.");
                    StringBuilder parts = new StringBuilder();
                    parts.append("\n - part names: ");
                    map.forEach((k, v) -> parts.append("\n   | - [").append((String)k).append(']'));
                    EMFUtils.log(parts.toString());
                    continue;
                }
                EMFUtils.chat(model.toString());
                EMFUtils.log(" - part names: could not be found. use the 'printout unknown models' setting instead.");
            }
            EMFUtils.chat("\n\u00a7e----------------------------------------\u00a7r");
            EMFManager.getInstance().modelsAnnounced.clear();
        }
        announceModels = false;
    }

    public static boolean doAnnounceModels() {
        return announceModels;
    }

    private static String entryAndValue(String entry, String value) {
        return "\n\u00a76 - " + entry + ":\u00a7r " + value;
    }

    private static void newEntity(@Nullable EMFEntityRenderState state) {
        emfState = state;
        limbAngle = Float.NaN;
        limbDistance = Float.NaN;
        headYaw = Float.NaN;
        headPitch = Float.NaN;
        if (state != null) {
            if (state.entity() instanceof class_1667) {
                layerFactory = class_1921::method_23576;
            } else if (state.isBlockEntity()) {
                layerFactory = class_1921::method_23572;
            }
            if (state.layerFactory() == null) {
                state.setLayerFactory(layerFactory);
            }
        }
        onShoulder = false;
    }

    public static void globalReset() {
        EMFAnimationEntityContext.reset();
        frameCounter = 0.0f;
    }

    public static void reset() {
        isFirstPersonHand = false;
        layerFactory = null;
        emfState = null;
        limbAngle = Float.NaN;
        limbDistance = Float.NaN;
        headYaw = Float.NaN;
        headPitch = Float.NaN;
        onShoulder = false;
        shadowSize = Float.NaN;
        shadowOpacity = Float.NaN;
        leashX = 0.0f;
        leashY = 0.0f;
        leashZ = 0.0f;
        shadowX = 0.0f;
        shadowZ = 0.0f;
        lodFrameSkipping = null;
    }

    public static class_1921 getLayerFromRecentFactoryOrETFOverrideOrTranslucent(class_2960 identifier) {
        if (layerFactory == null) {
            ETFConfig.RenderLayerOverride layer = ((ETFConfig)ETF.config().getConfig()).getRenderLayerOverride();
            if (layer == null) {
                return class_1921.method_23580((class_2960)identifier);
            }
            return switch (layer) {
                default -> throw new IncompatibleClassChangeError();
                case ETFConfig.RenderLayerOverride.TRANSLUCENT -> class_1921.method_23580((class_2960)identifier);
                case ETFConfig.RenderLayerOverride.TRANSLUCENT_CULL -> class_1921.method_23689((class_2960)identifier);
                case ETFConfig.RenderLayerOverride.END -> class_1921.method_34571();
                case ETFConfig.RenderLayerOverride.OUTLINE -> class_1921.method_23287((class_2960)identifier);
            };
        }
        return layerFactory.apply(identifier);
    }

    public static float getRuleIndex() {
        if (emfState == null) {
            return 0.0f;
        }
        return EMFManager.getInstance().lastModelRuleOfEntity.getInt((Object)emfState.uuid());
    }

    public static boolean isEntityForcedToVanillaModel() {
        class_1657 player;
        EMFEntity eMFEntity;
        if (emfState == null) {
            return false;
        }
        if (entitiesToForceVanillaModel.contains((Object)emfState.uuid())) {
            return true;
        }
        return ((EMFConfig)EMF.config().getConfig()).onlyClientPlayerModel && (eMFEntity = EMFAnimationEntityContext.getEMFEntity()) instanceof class_1657 && !(player = (class_1657)eMFEntity).method_7340();
    }

    @Deprecated
    @Nullable
    public static EMFEntity getEMFEntity() {
        return EMFAnimationEntityContext.emfEntity();
    }

    public static float getDimension() {
        if (emfState == null || emfState.world() == null) {
            return 0.0f;
        }
        Optional optional = emfState.world().method_40134().method_40230();
        if (optional.isEmpty()) {
            return 0.0f;
        }
        class_2960 id = ((class_5321)optional.get()).method_29177();
        if (id.equals((Object)class_7134.field_37671)) {
            return -1.0f;
        }
        if (id.equals((Object)class_7134.field_37672)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static float getPlayerX() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)class_3532.method_16436((double)EMFAnimationEntityContext.getTickDelta(), (double)class_310.method_1551().field_1724.field_6014, (double)class_310.method_1551().field_1724.method_23317());
    }

    public static float getPlayerY() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)class_3532.method_16436((double)EMFAnimationEntityContext.getTickDelta(), (double)class_310.method_1551().field_1724.field_6036, (double)class_310.method_1551().field_1724.method_23318());
    }

    public static float getPlayerZ() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)class_3532.method_16436((double)EMFAnimationEntityContext.getTickDelta(), (double)class_310.method_1551().field_1724.field_5969, (double)class_310.method_1551().field_1724.method_23321());
    }

    public static float getPlayerRX() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)Math.toRadians(class_3532.method_17821((float)EMFAnimationEntityContext.getTickDelta(), (float)class_310.method_1551().field_1724.field_6004, (float)class_310.method_1551().field_1724.method_36455()));
    }

    public static float getPlayerRY() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)Math.toRadians(class_3532.method_17821((float)EMFAnimationEntityContext.getTickDelta(), (float)class_310.method_1551().field_1724.field_5982, (float)class_310.method_1551().field_1724.method_36454()));
    }

    public static float getEntityX() {
        return emfState == null ? 0.0f : (float)class_3532.method_16436((double)EMFAnimationEntityContext.getTickDelta(), (double)emfState.prevX(), (double)emfState.x());
    }

    public static float getEntityY() {
        return emfState == null ? 0.0f : (float)class_3532.method_16436((double)EMFAnimationEntityContext.getTickDelta(), (double)emfState.prevY(), (double)emfState.y());
    }

    public static float getEntityZ() {
        return emfState == null ? 0.0f : (float)class_3532.method_16436((double)EMFAnimationEntityContext.getTickDelta(), (double)emfState.prevZ(), (double)emfState.z());
    }

    public static float getEntityRX() {
        return emfState == null ? 0.0f : (float)Math.toRadians(class_3532.method_17821((float)EMFAnimationEntityContext.getTickDelta(), (float)emfState.prevPitch(), (float)emfState.pitch()));
    }

    public static float getEntityRY() {
        float f;
        if (emfState == null) {
            return 0.0f;
        }
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof class_1309) {
            class_1309 alive = (class_1309)eMFEntity;
            f = (float)Math.toRadians(class_3532.method_17821((float)EMFAnimationEntityContext.getTickDelta(), (float)alive.field_6220, (float)alive.field_6283));
        } else {
            eMFEntity = EMFAnimationEntityContext.emfEntity();
            if (eMFEntity instanceof class_1297) {
                class_1297 entity = (class_1297)eMFEntity;
                f = (float)Math.toRadians(class_3532.method_17821((float)EMFAnimationEntityContext.getTickDelta(), (float)entity.field_5982, (float)entity.field_6031));
            } else {
                f = 0.0f;
            }
        }
        return f;
    }

    public static float getTime() {
        if (emfState == null || emfState.world() == null) {
            return 0.0f + EMFAnimationEntityContext.getTickDelta();
        }
        long upTimeInTicks = emfState.world().method_8510();
        return EMFAnimationEntityContext.constrainedFloat(upTimeInTicks, 27720) + EMFAnimationEntityContext.getTickDelta();
    }

    public static float getDayTime() {
        if (emfState == null || emfState.world() == null) {
            return 0.0f + EMFAnimationEntityContext.getTickDelta();
        }
        return EMFAnimationEntityContext.constrainedFloat(emfState.world().method_8532(), 31415) + EMFAnimationEntityContext.getTickDelta();
    }

    public static float getDayCount() {
        if (emfState == null || emfState.world() == null) {
            return 0.0f + EMFAnimationEntityContext.getTickDelta();
        }
        return emfState.world().method_8532() / 27720L;
    }

    public static float getHealth() {
        float f;
        if (emfState == null) {
            return 0.0f;
        }
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof class_1309) {
            class_1309 alive = (class_1309)eMFEntity;
            f = alive.method_6032();
        } else {
            f = 1.0f;
        }
        return f;
    }

    public static float getDeathTime() {
        float f;
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof class_1309) {
            class_1309 alive = (class_1309)eMFEntity;
            f = alive.field_6213 > 0 ? (float)alive.field_6213 + EMFAnimationEntityContext.getTickDelta() : 0.0f;
        } else {
            f = 0.0f;
        }
        return f;
    }

    public static float getAngerTime() {
        if (!(EMFAnimationEntityContext.emfEntity() instanceof class_5354)) {
            return 0.0f;
        }
        float currentKnownHighest = knownHighestAngerTimeByUUID.getInt((Object)emfState.uuid());
        int angerTime = ((class_5354)EMFAnimationEntityContext.emfEntity()).method_29507();
        if (angerTime <= 0) {
            knownHighestAngerTimeByUUID.put((Object)emfState.uuid(), 0);
            return 0.0f;
        }
        if ((float)angerTime > currentKnownHighest) {
            knownHighestAngerTimeByUUID.put((Object)emfState.uuid(), angerTime);
        }
        return (float)angerTime - EMFAnimationEntityContext.getTickDelta();
    }

    public static float getAngerTimeStart() {
        return EMFAnimationEntityContext.emfEntity() instanceof class_5354 ? (float)knownHighestAngerTimeByUUID.getInt((Object)emfState.uuid()) : 0.0f;
    }

    public static float getMaxHealth() {
        float f;
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof class_1309) {
            class_1309 alive = (class_1309)eMFEntity;
            f = alive.method_6063();
        } else {
            f = 1.0f;
        }
        return f;
    }

    public static float getId() {
        return emfState == null ? 0.0f : (float)(Math.abs(emfState.optifineId()) % 27720);
    }

    public static float getHurtTime() {
        float f;
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof class_1309) {
            class_1309 alive = (class_1309)eMFEntity;
            f = alive.field_6235 > 0 ? (float)alive.field_6235 - EMFAnimationEntityContext.getTickDelta() : 0.0f;
        } else {
            f = 0.0f;
        }
        return f;
    }

    public static float getHeightAboveGround() {
        if (!(EMFAnimationEntityContext.emfEntity() instanceof class_1297)) {
            return 0.0f;
        }
        float y = EMFAnimationEntityContext.getEntityY();
        class_2338 pos = emfState.blockPos();
        int worldBottom = emfState.world().method_31607();
        while (!emfState.world().method_8320(pos).method_26168((class_1922)emfState.world(), pos, (class_1297)EMFAnimationEntityContext.emfEntity()) && pos.method_10264() > worldBottom) {
            pos = pos.method_10074();
        }
        return y - (float)pos.method_10264();
    }

    public static float getFluidDepthDown() {
        if (emfState == null || emfState.world().method_8316(emfState.blockPos()).method_15769()) {
            return 0.0f;
        }
        class_2338 pos = emfState.blockPos();
        int worldBottom = emfState.world().method_31607();
        while (!emfState.world().method_8316(pos).method_15769() && pos.method_10264() > worldBottom) {
            pos = pos.method_10074();
        }
        return emfState.blockPos().method_10264() - pos.method_10264();
    }

    public static float getFluidDepthUp() {
        if (emfState == null || emfState.world().method_8316(emfState.blockPos()).method_15769()) {
            return 0.0f;
        }
        class_2338 pos = emfState.blockPos();
        int worldTop = emfState.world().method_31600();
        while (!emfState.world().method_8316(pos).method_15769() && pos.method_10264() < worldTop) {
            pos = pos.method_10084();
        }
        return pos.method_10264() - emfState.blockPos().method_10264();
    }

    public static float getFluidDepth() {
        if (emfState == null || emfState.world().method_8316(emfState.blockPos()).method_15769()) {
            return 0.0f;
        }
        return EMFAnimationEntityContext.getFluidDepthDown() + EMFAnimationEntityContext.getFluidDepthUp() - 1.0f;
    }

    public static boolean isInWater() {
        return emfState != null && emfState.isTouchingWater();
    }

    public static boolean isBurning() {
        return emfState != null && emfState.isOnFire();
    }

    public static boolean isRiding() {
        return emfState != null && emfState.hasVehicle();
    }

    public static boolean isChild() {
        class_1309 alive;
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        return eMFEntity instanceof class_1309 && (alive = (class_1309)eMFEntity).method_6109();
    }

    public static boolean isOnGround() {
        return emfState != null && emfState.isOnGround();
    }

    public static boolean isClimbing() {
        class_1309 alive;
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        return eMFEntity instanceof class_1309 && (alive = (class_1309)eMFEntity).method_6101();
    }

    public static boolean isAlive() {
        if (emfState == null) {
            return false;
        }
        return emfState.isAlive();
    }

    public static boolean isUsingItem() {
        if (emfState == null) {
            return false;
        }
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof class_1309) {
            class_1309 entity = (class_1309)eMFEntity;
            return entity.method_6115();
        }
        return false;
    }

    public static boolean isSwingingArm(boolean right) {
        if (emfState == null) {
            return false;
        }
        if (EMFAnimationEntityContext.getSwingProgress() == 0.0f && !EMFAnimationEntityContext.isUsingItem()) {
            return false;
        }
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof class_1309) {
            boolean usingMainHand;
            class_1309 entity = (class_1309)eMFEntity;
            boolean isRightHanded = entity.method_6068() == class_1306.field_6183;
            boolean bl = usingMainHand = entity.method_6058() == class_1268.field_5808;
            if (right) {
                return isRightHanded == usingMainHand;
            }
            return isRightHanded != usingMainHand;
        }
        return false;
    }

    public static boolean isHoldingItem(boolean right) {
        if (emfState == null) {
            return false;
        }
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof class_1309) {
            boolean isRightHanded;
            class_1309 entity = (class_1309)eMFEntity;
            boolean bl = isRightHanded = entity.method_6068() == class_1306.field_6183;
            class_1268 arm = right ? (isRightHanded ? class_1268.field_5808 : class_1268.field_5810) : (isRightHanded ? class_1268.field_5810 : class_1268.field_5808);
            return !entity.method_5998(arm).method_7960();
        }
        return false;
    }

    public static boolean isAggressive() {
        class_1308 mob;
        class_8152 targets;
        class_5354 angry;
        if (emfState == null) {
            return false;
        }
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof class_1560) {
            class_1560 enderman = (class_1560)eMFEntity;
            return enderman.method_7028();
        }
        eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof class_1545) {
            class_1545 blaze = (class_1545)eMFEntity;
            return blaze.method_5809();
        }
        eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof class_1577) {
            class_1577 guardian = (class_1577)eMFEntity;
            return guardian.method_7052() != null;
        }
        eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof class_1632) {
            class_1632 vindicator = (class_1632)eMFEntity;
            return vindicator.method_6510();
        }
        eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof class_1617) {
            class_1617 caster = (class_1617)eMFEntity;
            return caster.method_7137();
        }
        eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof class_1634) {
            class_1634 vex = (class_1634)eMFEntity;
            return vex.method_7176();
        }
        eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof class_5354 && (angry = (class_5354)eMFEntity).method_29511()) {
            return true;
        }
        eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof class_8152 && (targets = (class_8152)eMFEntity).method_5968() != null) {
            return true;
        }
        eMFEntity = EMFAnimationEntityContext.emfEntity();
        return eMFEntity instanceof class_1308 && (mob = (class_1308)eMFEntity).method_6510();
    }

    public static boolean isGlowing() {
        return emfState != null && emfState.isGlowing();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isHurt() {
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (!(eMFEntity instanceof class_1309)) return false;
        class_1309 alive = (class_1309)eMFEntity;
        if (alive.field_6235 <= 0) return false;
        return true;
    }

    public static boolean isInHand() {
        return setInHand;
    }

    public static boolean isInItemFrame() {
        return setInItemFrame;
    }

    public static boolean isInGround() {
        class_1676 proj;
        EMFEntity eMFEntity;
        return is_in_ground_override || (eMFEntity = EMFAnimationEntityContext.emfEntity()) instanceof class_1676 && (proj = (class_1676)eMFEntity).method_5757();
    }

    public static boolean isInGui() {
        return class_310.method_1551().field_1755 != null && !((Mixin_GuiEntityTester)class_310.method_1551().method_1561()).isShouldRenderShadow();
    }

    public static boolean isClientHovered() {
        if (emfState == null) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        if (emfState.isBlockEntity()) {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                class_239 block;
                class_1297 entity;
                float f = emfState.distanceTo((class_1297)player);
                float f2 = player.method_7337() ? 5.0f : 4.5f;
                if (f <= f2 + 1.0f && (entity = mc.method_1560()) != null && (block = entity.method_5745(20.0, 0.0f, false)).method_17783() == class_239.class_240.field_1332) {
                    return ((class_3965)block).method_17777().equals((Object)emfState.blockPos());
                }
            }
            return false;
        }
        return mc.field_1692 != null && mc.field_1692.equals((Object)EMFAnimationEntityContext.emfEntity());
    }

    public static boolean isInLava() {
        return emfState != null && emfState.isInLava();
    }

    public static boolean isInvisible() {
        return emfState != null && emfState.isInvisible();
    }

    public static boolean isOnHead() {
        return setIsOnHead;
    }

    public static boolean isOnShoulder() {
        return onShoulder;
    }

    public static void setCurrentEntityOnShoulder(boolean onShoulder) {
        EMFAnimationEntityContext.onShoulder = onShoulder;
    }

    public static boolean isRidden() {
        return emfState != null && emfState.hasPassengers();
    }

    public static boolean isSitting() {
        class_7689 camel;
        class_1493 wolf;
        class_1451 cat;
        class_1453 parrot;
        class_4019 fox;
        class_1321 tame;
        if (emfState == null) {
            return false;
        }
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        return eMFEntity instanceof class_1321 && (tame = (class_1321)eMFEntity).method_6172() || (eMFEntity = EMFAnimationEntityContext.emfEntity()) instanceof class_4019 && (fox = (class_4019)eMFEntity).method_18272() || (eMFEntity = EMFAnimationEntityContext.emfEntity()) instanceof class_1453 && (parrot = (class_1453)eMFEntity).method_6172() || (eMFEntity = EMFAnimationEntityContext.emfEntity()) instanceof class_1451 && (cat = (class_1451)eMFEntity).method_6172() || (eMFEntity = EMFAnimationEntityContext.emfEntity()) instanceof class_1493 && (wolf = (class_1493)eMFEntity).method_6172() || (eMFEntity = EMFAnimationEntityContext.emfEntity()) instanceof class_7689 && (camel = (class_7689)eMFEntity).method_45350();
    }

    public static boolean isSneaking() {
        return emfState != null && emfState.isSneaking();
    }

    public static boolean isSprinting() {
        return emfState != null && emfState.isSprinting();
    }

    public static boolean isTamed() {
        class_1321 tame;
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        return eMFEntity instanceof class_1321 && (tame = (class_1321)eMFEntity).method_6181();
    }

    public static boolean isWet() {
        return emfState != null && emfState.isWet();
    }

    public static float getSwingProgress() {
        float f;
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof class_1309) {
            class_1309 alive = (class_1309)eMFEntity;
            f = alive.method_6055(EMFAnimationEntityContext.getTickDelta());
        } else {
            f = 0.0f;
        }
        return f;
    }

    public static float getAge() {
        if (emfState == null) {
            return 0.0f + EMFAnimationEntityContext.getTickDelta();
        }
        return EMFAnimationEntityContext.constrainedFloat(emfState.age(), 27720) + EMFAnimationEntityContext.getTickDelta();
    }

    private static float constrainedFloat(float value, int constraint) {
        return value >= (float)constraint ? value % (float)constraint : value;
    }

    private static float constrainedFloat(float value) {
        return EMFAnimationEntityContext.constrainedFloat(value, 27720);
    }

    private static float constrainedFloat(long value, int constraint) {
        return value >= (long)constraint ? value % (long)constraint : value;
    }

    private static float constrainedFloat(long value) {
        return EMFAnimationEntityContext.constrainedFloat(value, 27720);
    }

    private static float constrainedFloat(int value, int constraint) {
        return value >= constraint ? value % constraint : value;
    }

    private static float constrainedFloat(int value) {
        return EMFAnimationEntityContext.constrainedFloat(value, 27720);
    }

    public static float getFrameTime() {
        if (class_310.method_1551().method_1493()) {
            return 0.0f;
        }
        if (class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_54719().method_54754()) {
            return 0.0f;
        }
        return class_310.method_1551().method_1534() / 20.0f;
    }

    public static float getLimbAngle() {
        if (emfState == null) {
            return 0.0f;
        }
        if (Float.isNaN(limbAngle)) {
            EMFAnimationEntityContext.doLimbValues();
        }
        return limbAngle;
    }

    public static void setLimbAngle(float limbAngle) {
        EMFAnimationEntityContext.limbAngle = limbAngle;
    }

    public static float getLimbDistance() {
        if (emfState == null) {
            return 0.0f;
        }
        if (Float.isNaN(limbDistance)) {
            EMFAnimationEntityContext.doLimbValues();
        }
        return limbDistance == Float.MIN_VALUE ? 0.0f : limbDistance;
    }

    public static void setLimbDistance(float limbDistance) {
        EMFAnimationEntityContext.limbDistance = limbDistance;
    }

    private static void doLimbValues() {
        EMFEntity eMFEntity;
        float o = 0.0f;
        float n = 0.0f;
        assert (emfState != null);
        if (!emfState.hasVehicle() && (eMFEntity = EMFAnimationEntityContext.emfEntity()) instanceof class_1309) {
            class_1309 alive = (class_1309)eMFEntity;
            o = alive.field_42108.method_48572(EMFAnimationEntityContext.getTickDelta());
            n = alive.field_42108.method_48570(EMFAnimationEntityContext.getTickDelta());
            if (alive.method_6109()) {
                o *= 3.0f;
            }
            if (n > 1.0f) {
                n = 1.0f;
            }
        } else if (EMFAnimationEntityContext.emfEntity() instanceof class_1688) {
            n = 1.0f;
            o = -(EMFAnimationEntityContext.getEntityX() + EMFAnimationEntityContext.getEntityZ());
        } else {
            eMFEntity = EMFAnimationEntityContext.emfEntity();
            if (eMFEntity instanceof class_1690) {
                class_1690 boat = (class_1690)eMFEntity;
                n = 1.0f;
                o = Math.max(boat.method_7551(1, EMFAnimationEntityContext.getTickDelta()), boat.method_7551(0, EMFAnimationEntityContext.getTickDelta()));
            }
        }
        limbDistance = n;
        limbAngle = o;
    }

    public static float getHeadYaw() {
        if (emfState == null) {
            return 0.0f;
        }
        if (Float.isNaN(headYaw)) {
            EMFAnimationEntityContext.doHeadValues();
        }
        return headYaw;
    }

    public static void setHeadYaw(float headYaw) {
        EMFAnimationEntityContext.headYaw = headYaw;
    }

    public static float getHeadPitch() {
        if (emfState == null) {
            return 0.0f;
        }
        if (Float.isNaN(headPitch)) {
            EMFAnimationEntityContext.doHeadValues();
        }
        return headPitch;
    }

    public static void setHeadPitch(float headPitch) {
        EMFAnimationEntityContext.headPitch = headPitch;
    }

    private static void doHeadValues() {
        EMFEntity eMFEntity = EMFAnimationEntityContext.emfEntity();
        if (eMFEntity instanceof class_1309) {
            class_1297 class_12972;
            class_1309 livingEntity = (class_1309)eMFEntity;
            float h = class_3532.method_17821((float)EMFAnimationEntityContext.getTickDelta(), (float)livingEntity.field_6220, (float)livingEntity.field_6283);
            float j = class_3532.method_17821((float)EMFAnimationEntityContext.getTickDelta(), (float)livingEntity.field_6259, (float)livingEntity.field_6241);
            float k = j - h;
            if (livingEntity.method_5765() && (class_12972 = livingEntity.method_5854()) instanceof class_1309) {
                class_1309 livingEntity2 = (class_1309)class_12972;
                h = class_3532.method_17821((float)EMFAnimationEntityContext.getTickDelta(), (float)livingEntity2.field_6220, (float)livingEntity2.field_6283);
                k = j - h;
                float l = class_3532.method_15393((float)k);
                if (l < -85.0f) {
                    l = -85.0f;
                }
                if (l >= 85.0f) {
                    l = 85.0f;
                }
                h = j - l;
                if (l * l > 2500.0f) {
                    h += l * 0.2f;
                }
                k = j - h;
            }
            float m = class_3532.method_16439((float)EMFAnimationEntityContext.getTickDelta(), (float)livingEntity.field_6004, (float)livingEntity.method_36455());
            if (class_922.method_38563((class_1309)livingEntity)) {
                m *= -1.0f;
                k *= -1.0f;
            }
            headPitch = m;
            headYaw = k >= 180.0f || k < -180.0f ? class_3532.method_15393((float)k) : k;
        } else {
            headPitch = 0.0f;
            headYaw = 0.0f;
        }
    }

    public static float getTickDelta() {
        return class_310.method_1551().method_1493() ? ((MinecraftClientAccessor)class_310.method_1551()).getPausePartialTick() : class_310.method_1551().method_1488();
    }

    public static float getMoveForward() {
        if (emfState == null) {
            return 0.0f;
        }
        double lookDir = Math.toRadians(90.0f - emfState.yaw());
        class_243 velocity = emfState.emfVelocity();
        double x = velocity.field_1352;
        double y = velocity.field_1350;
        double newX = x * Math.cos(lookDir) - y * Math.sin(lookDir);
        return EMFAnimationEntityContext.processMove(newX, x, y);
    }

    public static float getMoveStrafe() {
        if (emfState == null) {
            return 0.0f;
        }
        double lookDir = Math.toRadians(90.0f - emfState.yaw());
        class_243 velocity = emfState.emfVelocity();
        double x = velocity.field_1352;
        double y = velocity.field_1350;
        double newY = x * Math.sin(lookDir) + y * Math.cos(lookDir);
        return EMFAnimationEntityContext.processMove(newY, x, y);
    }

    private static float processMove(double value, double x, double y) {
        double totalMovementVector = Math.sqrt(x * x + y * y);
        if (totalMovementVector == 0.0) {
            return 0.0f;
        }
        return (float)(-(value / totalMovementVector));
    }

    public static float getShadowSize() {
        return shadowSize;
    }

    public static void setShadowSize(float shadowSize) {
        EMFAnimationEntityContext.shadowSize = shadowSize;
    }

    public static float getShadowOpacity() {
        return shadowOpacity;
    }

    public static void setShadowOpacity(float shadowOpacity) {
        EMFAnimationEntityContext.shadowOpacity = shadowOpacity;
    }

    public static float getLeashX() {
        return leashX;
    }

    public static void setLeashX(float leashX) {
        EMFAnimationEntityContext.leashX = leashX;
    }

    public static float getLeashY() {
        return leashY;
    }

    public static void setLeashY(float leashY) {
        EMFAnimationEntityContext.leashY = leashY;
    }

    public static float getLeashZ() {
        return leashZ;
    }

    public static void setLeashZ(float leashZ) {
        EMFAnimationEntityContext.leashZ = leashZ;
    }

    public static float getShadowX() {
        return shadowX;
    }

    public static void setShadowX(float shadowX) {
        EMFAnimationEntityContext.shadowX = shadowX;
    }

    public static float getShadowZ() {
        return shadowZ;
    }

    public static void setShadowZ(float shadowZ) {
        EMFAnimationEntityContext.shadowZ = shadowZ;
    }

    public static IterationContext getIterationContext() {
        return new IterationContext(EMFManager.getInstance().entityRenderCount, emfState, layerFactory, lodFrameSkipping, shadowSize, shadowOpacity, leashX, leashY, leashZ, shadowX, shadowZ);
    }

    public static void setIterationContext(IterationContext context) {
        EMFManager.getInstance().entityRenderCount = context.entityRenderCount;
        emfState = context.emfState;
        layerFactory = context.layerFactory;
        lodFrameSkipping = context.lodFrameSkipping;
        shadowSize = context.shadowSize;
        shadowOpacity = context.shadowOpacity;
        leashX = context.leashX;
        leashY = context.leashY;
        leashZ = context.leashZ;
        shadowX = context.shadowX;
        shadowZ = context.shadowZ;
    }

    public record IterationContext(long entityRenderCount, @Nullable EMFEntityRenderState emfState, Function<class_2960, class_1921> layerFactory, Boolean lodFrameSkipping, float shadowSize, float shadowOpacity, float leashX, float leashY, float leashZ, float shadowX, float shadowZ) {
    }
}

