/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math;

import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_model_features.models.animation.math.variables.VariableRegistry;

public class MathVariable
extends MathValue
implements MathComponent {
    private final MathValue.ResultSupplier resultSupplier;
    private final String name;

    public MathVariable(String variableName, boolean isNegative, MathValue.ResultSupplier supplier) {
        super(isNegative);
        this.resultSupplier = supplier;
        this.name = variableName;
    }

    public MathVariable(String variableName, MathValue.ResultSupplier supplier) {
        this.resultSupplier = supplier;
        this.name = variableName;
    }

    static MathComponent getOptimizedVariable(String variableName, boolean isNegative, EMFAnimation calculationInstance) {
        if (variableName.startsWith("-")) {
            return VariableRegistry.getInstance().getVariable(variableName.substring(1), true, calculationInstance);
        }
        return VariableRegistry.getInstance().getVariable(variableName, isNegative, calculationInstance);
    }

    @Override
    MathValue.ResultSupplier getResultSupplier() {
        return this.resultSupplier;
    }

    public String toString() {
        return "variable[" + this.name + "]=" + this.getResult();
    }
}

