/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.methods.optifine;

import java.util.List;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathMethod;

public class RandomMethod
extends MathMethod {
    private final boolean hasSeed;

    public RandomMethod(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        boolean bl = this.hasSeed = args.size() == 1 && !args.get(0).isBlank();
        if (this.hasSeed) {
            MathComponent arg = RandomMethod.parseArg(args.get(0), calculationInstance);
            this.setSupplierAndOptimize(() -> this.nextValue(arg.getResult()), arg);
        } else {
            this.setSupplierAndOptimize(this::nextValue);
        }
    }

    protected float nextValue(float seed) {
        int hash = RandomMethod.optifineIntHash(Float.floatToIntBits(seed));
        return (float)Math.abs(hash) / 2.1474836E9f;
    }

    protected float nextValue() {
        return (float)Math.random();
    }

    public static int optifineIntHash(int x) {
        x = x ^ 0x3D ^ x >> 16;
        x += x << 3;
        x ^= x >> 4;
        return (x *= 668265261) ^ x >> 15;
    }

    @Override
    protected boolean canOptimizeForConstantArgs() {
        return this.hasSeed;
    }

    @Override
    protected boolean hasCorrectArgCount(int argCount) {
        return argCount == 1 || argCount == 0;
    }
}

